#include "mbed.h"

Serial pc(dp16,dp15);
DigitalOut myled(dp1);
DigitalOut led2(dp4);
InterruptIn int1(dp14);
InterruptIn int2(dp13);
Timer t;
Timeout reset;
bool first = true;
bool timeAvailable = false;

void reset1();
void reset2();

float timeArray[3];  //important. this stores the delays between vibration detections
                   //right now only indices 0 and 1 are used


//Code from: http://mbed.org/users/ThatcherC/code/WatchDogTest/
class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_SYSCON->SYSAHBCLKCTRL = LPC_SYSCON->SYSAHBCLKCTRL|(1<<15);
        LPC_SYSCON->WDTCLKSEL = 0x1;                // Set CLK src to Main Clock
        LPC_SYSCON->WDTCLKUEN = 0x01;       /* Update clock */
        LPC_SYSCON->WDTCLKUEN = 0x00;       /* Toggle update register once */
        LPC_SYSCON->WDTCLKUEN = 0x01;
        LPC_SYSCON->WDTCLKDIV = 0x10;
        uint32_t clk = SystemCoreClock/16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->TC = s * (float)clk;
        LPC_WDT->MOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->FEED = 0xAA;
        LPC_WDT->FEED = 0x55;
    }
};

Watchdog w;     //used to reset the microcontroller when/if it halts
                   
void flip1(){
    if(first){
        t.start();
        int1.fall(NULL);
        first = false;
        reset.attach(&reset1,0.01);
    }else{
        t.stop();
        timeArray[0]=t.read();
        reset.detach();
        timeAvailable=true;
        first = true;
    }
    myled = 1;
}

void flip2(){
    if(first){
        t.start();
        int2.fall(NULL);
        first = false;
        reset.attach(&reset2,0.01);
    }else{
        t.stop();
        timeArray[1]=t.read();
        reset.detach();
        timeAvailable=true;
        first = true;
    }
    led2 = 1;
}

void reset1(){              //used to reset interrupt 1 if too much time passes
    t.stop();
    t.reset();
    first = true;
    int1.fall(&flip1);
}

void reset2(){              //used to reset interrupt 1 if too much time passes
    t.stop();
    t.reset();
    first = true;
    int2.fall(&flip2);
}

int main() {
    pc.baud(115200);
    pc.printf("Ready\n");
    w.kick(.1);
    int1.fall(&flip1);
    int2.fall(&flip2);
    timeArray[0] = 0;
    timeArray[1] = 0;
    timeArray[2] = 0;   //for now this isn't used (only two sensors)
    while(1){
        if(timeAvailable){
            int tA0 = int(timeArray[0]*1000000);
            int tA1 = int(timeArray[1]*1000000);
            pc.printf("%i\t",tA0-tA1);
            t.reset();
            timeArray[0] = 0;
            timeArray[1] = 0;
            timeArray[2] = 0;   //for now this isn't used (only two sensors)
            timeAvailable=false;
            wait(.1);
            int1.fall(&flip1);
            int2.fall(&flip2);
        }
        w.kick();
    }
}
