#include "mbed.h"
 
 I2C master(P0_29, P0_28);
 Serial pc(USBTX, USBRX); // tx, rx
 int gauge = 0x34 << 1;
 DigitalOut led_full(P0_17);
 DigitalOut led_low(P0_21);
 
const char *byte_to_binary(int x)
{
    static char b[9];
    b[0] = '\0';

    int z;
    for (z = 128; z > 0; z >>= 1)
    {
        strcat(b, ((x & z) == z) ? "1" : "0");
    }

    return b;
}
 
void write_register(int address, int value){
    char data[2] = {address, value};
    int status = master.write(gauge, data, 2);
    printf( "  \"i2c.write()\" done. status = 0x%02X\r\n", status );
}
    
    
 int read_register(int address){
    char reg_address[1] = {address};
    char stored_value[2];
    int readfail1, readfail2;
    readfail1 = master.write(gauge, reg_address, 1, true);
    readfail2 = master.read(gauge, stored_value, 1);
    if (readfail1 | readfail2) {
        pc.printf(" read failed ");
    }
    return (int)stored_value[0]; 
}
 
 
int read_voltage (void){
    char data[2], volt_reg[1];     
    volt_reg[0] = 0x0c;
    int writefail, readfail;
    writefail = master.write(gauge, volt_reg, 1, true);
    readfail = master.read(gauge, data, 2);
    //pc.printf("voltage readfail: %d, voltage writefail: %d \r\n", readfail,writefail);
    int rawVolt= (((data[0] &~(1<<7))<<3)|((data[1]>>5)&0xF));
    return (float)(rawVolt*4.88);      
}

int read_current(void) {
    char data[2], curReg[1];
    curReg[0] = 0x0E;
    int rawCur;
    master.write(gauge, curReg, 1, true);
    master.read(gauge, data, 2);
    if (data[0]>>7 == 1) {
        rawCur = (((data[0]<<8)|data[1])^0xFFFF)+1;
    } else {
        rawCur = (((data[0]<<8)|data[1]));   
    }
    return (float)(rawCur*0.07813);
}
 
 int main() {
    wait(4);   
    int i = 0;
    master.frequency(100000);

        int ACRmsbA = 0x10, ACRlsbA = 0x11;
        int ctrlA = 0x60, ABA = 0x61, acmsbA = 0x62, aclsbA = 0x63, vchgA = 0x64, iminA = 0x65, vaeA = 0x66, iaeA = 0x67, ae40A = 0x68, rsnsA = 0x69, full40msbA = 0x6a;
        int full40lsbA = 0x6b, full3040A = 0x6c, full2030A = 0x6d, full1020A = 0x6e, full0010A = 0x6F, AE3040A = 0x70, AE2030A = 0x71, AE1020A = 0x72, AE0010A = 0x73;
        int SE3040A = 0x74, SE2030A = 0x75, SE1020A = 0x76, SE0010A = 0x77;
        
        int ACRmsbV = 0x01; //estimation of current mAh msb, where lsb has a resolution of 312.5e-6 Ah
        int ACRlsbV = 0xBD; //estimation of current mAh lsb, this totals 0x01BD (=4445) * 312.5e-6 = 0.139 Ah
        int ctrlV = 0x40;
        int ABV = 0x00; // accumulation bias = 0
        int acmsbV = 0x01; //aging capacity, set to rated capacity for defaults
        int aclsbV = 0xF0; // 0x07a0 (=1952) * 312.5e-6* = 0.610 Ah (grote batterij) 0x01F0 (=496) * 312.5e-6 = 0.155 Ah
        int vchgV = 0xD0; // fully charged voltage = 0xD0 (=208) * 0.01952 = 4.06016 V
        int iminV = 0x20; // maximum current to detect a fully charged state: 0x20 (=32) * 0.0025 [A] = 80 mA
        int vaeV = 0xa0; //active empty voltage 0xa0 (=160) * 0.01952 = 3.1232 V
        int iaeV = 0x03; //active empty current 0x03 (=3) * 0.01 [A] = 30 mA
        int ae40V = 0x05; //zie ds2780 guide
        int rsnsV = 0x32; // 1/0.02=50
        int full40msbV = 0x01; //slightly less than rated capacity, which is stored in AC
        int full40lsbV = 0xEA;
        int full3040V = 0x0e, full2030V = 0x13, full1020V = 0x33, full0010V = 0x3b;
        int AE3040V = 0x05, AE2030V = 0x0b, AE1020V = 0x12, AE0010V = 0x27;
        int SE3040V = 0x03, SE2030V = 0x04, SE1020V = 0x07, SE0010V = 0x17;
        
        // niet vergeten vooraan addresses te zetten mocht learn niet lukken: ACRmsbA, ACRlsbA
        // niet vergeten vooraan values te zetten mocht learn niet lukken: ACRmsbV, ACRlsbV
        int addresses[] = {ctrlA, ABA, acmsbA, aclsbA, vchgA, iminA, vaeA, iaeA, ae40A, rsnsA, full40msbA, full40lsbA, full3040A, full2030A, full1020A, full0010A, AE3040A, AE2030A, AE1020A, AE0010A, SE3040A, SE2030A, SE1020A, SE0010A};
        int values[] = {ctrlV, ABV, acmsbV, aclsbV, vchgV, iminV, vaeV, iaeV, ae40V, rsnsV, full40msbV, full40lsbV, full3040V, full2030V, full1020V, full0010V, AE3040V, AE2030V, AE1020V, AE0010V, SE3040V, SE2030V, SE1020V, SE0010V};
        
        //for ( i = 0; i <=  sizeof(addresses)/4-1; i++){
        //    pc.printf("Writing into register: %d \t value: %d\r\n",addresses[i], values[i]); 
        //    write_register( addresses[i], values[i] ); //write the register values to the shadow ram
        //}
        
        //write_register( 0xFE, 0x44 ); // write the shadow ram to the EEPROM
        write_register( 0xFE, 0xB4 ); // write the EEPROM values back to the registers
        
    while(1) {  
        wait(2);
        pc.printf("ingevulde registers:\n\r");               
        for ( i = 0; i <= sizeof(addresses)/4-1; i++){
            //test = read_register( addresses[i] );
            pc.printf( "Reading from register: %d \t value: %d\n\r", addresses[i], read_register(addresses[i]) );
        }
        pc.printf("IAVG_msb: %d \t IAVG_lsb: %d \r\n", read_register(0x08), read_register(0x09));
        pc.printf("current_msb: %d \t current_lsb: %d \r\n", read_register(0x0E), read_register(0x0F));
        pc.printf("Status: %s\r\n", byte_to_binary(read_register(0x01)));
        pc.printf("voltage: %d mV\r\n", read_voltage());
        pc.printf("current: %d mA\r\n", read_current());
        pc.printf("RARC : %d \r\n", read_register(0x06));
        pc.printf("RAAC : %d \r\n", read_register(0x03));
        if (read_register(0x06) >= 100) {
            led_full = 1;
        } else {
            led_full = 0;
        }
        if (read_register(0x06) <= 15) {
            led_low = 1;
        } else {
            led_low = 0;
        }
    }
}