//--------------RFID---------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open        /
//RFID MISO=pin4   ->   Nucleo SPI_MISO=PA_6=D12    /
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=PA_7=D11    /
//RFID SCK=pin2    ->   Nucleo SPI_SCK =PA_5=D13    /
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10    /
//RFID RST=pin7    ->   Nucleo         =PA_9=D7     /
//3.3V and Gnd to the respective pins               /
//---------------------------------------------------


#include "mbed.h"
#include "MFRC522.h"
#include "TextLCD.h"
#include <string> 
#define MF_RESET    D7
#define Device_Name_ADDR   (0xEE) // Device You Wish to Use Address - using i2c Address
#define WRITE              (0x00) // i2c Write bit
#define READ               (0x01) // i2c Read bit
#include "HX711.h"


DigitalOut gpo(D0);
HX711 scale(A0, A1);

AnalogIn scaleRaw(A3);
float calibration_factor = 1000; //-7050 worked for my 440lb max scale setup
int averageSamples = 100;

//-----------Test SW-------------------------------
DigitalIn SW(USER_BUTTON);


//--------------RFID---------------------------------
MFRC522    RfChip   (D11, D12, D13, D10, D8);
// I2C Communication
I2C i2c_lcd(D14, D15); // SDA, SCL
//---------------------------------------------------


//--------------LCD---------------------------------
//I2C Portexpander PCF8574
TextLCD_I2C lcd(&i2c_lcd, 0x4e, TextLCD::LCD20x4); // I2C bus, PCF8574 Slaveaddress, LCD Type ok
short FF=0;
char ucdata_write[2];
void I2CScan ();
//--------------------------------------------------


//--------------PC---------------------------------
Serial pc(SERIAL_TX, SERIAL_RX);
//-------------------------------------------------


//--------------ESP32---------------------------------
Serial esp(PA_9,PA_10); // Serial for esp32 (tx, rx)
//----------------------------------------------------


int main() 
{
    esp.baud(115200);   //----------------------------------------------ESP Baud
    pc.baud(9600);      //-----------------------------------------------PC Baud
    RfChip.PCD_Init();  //----------------------------------------------Function
    lcd.cls();          //------------------------------------------Clear screen
    float weight;
    int Card_Value;
    char Card_UID[100];
    string UID;
    int count = 0;
    int count_step = 0;
    
    
     scale.setScale(0);
    scale.tare(); //Reset the scale to 0
    
    long zero_factor = scale.averageValue(averageSamples);
    
    pc.printf("starting...\n");
    
    
    while (1) 
    {
        // ---------------------------------------------------Look for new cards
        if ( ! RfChip.PICC_IsNewCardPresent())
        {
          wait_ms(500);
          continue;
        }
    
        // ------------------------Select one of the cards
        if ( ! RfChip.PICC_ReadCardSerial())
        {
          wait_ms(500);
          continue;
        }
        // --------------------------------------------------------Find Card UID
        pc.printf("Card UID: ");
        for (uint8_t i = 0; i < RfChip.uid.size; i++)
        {
          pc.printf(" %X", RfChip.uid.uidByte[i]);
          Card_Value += RfChip.uid.uidByte[i]; // ---- Add all int of Card UID
          sprintf (Card_UID,"%X ",RfChip.uid.uidByte[i]);
          UID += Card_UID;
        }
       
        pc.printf("\n");
         pc.printf("%d\n",Card_Value);
        //-------------------------------Show Name on LCD by sum of int(CardUID)       
        if ( Card_Value == 644 )
        {
            scale.setScale(calibration_factor); //Adjust to this calibration factor
            float weight = scale.getGram();
            while ( count <= 5  )
            {
                pc.printf("%f\n\n",weight);
                pc.printf(".");
                if ( weight > 3
                 )
                {
                    lcd.cls();
                    lcd.setBacklight(TextLCD::LightOff);
                    pc.printf("\nSomeone Go Inside Car");
                    pc.printf("\nCollecting weight\n");
                    //weight =750.73;
                    esp.printf("%s,%f",UID,weight);
                    pc.printf("%s,%f",UID,weight);
                    count = 5;
                    count_step = 1;
                }
                else if ( count <= 3)
                {
                    lcd.cls();
                    pc.printf("Name     > Krittapong\n");
                    pc.printf("Surname  >  Pohdoy\n");
                    lcd.setBacklight(TextLCD::LightOn);
                    lcd.setCursor(TextLCD::CurOff_BlkOn);
                    lcd.printf("Name    >Krittapong\n");
                    lcd.printf("Surname >Pohdoy\n");
                    //lcd.printf(" Welcome :)\n");
                    pc.printf("waiting for step");
                    
                }
                else if (count == 4)
                {
                    lcd.cls();
                    lcd.printf("No one enter\n");
                    lcd.setBacklight(TextLCD::LightOff);
                    lcd.cls();
                }
                count++;
                wait(1);
            }
            if ( count >= 5 && count_step == 0 )
            {
                pc.printf("\n\n no one go inside \n\n");
            }
        }
        
        else if ( Card_Value == 475 )
        {
            scale.setScale(calibration_factor); //Adjust to this calibration factor
            float weight = scale.getGram();
            while ( count <= 5  )
            {
                pc.printf(".");
                if ( weight > 100 )
                {
                    lcd.cls();
                    lcd.setBacklight(TextLCD::LightOff);
                    pc.printf("\nSomeone Go Inside Car");
                    pc.printf("\nCollecting weight\n");
                    //weight =930.35;
                    esp.printf("%s,%f",UID,weight);
                    pc.printf("%s,%f",UID,weight);
                    count = 5;
                    count_step = 1;
                }
                else if ( count <= 3)
                {
                    lcd.cls();
                    pc.printf("Name   >Natchapat\n");
                    pc.printf("Surname>Mongkolluck\n");
                    lcd.setBacklight(TextLCD::LightOn);
                    lcd.setCursor(TextLCD::CurOff_BlkOn);
                    lcd.printf("Name   >Natchapat\n");
                    lcd.printf("Surname>Mongkolluck\n");
                    //lcd.printf(" Welcome :)\n");
                    pc.printf("waiting for step");
                    
                }
                else if (count == 4)
                {
                    lcd.cls();
                    lcd.printf("No one enter\n");
                    lcd.setBacklight(TextLCD::LightOff);
                    lcd.cls();
                }
                count++;
                wait(1);
            }
            if ( count >= 5 && count_step == 0 )
            {
                pc.printf("\n\n no one go inside \n\n");
            }
        }       
        //-----------------------------------------------------------Reset Value
        UID = "";
        Card_Value = 0;
        wait_ms(1000);
        count = 0;
        //weight = 0;
        //----------------------------------------------------------------------

    }// close     while (true) 
}// close main
//--------------Void------------------------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------LCD
void I2CScan()
{
    unsigned int uibaudrate=9600;
   pc.baud(uibaudrate);
   
   unsigned int uifrequency=400000; //400KHz for i2c Max
   i2c_lcd.frequency (uifrequency);
   
   pc.printf("\n\rHello World ");
   pc.printf("at %u BAUD and %uKHz i2c Frequency\n\r",uibaudrate,uifrequency/1000);
   pc.printf("Using mbed.org Martin\n\r");
   
 
   ucdata_write[0]=0;ucdata_write[1]=0;
 
   for (int Device_Adress=0;Device_Adress<=0xFE;Device_Adress+=2)//Stepping in 2 Because Read/Write use LSB
   {
   if (!i2c_lcd.write((Device_Adress|WRITE), ucdata_write, 1, 0))// Check for ACK from i2c Device NB I am 'ORing' the Write Bit
       {
           pc.printf("ACK from the Device at Address %#4x\n\r",Device_Adress);
           FF=FF+1;
           wait(2);
       }
       else
       {
           //Left the following in for development/Future coding
           //pc.printf("\n\rCannot get an ACK from the Device check connections!\n\r");
           //lcd.printf("No ACK from\nDevice!");
       }
   }
   pc.printf("\n\r %d Devices have been detected!\n\r",FF);
     pc.printf("\n\r");
}
//------------------------------------------------------------------------------