/**************************
For high-voltage switching circuit test
2016 Sep. 2-
Hiroyuki Kajimoto
Ver.1.6
2017 Oct 31
Kyouhei Shimazu
***************************/

#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>



DigitalOut SN74LV595_DIN(p14);
DigitalOut SN74LV595_RCLK(p13);
DigitalOut SN74LV595_CLR(p12);
DigitalOut SN74LV595_CLK(p11);
DigitalIn  SN74LV595_DOUT(p10); //Shift register output, so normally it is not connected.

Serial pc(USBTX, USBRX); 
const int SERIAL_SPEED = 921600; //fastest

//DAAD
SPI spiDAAD(p5, p6, p7);     // mosi(master output slave input, miso(not connected), clock signal
DigitalOut DA_sync(p8);        //chip select for AD5452
DigitalOut AD_cs(p9);        //chip select for AD7276

//Other I/O
BusOut myleds(LED1, LED2, LED3, LED4);

// stimulation mode
#define DA_TEST 0xFA //sinusoidal wave mode to test DA
#define SWITCH_TEST 0xFB //switching test mode to test switching
#define PATTERN_TEST 0xFC //switching using data from PC
#define MULTI_ELECTRODE_TEST 0xFD //switching using data from PC
#define RECT 0xFE
#define TRIANGLE 0xFF
#define ENVELOPE 0xEF
#define POWER_UP 0xF1
#define POWER_DOWN 0xF2
#define POWER_MAX 0xF3
#define POWER_ZERO 0xF4
//#define FREQ_UP 0xF5
//#define FREQ_DOWN 0xF6
//#define FREQ_MAX 0xF7
//#define FREQ_ZERO 0xF8
//#define SETVOL 0xF9
#define REFERENCE_VOLTAGE 0xF5
#define RANDOM_VOLTAGE 0xF6
#define SHUFFLE_START 0xF7
#define NEXT_VOLTAGE 0xF8
#define FINISH 0xF9

int Mode = DA_TEST;

const int ELECTRODE_NUM = 16;
const int PC_MBED_STIM_PATTERN = 0xFF;
const int PC_MBED_MEASURE_REQUEST = 0xFE;
const int MBED_PC_MEASURE_RESULT = 0xFF;
short stim_pattern[ELECTRODE_NUM] = { 0 };
short impedance[ELECTRODE_NUM] = { 0 };
int Voltage, tmp = 0;
int SetVol = 0;
char vol[4];
char start[6];
char Fr[4];
int Freq = 100;
double Freqrand = 0;
double LowFreq = 0;
int ftmp = 0;
int num = 0;
int count = 0;
int numtmp = 0;
int number[57] = { 17, 26, 33, 39, 44, 50, 54, 59, 64, 69,//出力値と指令値に差があるので、出力値を10V刻みで出すために指令値を変化させてます
                   74, 79, 84, 89, 94, 97,102,106,111,115,
                  121,125,130,135,139,144,149,154,158,163,
                  168,173,177,183,187,192,197,202,207,210,
                  214,219,224,229,235,239,244,248,252,256,
                  260,264,268,272,276,280,284};
                                    
int RealVol[57] = { 10, 20, 30, 40, 50, 60, 70, 80, 90,100,
                   110,120,130,140,150,160,170,180,190,200,
                   210,220,230,240,250,260,270,280,290,300,
                   310,320,330,340,350,360,370,380,390,400,
                   410,420,430,440,450,460,470,480,490,500,
                   510,520,530,540,550,560,570};
int trigger = 0;
int Randnum[10] = {400,600,200,500,700,200,600,300,600,500};//待機時間の配列
Timer timer;

bool AccessDeny = false;

int random[] = {0, 1, 2, 3};//乱数生成用配列
int size = sizeof(random) / sizeof(int);
int iii = 0;







/******************************************************************************/
/*
 SN74LV595 Data Transfer
 2 bits are required for 1 electrode.
 00 OPEN
 10 GND
 01 HIGH
 11 SHORT
 */
/******************************************************************************/
void SN74LV595FastScan(int usWhichPin)
{
    int ii, pin;
    static int pos;

    SN74LV595_RCLK = 0;
    if (usWhichPin == 0) { //set 01（High)
        SN74LV595_DIN = 0;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
        SN74LV595_DIN = 1;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
        pos = 0;
    }
    else { 
        pin = usWhichPin - pos;
        for (ii = 0; ii < pin; ii++) {//set 10 (GND)
            SN74LV595_DIN = 1;
            SN74LV595_CLK = 1;
            SN74LV595_CLK = 0;
            SN74LV595_DIN = 0;
            SN74LV595_CLK = 1;
            SN74LV595_CLK = 0;
        }
        pos = usWhichPin;
    }
    //Load S/R
    SN74LV595_RCLK = 1;
    SN74LV595_RCLK = 0;
}

/******************************************************************************/
/*
 SN74LV595 init & Clear
 */
/******************************************************************************/
void SN74LV595Clear()
{
    SN74LV595_CLR = 0;
    SN74LV595_RCLK  = 0;
    SN74LV595_CLK = 0;
    SN74LV595_CLK = 1;
    SN74LV595_CLK = 0;
    SN74LV595_CLR = 1;
}

void SN74LV595Init(int TotalPin)
{
    int ii;

    SN74LV595_CLR = 1;
    SN74LV595_CLK = 0;
    SN74LV595_RCLK = 0;
    for (ii = 0; ii < TotalPin; ii++) {
        SN74LV595_DIN = 1;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
        SN74LV595_DIN = 0;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
    }
    //Load S/R
    SN74LV595_RCLK = 1;
    SN74LV595_RCLK = 0;
}


/******************************************************************************/
/*
DA&AD at the same time, using the same SPI clock.
DA output by AD5452(SPI)
AD input by AD7276(SPI)
 */
/******************************************************************************/

short DAAD(short DA)
{
    short AD;

        //enable
    DA_sync = 0;
    AD_cs = 0;
    //simultaneous DA and AD
    AD = spiDAAD.write(DA << 2);
    //disable
    DA_sync = 1;
    AD_cs = 1;

    return AD >> 2;//bottom 2bits are unnecessary
}

void DAADinit()
{
    //Setup SPI, 16bit, falling edge, 48MHz clock
    spiDAAD.format(16, 2);
    spiDAAD.frequency(48000000);
}



/******************************************************************************/
/*
Serial
Evoked when serial data is sent from PC.
 */
/******************************************************************************/
void SerialReceiveInterrupt()
{
    int rcv, i;
    unsigned char data[255];
    
    
    rcv = pc.getc();
    
    if (rcv == SHUFFLE_START) { //20181004追加実験用------------------------------
        int i = size;
        while (i > 1) {
            int j = rand() % i;
            i--;
            int t = random[i];
            random[i] = random[j];
            random[j] = t;
        }
        iii = 0;
        num = 35 + 7*random[iii];
        Voltage = number[num];
        tmp = Voltage;
        numtmp = num;
        int n = sprintf(vol,"%d",RealVol[num]);
        pc.printf(vol);
    }
    //-------------------------------------------------------------------------
        
    else if (rcv == DA_TEST) {
        Mode = DA_TEST;
        myleds = 1;
    }else if (rcv == SWITCH_TEST){
        Mode = SWITCH_TEST;
        myleds = 2;
    }else if (rcv == PATTERN_TEST){
        Mode = PATTERN_TEST;
        myleds = 4;
    }else if (rcv == RECT){
        Mode = RECT;
        myleds = 1;
        myleds = 2;
        Voltage = SetVol;
    }else 
    if (rcv == TRIANGLE){
        Mode = TRIANGLE;
        myleds = 3;
        myleds = 4;
        Voltage = SetVol;
    }else if (rcv == ENVELOPE){
        Mode = ENVELOPE;
        Voltage = 570;
    }
    else if (rcv == PC_MBED_STIM_PATTERN){
        for (i = 0; i < ELECTRODE_NUM; i++){
            data[i] = (unsigned char)pc.getc(); //data is 0 to 150.
        }
        AccessDeny = true;
        for (i = 0; i < ELECTRODE_NUM; i++) {
            stim_pattern[i] = data[i] << 2; //data is converted to 0 to 600V.
        }
        AccessDeny = false;
        
    }else if (rcv == PC_MBED_MEASURE_REQUEST){
        if (AccessDeny == false){
            for (i = 0; i < ELECTRODE_NUM; i++) {
                data[i] = impedance[i];
            }       
        }
        for (i = 0; i < ELECTRODE_NUM; i++){
            pc.putc(data[i]);           
        }
    }else if (rcv == MULTI_ELECTRODE_TEST){
        Mode = MULTI_ELECTRODE_TEST;
        myleds = 5;
    }
    ////20181002追加　実験用-------------------------------------------
    else if (rcv == REFERENCE_VOLTAGE){//基準電圧340V
        num = 35;
        Voltage = number[num];
        tmp = Voltage;
        numtmp = num;
        int n = sprintf(vol, "%d", RealVol[num]);
        pc.printf(vol);
    }
    else if (rcv == RANDOM_VOLTAGE){//ランダム電圧(100~570で20V刻み)
        num = 35 + 7*random[iii];
        Voltage = number[num];
        tmp = Voltage;
        numtmp = num;
        int n = sprintf(vol, "%d", RealVol[num]);
        pc.printf(vol);
    }
    else if (rcv == NEXT_VOLTAGE){//ランダム電圧切り替え
        iii = iii + 1;
        num = 35 + 7*random[iii];
        Voltage = 0;
        tmp = Voltage;
        numtmp = num;
        int n = sprintf(vol, "%d", RealVol[num]);
        pc.printf(vol);
    }else if (rcv == FINISH){//実験終了
       iii = 0;
        num = 0;
        Voltage = 0;
        tmp = Voltage;
        numtmp = num;
        int n = sprintf(vol, "0" );
        pc.printf(vol);
    }
    ////------------------------------------------------------------------------
    else if (rcv == POWER_UP){//配列の中身をずらして出力値を上げる
        num++;
        if(num > 56) num = 56;
        Voltage = number[num];
        tmp = Voltage;
        numtmp = num;
        int n = sprintf(vol,"%d",RealVol[num]);
        pc.printf(vol);
    }else if (rcv == POWER_DOWN){
        num--;
        if(num < 0) num = 0;
        Voltage = number[num];
        tmp = Voltage;
        numtmp = num;
        int n = sprintf(vol,"%d",RealVol[num]);
        pc.printf(vol);
    }else if (rcv == POWER_MAX){//その時点での最大の電圧値に変更
        Voltage = tmp;
        num = numtmp;
        int n = sprintf(vol,"%d",RealVol[num]);
        pc.printf(vol);
    }else if (rcv == POWER_ZERO){//電圧値を0に
        Voltage = 0;
        num = 0;
        int n = sprintf(vol,"%d",RealVol[num]);
        pc.printf(vol);
    }
}



int main()
{
    double t=0.0; 
//    char rcv;
    int i, Stimulating_Electrode = 0;
    short AD;

    DAADinit();
    SN74LV595Init(ELECTRODE_NUM);
    pc.baud(921600);
    pc.attach(SerialReceiveInterrupt);
    timer.start();


    for (int t = 0; t < 8; t++) {
        myleds = 1 << (t % 4);
        wait(0.05);
    }
    myleds = 1;

    while (1) {
        
        if (Mode == DA_TEST) { //sin波を出力します
            t = (double)timer.read_us() * 0.000001;
            AD = DAAD((short)(Voltage * (1.0 + sin(2.0 * 3.1415926 * Freq * t)))); //SinWave
        }else if (Mode == RECT) { //ひげのジョリジョリ(矩形波)を出力します
            while(Mode == RECT){
                t = (double)timer.read_us() * 0.000001;
                for(i =0; i<10; i++){
                    double Freqdevided1 = 200 / Freq;//出力時間
                    double Freqdevided2 = Randnum[i] / Freq;//待機時間は配列でランダム(？)化
                    double Freqint1 = floor(Freqdevided1);//整数化
                    double Freqint2 = floor(Freqdevided2);
                    AD = DAAD(600);
                    wait_ms(Freqint1);
                    DAAD(0);
                    wait_ms(Freqint2);
                    AD = DAAD(400);
                    wait_ms(Freqint1);
                    DAAD(0);
                    wait_ms(Freqint2);
                }
            }
        }
       else if (Mode == TRIANGLE) {//羊の角のゴツゴツ感(三角波)を出力します
            while(Mode == TRIANGLE){
                for(int j = 0; j<10; j++){
                    t = (double)timer.read_us() * 0.000001;
                    double sigma = 0;//フーリエ級数のシグマ
                    for(i = 1; i < 4; i++){
                        sigma += sin(i * 3.1415926 / 2) * sin(i * t * 6.29 * 40)/(i * i);//三角波をフーリエ級数変換したやつ
                        }
                        AD = DAAD((short) 300 + (8 * 300 * sigma / (3.1415926 * 3.1415926)));
                        if(AD < 100 && trigger == 1){//トリガーが1だといくらか待ちます
                            wait_ms(Randnum[j] / 20);
                            trigger = 0;
                        }
                                if(AD > 100 && trigger == 0){//トリガーが0の時は普通に三角波を出力してトリガーを1に変更
                            trigger = 1;
                        }
                   }
            }
        }
       else if (Mode == ENVELOPE){//犬の体のサラサラ感(エンベロープ)を出力します。
           t = (double)timer.read_us() * 0.000001;
           LowFreq = (short)(200 * (1.0 + sin(2.0 * 3.1415926 * 80 * t))); //低周波の方
           AD = DAAD((short)(LowFreq / 2 * ((1.0 + sin(2.0 * 3.1415926 * 320 * (t+5000000))) + (1.0 + sin(2.0 * 3.1415926 * 240 * (t+5000000))))));//低周波の出力を振幅にして合成波を出力します
        }
        else if (Mode == SWITCH_TEST) {//羊の体のモフモフ感(エンベロープ)を出力します 
           t = (double)timer.read_us() * 0.000001;
           LowFreq = (short)(144 * (1.0 + sin(2.0 * 3.1415926 * 7 * t))); //上に同じ
           AD = DAAD((short)(LowFreq * ((1.0 + sin(2.0 * 3.1415926 * 200 * (t+5000000))))));
        }
        else if (Mode == PATTERN_TEST) {//使いません
            SN74LV595Init(ELECTRODE_NUM);    //cleaning & setting
            SN74LV595FastScan(0);//Stimulate the first pin only
            for (i = 0; i < 16; i++) {
                if (i != 0) {
                    SN74LV595FastScan(i);//Stimulate the first pin only
                }
                AD = DAAD(stim_pattern[i]);
                wait_ms(1); //wait for charge
                AD = DAAD(stim_pattern[i]);
                AccessDeny = true;
                impedance[i] = AD;
                AccessDeny = false;
                DAAD(0);
            }
        }
        else if (Mode == MULTI_ELECTRODE_TEST) {//使いません
            t = (double)timer.read_us() * 0.000001;
            if (t >= 8.0) { //repeat 0 to 8.0 seconds
                t = 0.0;
                timer.reset();
                timer.start();
                SN74LV595Clear();    //cleaning
                SN74LV595Init(ELECTRODE_NUM);    //cleaning & setting
                SN74LV595FastScan(0);//Set one bit for the first pin
                Stimulating_Electrode = 0;
                pc.putc(Stimulating_Electrode);
                }
            if ((int)(t / 0.5) > Stimulating_Electrode) { //at 0.5s interval, the stimulating electrode is changed.
                Stimulating_Electrode = (int)(t / 0.5);
                myleds = Stimulating_Electrode; //show the stimulating electrode from 0 to 15.
                SN74LV595FastScan(Stimulating_Electrode);//Shift the bit to stimulate the next electrode. Please note that the parameter of this function should be monotonically increasing (see manual)
                pc.putc(Stimulating_Electrode);
                }
            if ((int)(t *1000000) % 5000 > 2500){//200Hz burst
                AD = DAAD(400);                 
            }else{
                AD = DAAD(0);                               
            }
        }
        
    }

}