/**************************
For high-voltage switching circuit test
2016 Sep. 2-
Hiroyuki Kajimoto
***************************/

#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>

DigitalOut SN74LV595_DIN(p14);
DigitalOut SN74LV595_RCLK(p13);
DigitalOut SN74LV595_CLR(p12);
DigitalOut SN74LV595_CLK(p11);
DigitalIn  SN74LV595_DOUT(p10); //Shift register output, so normally it is not connected.

//DAAD
SPI spiDAAD(p5, p6, p7);     // mosi(master output slave input, miso(not connected), clock signal
DigitalOut DA_sync(p8);        //chip select for AD5452
DigitalOut AD_cs(p9);        //chip select for AD7276

//Other I/O
BusOut myleds(LED1, LED2, LED3, LED4);

// stimulation mode
#define DA_TEST 0xFA //sinusoidal wave mode to test DA

int Mode = DA_TEST;

const int ELECTRODE_NUM = 16;
short stim_pattern[ELECTRODE_NUM] = { 0 };
short impedance[ELECTRODE_NUM] = { 0 };

Timer timer;

bool AccessDeny = false;

int i;
int Freq = 100;



/******************************************************************************/
/*
 SN74LV595 Data Transfer
 2 bits are required for 1 electrode.
 00 OPEN
 10 GND
 01 HIGH
 11 SHORT
 */
/******************************************************************************/
void SN74LV595FastScan(int usWhichPin)
{
    int ii, pin;
    static int pos;

    SN74LV595_RCLK = 0;
    if (usWhichPin == 0) { //set 01（High)
        SN74LV595_DIN = 0;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
        SN74LV595_DIN = 1;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
        pos = 0;
    }
    else { 
        pin = usWhichPin - pos;
        for (ii = 0; ii < pin; ii++) {//set 10 (GND)
            SN74LV595_DIN = 1;
            SN74LV595_CLK = 1;
            SN74LV595_CLK = 0;
            SN74LV595_DIN = 0;
            SN74LV595_CLK = 1;
            SN74LV595_CLK = 0;
        }
        pos = usWhichPin;
    }
    //Load S/R
    SN74LV595_RCLK = 1;
    SN74LV595_RCLK = 0;
}

/******************************************************************************/
/*
 SN74LV595 init & Clear
 */
/******************************************************************************/
void SN74LV595Clear()
{
    SN74LV595_CLR = 0;
    SN74LV595_RCLK  = 0;
    SN74LV595_CLK = 0;
    SN74LV595_CLK = 1;
    SN74LV595_CLK = 0;
    SN74LV595_CLR = 1;
}

void SN74LV595Init(int TotalPin)
{
    int ii;

    SN74LV595_CLR = 1;
    SN74LV595_CLK = 0;
    SN74LV595_RCLK = 0;
    for (ii = 0; ii < TotalPin; ii++) {
        SN74LV595_DIN = 1;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
        SN74LV595_DIN = 0;
        SN74LV595_CLK = 1;
        SN74LV595_CLK = 0;
    }
    //Load S/R
    SN74LV595_RCLK = 1;
    SN74LV595_RCLK = 0;
}


/******************************************************************************/
/*
DA&AD at the same time, using the same SPI clock.
DA output by AD5452(SPI)
AD input by AD7276(SPI)
 */
/******************************************************************************/

short DAAD(short DA)
{
    short AD;

        //enable
    DA_sync = 0;
    AD_cs = 0;
    //simultaneous DA and AD
    AD = spiDAAD.write(DA << 2);
    //disable
    DA_sync = 1;
    AD_cs = 1;

    return AD >> 2;//bottom 2bits are unnecessary
}

void DAADinit()
{
    //Setup SPI, 16bit, falling edge, 48MHz clock
    spiDAAD.format(16, 2);
    spiDAAD.frequency(48000000);
}


int main()
{
    double t=0.0;
    short AD;
    int Randnum[10] = {400,600,200,500,700,200,600,300,600,500};//待機時間の配列

    DAADinit();
    SN74LV595Init(ELECTRODE_NUM);
    timer.start();


    for (int t = 0; t < 8; t++) {
        myleds = 1 << (t % 4);
        wait(0.05);
    }
    myleds = 1;

    while (1) {
             t = (double)timer.read_us() * 0.000001;
                for(i =0; i<10; i++){
                    double Freqdevided1 = 200 / Freq;//出力時間
                    double Freqdevided2 = Randnum[i] / Freq;//待機時間は配列でランダム(？)化
                    double Freqint1 = floor(Freqdevided1);//整数化
                    double Freqint2 = floor(Freqdevided2);
                    AD = DAAD(600);
                    wait_ms(Freqint1);
                    DAAD(0);
                    wait_ms(Freqint2);
                    AD = DAAD(400);
                    wait_ms(Freqint1);
                    DAAD(0);
                    wait_ms(Freqint2);
                }   
    }

}
