/**************************
2020/10/20
編集者：福田哲生

1000Vでの知覚強度と570Vでの知覚強度を比較するためのプログラム
570Vを基準刺激として、570,770,970Vを比較刺激に提示する。
黄：570V
青：770V
白：970V
黒：何巡目かを示すカウンタ

エクセルのシートでランダムな順番を生成しその順で提示
(もっと多くの電圧値を使うならランダム化をmbedで行っても良い)
 

***************************/
#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
 
AnalogOut signal(p18);//AnalogOutピン(1768は18番ピン)
Timer timer;//カウンタ
Timer chtimer;//チャタリング用タイマー
int Freq;//正弦波の周波数
int Volt;//印加電圧値
int i;//カウンタ用

//スイッチ用ピンの宣言
DigitalIn  VoltUp(p14);
DigitalIn  VoltDown(p15);
DigitalIn  FreqUp(p16);
DigitalIn  FreqDown(p17);

int swflag = 0;//スイッチ用フラグ

#define MIN_TIME_DIFF 200//チャタリング用待機時間

//LEDの宣言
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//シリアル通信用の宣言
Serial pc(USBTX, USBRX); 

char vol[12];
char cou[12];


 
int main() {
    double t=0.0;
    int timediff = 0;
    timer.start();
    chtimer.start();
    Volt = 520;
    Freq = 100;
    i = 0;
    
    while(1) {
            if(VoltUp.read() == 1){//黄押すと570Vを出力
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      Volt = 520;
                 }
            chtimer.reset();
            led1 = 1;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            wait(0.2);
            int n = sprintf(vol,"Voltage:%d\n",Volt);//シリアル通信で送る文字列
            pc.printf(vol);
            }
            if(VoltDown.read() == 1){//青押すと770Vを出力
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      Volt = 680;
                 }
            chtimer.reset();
            led1 = 0;
            led2 = 1;
            led3 = 0;
            led4 = 0;
            wait(0.2);
            int n = sprintf(vol,"Voltage:%d\n",Volt);//シリアル通信で送る文字列
            pc.printf(vol);
            }
            if(FreqUp.read() == 1){//白押すと970Vを出力
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      Volt = 970;
                 }
            chtimer.reset();
            led1 = 0;
            led2 = 0;
            led3 = 1;
            led4 = 0;
            wait(0.2);
            int n = sprintf(vol,"Voltage:%d\n",Volt);//シリアル通信で送る文字列
            pc.printf(vol);
            }
            if(FreqDown.read() == 1){//黒押すとカウンターが1増加
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      i = i + 1;
                 }
            chtimer.reset();
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 1;
            wait(0.2);
            int n = sprintf(cou,"Counter%d\n",i);//シリアル通信で送る文字列
            pc.printf(cou);
            }

            //sin波の出力※0~1(0が1000V,1が0V)の値をp18に送るため1000で割る
            t = (double)timer.read_us() * 0.000001;
            signal = 1 - (((0.5 + sin(2.0 * 3.1415926 * Freq * t)/2) * Volt) / 1000);//差動増幅なので1から引いている
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 1;
    }
}
