/**************************
2020/10/09
編集者：福田哲生

回路が新しくなり、AnalogOutから電圧が出力できるようになった。これを受けて出力場所の変更を行う。
これに伴いプログラムを一新することにした。
p18に0~1の出力を行うとそれが0~570Vとして出力できる。
p14~p17で電圧、周波数を10V/Hzずつ変更するようにした。
電圧周波数の初期値は570V/100Hz

黄色：電圧10V上昇
青色：電圧10V下降
白色：周波数10Hz上昇
黒色：周波数10Hz下降

2020/11/26
編集者：福田哲生

先方の要望により、シリアル通信を用いてボタンを押すと現在の
電圧値・周波数を確認できるようにした。(要Teraterm)
***************************/
#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
 
AnalogOut signal(p18);//AnalogOutピン(1768は18番ピン)
Timer timer;//カウンタ
Timer chtimer;//チャタリング用タイマー
int Freq;//正弦波の周波数
int Volt;//印加電圧値

//スイッチ用ピンの宣言
DigitalIn  VoltUp(p14);
DigitalIn  VoltDown(p15);
DigitalIn  FreqUp(p16);
DigitalIn  FreqDown(p17);

int swflag = 0;//スイッチ用フラグ

#define MIN_TIME_DIFF 200//チャタリング用待機時間

//LEDの宣言
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//シリアル通信用の宣言
Serial pc(USBTX, USBRX); 

char vol[12];
char fre[12];

#define POWER_UP 0xF1
#define POWER_DOWN 0xF2
#define FREQ_UP 0xF3
#define FREQ_DOWN 0xF4

 
int main() {
    double t=0.0;
    int timediff = 0;
    timer.start();
    chtimer.start();
    Volt = 570;
    Freq = 100;
    while(1) {
            if(VoltUp.read() == 1){//黄押すと電圧10V増加
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      Volt = Volt + 10;
                      if(Volt > 570){
                          Volt = 570;
                          }
                 }
            chtimer.reset();
            led1 = 1;
            led2 = 0;
            led3 = 0;
            led4 = 0;
            int n = sprintf(vol,"Voltage:%d\n",Volt);//シリアル通信で送る文字列
            pc.printf(vol);
            
            wait(0.5);
            }
            if(VoltDown.read() == 1){//青押すと電圧10V減少
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      Volt = Volt - 10;
                      if(Volt < 0){
                          Volt = 0;
                          }
                 }
            chtimer.reset();
            led1 = 0;
            led2 = 1;
            led3 = 0;
            led4 = 0;
            int n = sprintf(vol,"Voltage:%d\n",Volt);
            pc.printf(vol);
            wait(0.5);
            }
            if(FreqUp.read() == 1){//白押すと周波数10Hz増加
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      Freq = Freq + 10;
                 }
            chtimer.reset();
            led1 = 0;
            led2 = 0;
            led3 = 1;
            led4 = 0;
            int n = sprintf(fre,"Frequency:%d\n",Freq);
            pc.printf(fre);
            wait(0.5);
            }
            if(FreqDown.read() == 1){//黒押すと周波数10Hz減少
                 timediff = chtimer.read_ms();
                 if(timediff > MIN_TIME_DIFF) {
                      Freq = Freq - 10;
                      if(Freq < 0){
                           Freq = 0;
                          }
                 }
            chtimer.reset();
            led1 = 0;
            led2 = 0;
            led3 = 0;
            led4 = 1;
            int n = sprintf(fre,"Frequency:%d\n",Freq);
            pc.printf(fre);
            wait(0.5);
            }
            //sin波の出力※0~１の値をp18に送るため570で割る
            t = (double)timer.read_us() * 0.000001;
            signal = ((0.5 + sin(2.0 * 3.1415926 * Freq * t)/2) * Volt) / 570;
            led1 = 1;
            led2 = 1;
            led3 = 1;
            led4 = 1;
    }
}
