/**************************
For high-voltage switching circuit test
2016 Sep. 2-
Hiroyuki Kajimoto
Ver.1.6
--
2017 Oct 31
Kyouhei Shimazu
--
2019 Dec 23
Tetsuki Fukuda
PCと接続した状態でデモや実験を行うことが出来るプログラム
Original_PC_connecting_demo(福田の前任者が作成したもの)からの変更点は
炭酸のシュワシュワ感を提示することが出来るようになったこと
および不要なプログラムの部分を削除した。
英語のコメントはkajimoto先生から受けとった時点のもの。

以下にこのプログラムの説明を記載する。

回路を接続し実際に操作を行うのはprocessingで行う。
このプログラムの意味としては
PCのキーボード操作のシグナルをmbedが正しく認識し
出力する波形を変更できるようにしている。
またその波形を生み出して(設計しいて)いるのもこのプログラム
ProcessingはあくまでPCのキーボードとmbedを接続するためおよび変更値を文字としてディスプレイに表示させるためのもの。

PCの操作によりmbedに文字列が送られる。
受け取った文字列をrcvという配列に入れる。
この配列に対応した変更がなされる。
変更する内容についてはvoid SerialReceiveInterrupt()に書いてある。
刺激を変更する信号の場合にはModeが変更する。
その他電圧、周波数が変更できるようになっている。
***************************/

#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>

Serial pc(USBTX, USBRX); 

//Other I/O
BusOut myleds(LED1, LED2, LED3, LED4);

//LED1からLED4をled1からled4に割り当てる。
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


// stimulation mode//よくわかってない定義。後日調べる。
#define SINE 0xFA
#define MOFU 0xFB
#define SHUWA 0xFC
#define JORI 0xFE
#define GOTSU 0xFF
#define SARA 0xEF

#define POWER_UP 0xF1
#define POWER_DOWN 0xF2
#define POWER_MAX 0xF3
#define POWER_ZERO 0xF4
#define FREQ_UP 0xF5
#define FREQ_DOWN 0xF6
#define FREQ_MAX 0xF7
#define FREQ_ZERO 0xF8
#define SETVOL 0xF9

int Mode = SINE;

const int ELECTRODE_NUM = 16;
short stim_pattern[ELECTRODE_NUM] = { 0 };
short impedance[ELECTRODE_NUM] = { 0 };
char vol[4];
char Fr[4];
int Freq = 100;
double Freqrand = 0;
double LowFreq = 0;
int Voltage = 100;
int count = 0;
int trigger = 0;
Timer timer;

bool AccessDeny = false;

AnalogOut signal(p18);//AnalogOutピン(1768は18番ピン)

/******************************************************************************/
/*
Serial
Evoked when serial data is sent from PC.
 */
/******************************************************************************/
void SerialReceiveInterrupt()
{
    int rcv;
    
    rcv = pc.getc();
    if (rcv == SINE) {
        Mode = SINE;
        myleds = 1;
    }else if (rcv == MOFU){
        Mode = MOFU;
        myleds = 1;
    }else if (rcv == SHUWA){
        Mode = SHUWA;
        myleds = 1;
    }else if (rcv == JORI){
        Mode = JORI;
        myleds = 1;
    }else if (rcv == GOTSU){
        Mode = GOTSU;
        myleds = 1;
    }else if (rcv == SARA){
        myleds = 1;
        Mode = SARA;
    }
    //
    else if (rcv == POWER_UP){//配列の中身をずらして出力値を上げる
        Voltage = Voltage + 10;
        if(Voltage > 575) Voltage = 570;
        int n = sprintf(vol,"%d",Voltage);
        pc.printf(vol);
    }else if (rcv == POWER_DOWN){
        Voltage = Voltage - 10;
        if(Voltage < 0) Voltage = 0;
        int n = sprintf(vol,"%d",Voltage);
        pc.printf(vol);
    }else if (rcv == POWER_MAX){//その時点での最大の電圧値に変更
        Voltage = 570;
        int n = sprintf(vol,"%d",Voltage);
        pc.printf(vol);
    }else if (rcv == POWER_ZERO){//電圧値を0に
        Voltage = 0;
        int n = sprintf(vol,"%d",Voltage);
        pc.printf(vol);
    }else if (rcv == FREQ_UP){//周波数を上げる
        Freq = Freq + 10;
        if(Freq > 1005) Freq = 1000;
        int m = sprintf(Fr,"%d",Freq);
        pc.printf(Fr);
    }else if (rcv == FREQ_DOWN){
        Freq = Freq - 10;
        if(Freq < 0) Freq = 0;
        int m = sprintf(Fr,"%d",Freq);
        pc.printf(Fr);
    }else if (rcv == FREQ_MAX){
        Freq = 1000;
        int m = sprintf(Fr,"%d",Freq);
        pc.printf(Fr);
    }else if (rcv == FREQ_ZERO){
        Freq = 0;
        int m = sprintf(Fr,"%d",Freq);
        pc.printf(Fr);
    }else if (rcv == SETVOL){//使わないかも
        Freq = 100;
        int m = sprintf(Fr,"%d",Freq);
        pc.printf(Fr);
        pc.printf("Set");
    }
}


int main()//メイン関数イツモココカラ
{
    double t=0.0; 
//    char rcv;
    int i = 0;

    pc.baud(921600);
    pc.attach(SerialReceiveInterrupt);
    timer.start();


    for (int t = 0; t < 8; t++) {
        myleds = 1 << (t % 4);
        wait(0.05);
    }
    myleds = 1;

    while (1) {//このループがスイッチを切るまで永遠に回ってる。6つのモードどれかにあてはまっている。波形をいじりたいときはココをいじる。
        if (Mode == SINE) { //sin波を出力します
            t = (double)timer.read_us() * 0.000001;
            signal = (Voltage * (0.5 + sin(2.0 * 3.1415926 * Freq * t)/2)) / 570;//SinWave
                led1 = 1;
                led2 = 0;
                led3 = 0;
                led4 = 0;
        }
        else if (Mode == JORI) { //ひげのジョリジョリ(矩形波)を出力します
                    signal = Voltage * 0.0017;//570Vで割るとうまく出力されなかったため0.0017をかけている。
                    wait_ms(Freq * 0.02);
                    signal = 0;
                    wait_ms(Freq * 0.01 *(2 + rand()%5));
                    signal = Voltage * 0.0011;
                    wait_ms(Freq * 0.02);
                    signal = 0;
                    wait_ms(Freq * 0.01 *(2 + rand()%5));
                    led1 = 0;
                    led2 = 1;
                    led3 = 0;
                    led4 = 0;           
        }
       else if (Mode == GOTSU) {//羊の角のゴツゴツ感(三角波)を出力します
                for(int j = 0; j<10; j++){
                    t = (double)timer.read_us() * 0.000001;
                    double sigma = 0;//フーリエ級数のシグマ
                    for(i = 1; i < 4; i++){
                        sigma += sin(i * 3.1415926 / 2) * sin(i * t * 6.29 * 40)/(i * i);//三角波をフーリエ級数変換したやつ
                        }
                        signal = ((Voltage/2) + (8 * (Voltage/2) * sigma / (3.1415926 * 3.1415926))) / 570;
                        if(signal < 0.16 && trigger == 1){//トリガーが1だといくらか待ちます
                            wait_ms(10*(1 + rand()%5));
                            trigger = 0;
                        }
                                if(signal > 0.16 && trigger == 0){//トリガーが0の時は普通に三角波を出力してトリガーを1に変更
                            trigger = 1;
                        }
                    led1 = 0;
                    led2 = 0;
                    led3 = 1;
                    led4 = 0;
                    }
        }
         else if (Mode == MOFU) {//羊の体のモフモフ感(エンベロープ)を出力します 
           t = (double)timer.read_us() * 0.000001;
           LowFreq = ((Voltage/4) * (1.0 + sin(2.0 * 3.1415926 * 7 * t))); //上に同じ
           signal = ((LowFreq * ((1.0 + sin(2.0 * 3.1415926 * 200 * (t+5000000)))))) / 570;
                    led1 = 0;
                    led2 = 0;
                    led3 = 0;
                    led4 = 1;
        }
       else if (Mode == SARA){//犬の体のサラサラ感(エンベロープ)を出力します。
           t = (double)timer.read_us() * 0.000001;
           LowFreq = ((Voltage/3 )* (1.0 + sin(2.0 * 3.1415926 * 80 * t))); //低周波の方
           signal = (LowFreq / 2 * ((1.0 + sin(2.0 * 3.1415926 * 320 * (t+5000000))) + (1.0 + sin(2.0 * 3.1415926 * 240 * (t+5000000))))) / 570;//低周波の出力を振幅にして合成波を出力します
                    led1 = 1;
                    led2 = 1;
                    led3 = 0;
                    led4 = 0;
        }
        else if (Mode == SHUWA) {//炭酸のシュワシュワ感を出力します。
                    signal = ((Voltage/6)*(3+rand()%3)) * 0.0017;
                    wait_ms(Freq * 0.01 *(rand()%3) );
                    signal = 0;
                    wait_ms(Freq * 0.1 *(rand()%10));
                    led1 = 1;
                    led2 = 0;
                    led3 = 1;
                    led4 = 0;
        }
        
    }

}