#include "mbed.h"
#include "math.h"

AnalogIn EMG1(PTB0);
AnalogIn EMG2(PTB1);
AnalogIn EMG3(PTB2);
AnalogIn EMG4(PTB3);

//float X_positiewaarde_waarheenwil;
//float Y_positiewaarde_waarheenwil;
//float phi_A;    // motorhoek A in graden
//float phi_B;    // motorhoek B in graden
float EMG_signaal_x;    //ook wel x-dot, het verschil tussen flexoren en extensoren in onderarm 
float EMG_signaal_y;    // ook wel y-dot, het verschil tussen biceps en triceps
const float delta_t = 0.01; // tijd tussen twee meetpunten
float X_positiewaarde_huidig;
float Y_positiewaarde_huidig;
float lengte_arm;


X_positiewaarde_waarheenwil = EMG_signaal_x * delta_t + X_positiewaarde_huidig;
Y_positiewaarde_waarheenwil = EMG_signaal_y * delta_t + Y_positiewaarde_huidig;

phi_A = 180 - 1 / (cos(sqrt((X_positiewaarde_waarheenwil)^2 + (Y_positiewaarde_waarheenwil)^2)/(2 * lengte_arm^2)))) - 1 / tan(fabs(Y_positiewaarde_waarheenwil / X_positiewaarde_waarheenwil));
phi_B = 180 - 1 / (cos(sqrt((X_positiewaarde_waarheenwil)^2 + (Y_positiewaarde_waarheenwil)^2)/(2 * lengte_arm^2)))) - 1 / tan(Y_positiewaarde_waarheenwil / X_positiewaarde_waarheenwil) - 1/(cos(-(X_positiewaarde_waarheenwil^2 + Y_positiewaarde_waarheenwil^2)/(2*lengte_arm^2)+1));

