#include "HMC5883L.h"
#include "main.h"
#include "MPU6050.h"
#include "BMX055.h"
#include "Servo.h"
#include "GPS.h"
#include "mbed.h"
//#include "SDFileSystem.h"

Serial pc(USBTX, USBRX,115200);    // tx, rx

Serial twelite(A7,A2,115200);

#ifdef SDCARD
SDFileSystem sd(A6,A5,A4,A3, "sd"); // the pinout on the mbed Cool Components workshop board
//              mosi,miso,sck,ss(io)
#endif

GPS michibiki(GPSTX,GPSRX);//通常のシリアル通信同じく、gpsのtxをマイコンのrxにつなげる。

#ifdef AXIS_NINE
BMX055 bmx(D4,D5);
#endif


HMC5883L compass(D4,D5);    //SDA,SCL

MPU6050 mpu(D4,D5);

/*==================servo_test======================*/
DigitalOut myled(D12);
DigitalOut myled2(A0);
Servo myservo(D6);
Servo myservo2(D10);
/*                                                  */
/*                                                  */
/*==================================================*/

float mpu_acce[3];
float mpu_gyro[3];
int16_t hmc_data[3] = {0};
double heading = 0.0f;

void pc_tx()//シリアル割り込み
{
        mpu.setAcceleroRange(MPU6050_ACCELERO_RANGE_4G);
        mpu.getAccelero(mpu_acce);
        mpu.getAcceleroRawZ();
        int a = 0x58;
        for(int l = 0; l < 3; l++) 
        {
            printf("%c%c%c%c%c %c  %f\t",0x61,0x63,0x63,0x65,0x6c,a,mpu_acce[l]);
            a++;
        }
        a = 0x58;
        mpu.getGyro(mpu_gyro);
        for(int l = 0; l < 3; l++) 
        {
            printf("%c%c%c%c %c  %f\t",0x67,0x79,0x72,0x6f,a,mpu_gyro[l]);
            a++;
        }
        printf("\r\n");
        
        //        printf("gy_271start\r\n"); //debug
        compass.getXYZ(hmc_data);
        heading = compass.getHeadingXYDeg();
        printf("x: %4d, y: %4d, z: %4d\n", hmc_data[0], hmc_data[1], hmc_data[2]);
        printf("heading: %3.2f\r\n", heading);
        
        printf("%f %f\r\n",michibiki.latitude,michibiki.longtitude);    
}


int main()
{
    pc.attach(pc_tx,Serial::TxIrq);
    /*===================SDcard=========================*/
    /*                                                  */
    /*                                                  */
#ifdef SDCARD
    printf("Hello World!\n");

    mkdir("/sd/mydir", 0777);

    FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp);

    printf("Goodbye World!\n");

#endif
    /*                                                  */
    /*                                                  */
    /*==================================================*/

    /*===================MPU6050========================*/
    /*                                                  */
    /*                                                  */
    /*                                                  */
#ifdef MPU6050_START
    mpu.setAcceleroRange(0);
#endif
    /*                                                  */
    /*                                                  */
    /*==================================================*/


    /*============================================*/
    /*                                                  */
    /*                                                  */
    /*                                                  */

#ifdef GY_271
    compass.init();
#endif
    /*                                                  */
    /*                                                  */
    /*                                                  */
    /*==================================================*/




    /*===================GY_271=========================*/
    /*                                                  */
    /*                                                  */
    /*                                                  */

    while(1) {
        //printf("while start\r\n"); //debug


#ifdef GY_271
        
#endif
        /*                                                  */
        /*                                                  */
        /*                                                  */
        /*==================================================*/


        /*===================MPU6050========================*/
        /*                                                  */
        /*                                                  */
        /*                                                  */
#ifdef MPU6050_START
#endif
        /*                                                  */
        /*                                                  */
        /*==================================================*/

        /*=================servo_test=======================*/
#ifdef servo_test
        myservo = 0.833;
        myservo2 = 0.833;
        wait(1.0);
        myservo = 0.1666;
        myservo2 = 0.1666;
        wait(1.0);
#endif
        /*==================================================*/

#ifdef TWELITE
        /*=====================TWELITE======================*/
//        twelite.printf("main\r\n");
        wait_ms(1);
        /*==================================================*/
#endif
        
        #ifdef MICHIBIKI
        /*=====================MICHIBIKI======================*/
        printf("%f %f\n",michibiki.latitude,michibiki.longtitude);
        wait_ms(1);
        /*==================================================*/
        
        #endif
    }


}