#ifndef _BENCH02_H_
#define _BENCH02_H_

#include "mbed.h"
#include "as5048.h"
#include "lcm101.h"
#include "constants.h"

/**
 * Class to read out sensory information from the second test bench;
 * the upper and lower leg, foot en toe setup with 1-dof hinges,
 * each of which is equipped with an AMS AS5048 absolute rotary sensor.
 * The sensors are daisy chained and communicate via SPI
 */
class Bench {
public:
    
    static const float kCutOffDegrees = 180.0f;
    static const float kCutOffRadians = 3.14159265359f;
    
    enum Joint {
        TOES,
        ANKLE,
        KNEE,
        HIP
    };

    Bench(PinName mosi, PinName miso, PinName sck, PinName cs, PinName p_lcm101);
    
    void Update();

    float getDegrees(int i_joint);
    float getDegrees(Joint joint);

    float getRadians(int i_joint);
    float getRadians(Joint joint);


    const char* getJointName(int i_joint);
    const char* getJointName(Joint joint);

    float getForce();
    
    As5048* get_as5048();


private:
    As5048 as5048_;
    Lcm101 lcm101_;
};

#endif