#ifndef _CONSTANTS_HARDWARE_H_
#define _CONSTANTS_HARDWARE_H_

#include "mbed.h"

#ifndef M_PI
#define M_PI 3.14159265359f
#endif

// SPI Communication AS5048 joint encoders
#define AS5048_MOSI         PTD6        // D11
#define AS5048_MISO         PTD7        // D12
#define AS5048_SCLK         PTD5        // D13
#define AS5048_CS           PTD4        // D10

// SPI Communication external SD CARD 
#define SD_MOSI             PTC6        // D7
#define SD_MISO             PTC7        
#define SD_SCK              PTC5        
#define SD_CS               PTC10       

// LCM101-100 kgf S-beam force sensor
#define LCM101              A3

/**
 * Sensor settings and calibration data
 */
namespace sensors {
    
    // LCM101-100kgf force sensor
    extern const float kLcm101Offset;
    extern const float kLcm101Factor;
    
    // AS5048 abs angle sensor chain
    extern const int kNumJoints;

    extern const char *kJointNames[];
    extern const float kOffsetsDegrees[];
    extern const bool kDirections[];
    
    
}

namespace timing {
    extern const int kTimeControlUs;                    // control loop
    extern const int kTimeLogDataUs;                    // data logging
    extern const int kTimeSerialPrintUs;                // serial printing

    extern const int kSerialBaudrate;
}


#endif