#include "mbed.h"
#include "QEI.h"
#include "MODSERIAL.h"
//#include <"math.h">

QEI motor1(D13,D12,NC, 624);//encoder for motor 1
QEI motor2(D11,D10,NC, 624);//encoder for motor 2
MODSERIAL pc(USBTX,USBRX);
DigitalOut direction1(D7);//direction input for motor 1
DigitalOut direction2(D4);//direction input for motor 2
PwmOut speed1(D6);//speed input for motor 1
PwmOut speed2(D5);//speed input for motor 2
InterruptIn button1(PTC6);//test button for starting motor 1 using intteruptin function
InterruptIn button2(PTA4);//test button for starting motor 2 using interruptin function
DigitalOut led1(LED_RED);
DigitalOut led2(LED_BLUE);
DigitalOut led3(LED_GREEN);
bool motor1_dir=0;//set the direction of motor 1
bool motor2_dir = 0;//set the direction of motor 1

void changedirmotor1(){
        motor1_dir = !motor1_dir;//code for changing direction of motor 1
        }
void changedirmotor2(){
        motor2_dir = !motor2_dir;//code for changing direction of motor 2
        }        


int main()
{
   float cycle = 0.3;//define the speed of the motor
   bool motor1_on = 1;//set the on variable of motor 1
   
   bool motor2_on =1;//set the on variable of motor 2
   int n1=1;//numeric condtions to determine if the speed needs to be increased
   int n2=1;
   bool CW =1;
   bool CCW = 0;
   button1.mode(PullDown);//setting the modes for the way the button signals are registered
   button2.mode(PullDown);

while(1){
       led3.write(0);
       led1.write(1);
       led2.write(1);
       pc.baud(115200);
       
       button1.fall(changedirmotor1);//replacement code for toggle function,  thus changing direction when pressed
       /*
        int diffa1 = -button1.read();//read out the button 1 signal and calculate if it is being pressed or released interrupt function might work better as toggle
        wait(0.3);//from this we can determine if the rotation direction needs to be reversed.
        int diffb1 = button1.read();
        int button_toggle1 = diffa1-diffb1;
        if(button_toggle1 == 1 && motor1_dir == CW){
                motor1_dir = CCW;
                }
        else if(button_toggle1 == 1 && motor1_dir == CCW){
                motor1_dir = CW;
                }       
       */
       if(button1.read() !=motor1_on){//check if button 1 is pressed
                  led3.write(1);
                  led1.write(0);
              while(n1 == 1){
                  speed1.write(cycle);//write speed only on first run through the loop
                  direction1.write(motor1_dir);//turn motor CCW or CW 
                  
                  n1=0;
                  }
                          }
            else if (button1.read() == motor1_on){//when button is released
                while(n1==0){//check if the first run was done
                    speed1.write(0);//if so set speed to 0 and reset the run counter
                    n1=1;
                    }
                }
                button2.fall(changedirmotor2);//replacement code for toggle function,  thus changing direction when pressed
 
       /*
       int diffa2 = button2.read();//read out the button 2 signal and calculate if it is being pressed or released
       wait(0.3);//from this we can determine if the rotation direction needs to be reversed.
       int diffb2 = button2.read();
       int button_toggle2 = diffa2-diffb2;
       if(button_toggle2 == 1 && motor2_dir == CW){
                motor2_dir = CCW;
                }
        else if(button_toggle2 == 1 && motor2_dir == CCW){
                motor2_dir = CW;
                }
    */
   
       if(button2.read()!=motor2_on){//check if button 2 is pressed
                  led3.write(1);
                  led2.write(0);
              while(n2 == 1){
                  speed2.write(cycle);//write speed only on first run through the loop
                  direction2.write(motor2_dir);//turn motor CCW or CW 
                  
                  n2=0;
                  }
                          }
            else if (button2.read() == motor2_on){//when button is released
                while(n2==0){//check if the first run was done
                    speed2.write(0);//if so set speed to 0 and reset the run counter
                    n2=1;
                    }
                }                
}
}