#include "mbed.h"
#include "encoder.h"
#include "MODSERIAL.h"

DigitalOut led(LED_RED);
DigitalOut direction1(D7);
PwmOut speed1(D6);
DigitalIn button(PTC6);

Encoder motor1(D13,D12,true);// call the encoder
MODSERIAL pc(USBTX,USBRX);

int main()
{  
   pc.baud(115200);
   float maximum=1.0;
   direction1.write(false);//turn motor CCW or CW if set to 0
   //motor CW = 0
   //motor CCW = 1
   while(1){//while on, turn on motor
       speed1.period_us(100);//Set period of PWM to 100 us.
       for(float cycle=0.5; cycle < maximum; cycle=cycle + 0.1){
            speed1.write(cycle);//write the new speed to the motor
            wait(1.0);// wait 1 second to switch to higher speed
            }   //it only turns at the last 5 speeds, so about 0.6 till 1.0
   }// the cause of this is the friction it has to work against during rotation
}
       
