#ifndef _LCM101_H_
#define _LCM101_H_

#include "mbed.h"

/**
 * Simple class to read out an LCM101 S-beam force sensor connected to an analog
 * input.
 */
class Lcm101 {
public:

    /**
     * @param pin_a_in PinName of analog input
     * @param offset of analog value (calibration data)
     * @param factor multiplication factor for analog value (calibration data)
     */
    Lcm101(PinName pin_a_in, float offset, float factor) :
        analog_in_(pin_a_in),
        kOffset_(offset),
        kFactor_(factor)
    {
    }

    /**
     * @return unscaled analog input value
     */
    float getForceRaw() 
    {
        return analog_in_.read();
    }

    /**
     * @return force value kOffset_ + kFactor_ * getForceRaw();
     */
    float getForce() 
    {
        return kOffset_ + kFactor_ * getForceRaw();
        //it appears that higher order polynomials show better accuracy, within the 40 kg range that is.
        // Awaiting other instructions, a linear fit will be currently used however.
    }
    
    /**
     * @return ffset of analog value
     */
    float get_offset() { return kOffset_; }
    
    /**
     * @return factor multiplication factor for analog value
     */
    float get_factor() { return kFactor_; }


private:
    AnalogIn analog_in_;
    
    const float kOffset_;
    const float kFactor_;
};

#endif