#include "mbed.h"
#include "HIDScope.h"
#include "biquadFilter.h"        // Require the HIDScope library

//Define objects
AnalogIn    emg(A0); //Analog input
Ticker      sample_timer;
Ticker      filter_timer
HIDScope    scope(2);
biquadFilter filterhigh1(-1.1430 0.4128 0.6389 -1.2779 0.6389);
biquadFilter filterlow1(1.9556 0.9565 0.9780 1.9561 0.9780);
biquadFilter notch(-1.1978e-16 0.9561 0.9780 -1.1978e-16 0.9780);
biquadFilter filterlow2(-1.9645 0.9651 1.5515e-4 3.1030e-4 1.5515e-4);

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    /* First, sample the EMG using the 'read' method of the 'AnalogIn' variable named 'emg' */
    double emg_value = emg.read();
    /* Second, set the sampled emg value in channel zero (the first channel) in the 'HIDScope' variable named 'scope' */
    scope.set(0,emg_value);
    /* Repeat the step above if required for more channels (channel 0 up to 5 = 6 channels) */
    /* Finally, send all channels to the PC at once */
    scope.send();
}
void filtering()
{
double signalpart1 = filterhigh1(emg.read());
double signalpart2 = abs(signalpart1);
double signalpart3 = filterlow1(signalpart2);
double signalpart4 = notch(signalpart3);
double signalfinal = filterlow2(signalpart4);
scope.set(1,signalfinal);
int main()
{
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds
    */
    sample_timer.attach(&sample, 0.002);
    filter_timer.attach(&filtering, 0.002);

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}