#include "PlayTone.h"

PlayTone::PlayTone(PinName PS):_speaker(PS)
{
    offset = 0;
    
    max_BPM = 260;
    min_BPM = 40;
    
    tone[0] = 27.50;
    tone[1] = 29.14;
    tone[2] = 30.87;
    tone[3] = 32.70;    
    tone[4] = 34.65;   
    tone[5] = 36.71;  
    tone[6] = 38.89; 
    tone[7] = 41.20;
    tone[8] = 43.65;
    tone[9] = 46.25;
    tone[10] = 49.00;
    tone[11] = 51.91;
    tone[12] = 55.00;
    tone[13] = 58.27;
    tone[14] = 61.74;
    tone[15] = 65.41;
    tone[16] = 69.30;
    tone[17] = 73.42;
    tone[18] = 77.78;
    tone[19] = 82.41;
    tone[20] = 87.31;
    tone[21] = 92.50;
    tone[22] = 98.00;
    tone[23] = 103.83;
    tone[24] = 110.00;
    tone[25] = 116.54;
    tone[26] = 123.47;
    tone[27] = 130.81;
    tone[28] = 138.59;
    tone[29] = 146.83;
    tone[30] = 155.56;
    tone[31] = 164.81;
    tone[32] = 174.61;
    tone[33] = 185.00;
    tone[34] = 196.00;
    tone[35] = 207.65,
    tone[36] = 220.00;
    tone[37] = 233.08;
    tone[38] = 246.94;
    tone[39] = 261.63;
    tone[40] = 277.18;
    tone[41] = 293.66;
    tone[42] = 311.13;
    tone[43] = 329.63;
    tone[44] = 349.23;
    tone[45] = 369.99;
    tone[46] = 392.00;
    tone[47] = 415.30,
    tone[48] = 440.00;
    tone[49] = 466.16;
    tone[50] = 493.88;
    tone[51] = 523.25;
    tone[52] = 554.37;
    tone[53] = 587.33;
    tone[54] = 622.25;
    tone[55] = 659.26;
    tone[56] = 698.46;
    tone[57] = 739.99;
    tone[58] = 783.99;
    tone[59] = 830.61,
    tone[60] = 880.00;
    tone[61] = 932.33;
    tone[62] = 987.77;
    tone[63] = 1046.50;
    tone[64] = 1108.73;
    tone[65] = 1174.66;
    tone[66] = 1244.51;
    tone[67] = 1318.51;
    tone[68] = 1396.91;
    tone[69] = 1479.98;
    tone[70] = 1567.98;
    tone[71] = 1661.22,
    tone[72] = 1760.00;
    tone[73] = 1864.66;
    tone[74] = 1975.53;
    tone[75] = 2093.00;
    tone[76] = 2217.46;
    tone[77] = 2349.32;
    tone[78] = 2489.02;
    tone[79] = 2637.02;
    tone[80] = 2793.83;
    tone[81] = 2959.96;
    tone[82] = 3135.96;
    tone[83] = 3322.44;
    tone[84] = 3520.00;
}

void PlayTone::playTone(int ind, float value)
{
    int pos = ind+offset;
    
    pos = (pos<0)? 0 : pos;
    pos = (pos>84)? 84 : pos;
    
    _speaker.play(tone[pos], _bpm_ms*value);
}

void PlayTone::playStaccato(int ind, float value)
{
    int pos = ind+offset;
    
    pos = (pos<0)? 0 : pos;
    pos = (pos>84)? 84 : pos;
    
    _speaker.play(tone[pos], _bpm_ms*_duty);
    int rest = _bpm_ms*float(value - _duty);
    wait_ms(rest);
}

void PlayTone::silence(float value)
{
    wait_ms(_bpm_ms*value);
}

void PlayTone::stop()
{
    _speaker.stop();
}

void PlayTone::transpose(int level)
{
    offset = level;
}

void PlayTone::playSequence(int sequence_length, int notes[], float values[])
{
    for(int i=0; i< sequence_length; i++)
    {
        if(notes[i] > 1)
            playTone(notes[i],values[i]);
        else
            silence(values[i]);
    }
}

void PlayTone::playSequence(int sequence_length, Note notes[])
{
    for(int i=0; i< sequence_length; i++)
    {
        if(notes[i].idx > 1)
            playTone(notes[i].idx,notes[i].value);
        else
            silence(notes[i].value);
    }
}

void PlayTone::playStaccatoSequence(int sequence_length, int notes[], float values[])
{
    for(int i=0; i< sequence_length; i++)
    {
        if(notes[i] > 0)
            playStaccato(notes[i],values[i]);
        else
            silence(values[i]);
    }
}

void PlayTone::playStaccatoSequence(int sequence_length, Note notes[])
{
    for(int i=0; i< sequence_length; i++)
    {
        if(notes[i].idx > 0)
            playStaccato(notes[i].idx,notes[i].value);
        else
            silence(notes[i].value);
    }
}

int PlayTone::setBPM(int Bpm)
{
    _bpm = (Bpm < min_BPM)? min_BPM : Bpm;
    _bpm = (Bpm > max_BPM)? max_BPM : Bpm;
    
    _bpm_ms = 60*1000/_bpm;
    
    return int(_bpm_ms);
}

void PlayTone::setStaccatoDuty(float duty)
{
    _duty = (duty > 1)? 1 : duty;
    _duty = (duty < 0)? 0 : duty;
}