#ifndef PIEZO
#define PIEZO

#include "mbed.h"

/** Class for the PWM Piezo speaker.
 *  This class is using PWM to make sounds with piezo speaker.
 *  Currently tested with LPC1768.\n\n
 *
 *
 *                                      Writen by: Jan Crha (TeaPack_CZ), 2016.
 *
 *  Last modified: 2016-10-01
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *  #include "Piezo.h"
 *
 *  Piezo PS(p21);
 *
 *  int main(){
 *      int playTime = 120;
 *
 *      for(int i=0; i<2; i++)
 *      {
 *          PS.play(466.16,playTime);
 *          wait_ms(playTime);
 *          PS.play(415.30,playTime);
 *          wait_ms(playTime);
 *    
 *          PS.play(466.16,playTime);
 *          wait_ms(playTime);
 *          PS.play(349.23,playTime);
 *          wait_ms(playTime);
 *    
 *          PS.play(277.18,playTime/2);
 *          wait_ms(playTime/2);
 *          PS.play(349.23,playTime/2);
 *          wait_ms(playTime/2);
 *          wait_ms(playTime);
 *          PS.play(233.08,playTime/2);
 *          wait_ms(playTime/2);
 *    
 *          wait_ms(playTime*4);
 *      }
 *  }
 * @endcode
 */

class Piezo
{
public:
    
    /** Constructor, Pin must be PWM capable*/
    Piezo(PinName Pwmout);
    
    /** Blocking function for playing sound of given frequency and
     *       duration in ms
     */
    void play(float, int);
    
    /** Nonblocking function for playing sound of given frequency and 
     *      duration in ms
     */
    void playAsync(float, int);
    
    /** Function for stopping all sounds */
    void stop();
    
private:
    PwmOut _pwm;
    Ticker _timer;

    float Period;

    float min_freq;
    float max_freq;
};

#endif