#include "Encoder.h"

Encoder::Encoder(PinName InA, PinName InB) : _pinA(InA), _pinB(InB), _inA(InA), _inB(InB) {
        _inA.rise(this,&Encoder::inAhi);
        _inA.fall(this,&Encoder::inAlo);
        _inB.rise(this,&Encoder::inBhi);
        _inB.fall(this,&Encoder::inBlo);  
        
        puls = 0;
        dist = 0;
        total_dist = 0;
}

int Encoder::getDist()
{
    dist=puls;
    puls=0;
    total_dist+=dist;
    return dist;
}

int Encoder::getTotalDist()
{
    return total_dist;
}

void Encoder::clr()
{
    total_dist=0;
}

void Encoder::setEnabled(bool state)
{
    if(state)
    {
        enabled = 1;
        enable_irq();
    }
    else
    {
        enabled = 0;
        disable_irq();
    }
}

bool Encoder::isEnabled()
{
    return enabled;
}

// ********************
// *** Private voids **
// ********************

void Encoder::enable_irq()
{
    _inA.enable_irq();
    _inB.enable_irq();
}

void Encoder::disable_irq()
{
    _inA.disable_irq();
    _inB.disable_irq();
}

void Encoder::inAhi()
{
    if(_pinB)
        puls--;
    else
        puls++;
}

void Encoder::inAlo()
{
    if(_pinB)
        puls++;
    else
        puls--;
}

void Encoder::inBhi()
{
    if(_pinA)
        puls++;
    else
        puls--;
}

void Encoder::inBlo()
{
    if(_pinA)
        puls--;
    else
        puls++;
}
