/** Class for the digital quadrature encoder.
 *  This class is using two pins for detecting all edges generated by the quadrature encoder.\n\n
 *  
 *
 *                                      Writen by: Jan Crha (TeaPack_CZ), 2016.
 *
 *  Last modified: 2016-09-21
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *  #include "Encoder.h"
 *  
 *  Serial PC(USBTX,USBRX);
 *  Encoder encoder(p11,p12);
 *  
 *  int main(){
 *  
 *  encoder.setEnabled(true);
 *  
 *  while(1)
 *  {
 *      PC.printf("%d",encoder.getDist());
 *      wait(0.1);
 *  }
 *  }
 * @endcode
 */

#include "mbed.h"

class Encoder{
    
public:
    
    /** Class contructor.
     *  Both pins have to be compatible with the InterruptIn class.
     */
    Encoder(PinName InA, PinName InB);
    
    /** Function for repetitive getting counts from the encoder
     *  @return returns number of edges detected from the last call
     */
    int getDist();
    
    /** Function returning total counts, direction dependent.
     *  counts can be set to zero by calling function clr()
     */
    int getTotalDist();
    
    /** Function setting total distance to zero*/
    void clr();
    
    /** Function for enabling encoder interrupts detection*/
    void setEnabled(bool);
    
    /** Function for getting state of encoders */
    bool isEnabled();
    
private:

    void enable_irq();
    void disable_irq();
    
    DigitalIn _pinA;
    DigitalIn _pinB;
    InterruptIn _inA;
    InterruptIn _inB;
    
    int puls;
    int dist;
    int total_dist;
    bool enabled;
    
    void inAhi();
    void inAlo();
    void inBhi();
    void inBlo();
};