#include "MotorDriver.h"

MotorDriver::MotorDriver(PinName Pwm, PinName DirA, PinName DirB) : _pwm(Pwm), _dirA(DirA), _dirB(DirB){
        _dirA = 0;
        _dirB = 0;
        _pwm.period_us(50);
        _pwm.write(0.0);
        enabled = 0;
}

void MotorDriver::setSpeed(float power_f)
{
    bool dir;
    int speed = abs(power_f);
    
    if(power_f < 0)
        dir = 1;
    else
        dir = 0;

    setSpeed(dir,speed);        
}

void MotorDriver::setSpeed(bool dir, int power)
{
    if(enabled)
    {
        _pwm.write(0.0);
        _dirA = 0;
        _dirB = 0;
        _dirA = dir;
        _dirB = !dir;
        _pwm.write(power/100.0);
    }
}
    
void MotorDriver::setEnabled(bool newState)
{
    enabled = newState;
    if(!enabled)
        stop();
}

bool MotorDriver::isEnabled()
{
    return enabled;
}

void MotorDriver::stop()
{
    _pwm.write(0.0);
    _dirA = 0;
    _dirB = 0;
}
    
void MotorDriver::hold()
{
    if(enabled)
    {
        _pwm.write(0.0);
        wait(0.001);
        _dirA = 1;
        _dirB = 1;
    }
}