/** Simple data logger using local flash memory.
 *  Every start it creates a new file LOGnn.TXT, where nn stands for number of files.
 *  Counting files on /local is based on an example code of LocalFileSystem class.
 *  Every msg will be saved on a new line.
 *
 *                                      Writen by: Jan Crha (TeaPack_CZ), 2014
 *
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *  #include "logger.h"
 *  
 *  Logger logg();
 *  char bfr[127];
 *  
 *  int i=1;
 *  char ch='L';
 *  float f=1.1;
 *
 *  int main(){
 *      logg.open();
 *      sprintf(bfr,"format your msg as you wish, %d,%c,%f",i,ch,f);
 *      logg.save(bfr);
 *      logg.close();
 *  }
 *  @endcode
 */

#include "mbed.h"

class Logger {
public:
    /** Class constructor */
    Logger();
    
    /** Opening function */
    void open();
    
    /** Closing function */
    void close();
    
    /** Function for adding a new line to log */
    void nl();
    
    /** Function for logging data */
    void save(char[]);
    
private:

    LocalFileSystem local;
    FILE * _logger;
    int get_files();
    void mk_path(int);
    char dst[30];
    
};

