#include "loger.h"

Logger::Logger() : local("local")
{
}

void Logger::open()
{
    mk_path(get_files());
    _loger = fopen(dst, "w");
} 

void Logger::save(char save[])
{
    fprintf(_loger,"%s",save);
    nl();
}

void Logger::nl()
{
    fprintf(_logger,"\r\n");
} 

void Logger::close()
{
    fprintf(_logger,"### END FILE ###\r\n");
    fclose(_logger);
}

int Logger::get_files()
{
    int num=0;
    DIR *d = opendir("/local");     // Opens the root directory of the local file system
    struct dirent *p;
    while((p = readdir(d)) != NULL)
    {
        num++;
    }
    closedir(d);
    return num;
}

void Loger::mk_path(int nmbr)
{
    sprintf(dst,"/local/log%02d.txt",nmbr);
}

