
#include "EasyLube.h"
#include "mbed.h"
#include "MTSLog.h"

EasyLube::Activity EasyLube::getActivity(void)
{
    DigitalIn  input(PA_0);
    DigitalIn  data0(PB_0);
    DigitalIn  data1(PB_1);
    DigitalIn  data2(PA_1);

    uint8_t data = 0;
    if(data0)
    {
        data |= (1 << 0); 
    }
    if(data1)
    {
        data |= (1 << 1);  
    }
    if(data2)
    {
        data |= (1 << 2);   
    }

    if(input)
    {
        logInfo("AtTin45 waarde: %d", data);
        
        if(data == 0)
        {
            logInfo("Starting with data: POWER_UP");
            return POWER_UP;
        }else if(data == 1)
        {
            logInfo("Starting with data: ERROR");
            return ERROR;
        }else if(data == 2)
        {
            logInfo("Starting with data: DOSAGE");
            return DOSAGE;
        }else if(data == 3)
        {
            logInfo("Starting with data: STARTING");
            return STARTING;
        }else if(data == 4)
        {
            logInfo("Starting with data: ALIVE");
            return ALIVE;
        }
        
        logInfo("AtTin45 waarde: %d", data);
        return NONE; 
    }
    
    logInfo("Signal-pin was niet hoog"); 
    return NO_SIGNAL;    
}