#include "mbed.h"
#include "neopixel.h"
 
// This must be an SPI MOSI pin.
#define DATA_PIN dp2

#define N_COL   8
#define N_ROW   8
#define N_LED   (N_COL * N_ROW)

#define N_WAVE  128

float wave[N_WAVE];
int   gSpeed;

void generate(neopixel::Pixel * out, uint32_t index, uintptr_t extra)
{
    uint8_t red, green, blue;
    
    int x = index % N_COL;

    red = green = blue = 0;
    uint8_t val = 8.0 * wave[((x+extra)*gSpeed) % N_WAVE] + 16.0 * wave[extra % N_WAVE] + 16.0;
    val = val / 2;
    if (x <= 2) {
        blue = val;
    } else if (x <= 5) {
        red = green = blue = val / 2;
    } else {
        red = val;
    }

    out->red   = red;
    out->green = green;
    out->blue  = blue;
}
 
int main()
{
    // Create a temporary DigitalIn so we can configure the pull-down resistor.
    // (The mbed API doesn't provide any other way to do this.)
    // An alternative is to connect an external pull-down resistor.
    DigitalIn(DATA_PIN, PullDown);
 
    // The pixel array control class.
    neopixel::PixelArray array(DATA_PIN);
 
    for (int i = 0; i < N_WAVE; i++) {
        wave[i] = sin((float)i / (float)N_WAVE * 3.14159265 * 2.0) * 0.5 + 0.5;
    }
    
    int offset = 0;
    gSpeed = 8;
    
    while(1) {
        array.update(generate, N_LED, offset++);
        if (offset >= N_WAVE) {
            offset = 0;
            gSpeed = (rand() % 8) + 4;
        }
        
        wait_ms(20);
    }                
}
