#include "mbed.h"
#include "rtos.h"

const int deviceOffset = 0;


#define MaxReceiveBufferSize 100


void setPNumLeftAndRight();

void disableTicker();
void enableTicker();

void dynamicDriver();
void count();


char num0[] = {126,129,129,129,129,129,126,0};
char num1[] = {0,1,65,255,1,1,0,0};
char num2[] = {33,67,133,137,137,113,1,0};
char num3[] = {66,129,145,145,145,145,110,0};
char num4[] = {24,40,72,136,8,255,8,0};
char num5[] = {242,145,145,145,145,145,142,0};
char num6[] = {126,145,145,145,145,145,78,0};
char num7[] = {192,128,128,143,144,160,192,0};
char num8[] = {110,145,145,145,145,145,110,0};
char num9[] = {114,137,137,137,137,137,126,0};
char col[]   = {0, 0, 0, 36, 0, 0, 0, 0};
char space[] = {0, 0, 0, 0, 0, 0, 0, 0};

char *nums[] = {num0, num1, num2, num3, num4, num5, num6, num7, num8, num9};

BusOut row(    dp9,  dp2, dp11,  dp1, dp17, dp13, dp25, dp14);     // anode
BusOut common(dp28, dp26, dp16, dp10, dp15,  dp6,  dp4, dp18);     // casode

I2CSlave slave(dp5, dp27);


//Ticker secondRate;
Ticker frameRate;
Ticker dynamicRate;


int iDisplayBuffer = 0;
int nDisplayBuffer;

char displayBuffer[MaxReceiveBufferSize];
char *pNumLeft;     // 出力中の数字ビットパターン、左側
char *pNumRight;    // 出力中の数字ビットパターン、右側
int  iShift = 0;        // 0 - 7 ... 現在何ビットずれているか


char * getBitPatternWithPosition(int inPos)
{
    char *result = space;

    int pos = (iDisplayBuffer + deviceOffset + inPos) % nDisplayBuffer;
    char c = displayBuffer[pos];
    if (c == ' ') {
        result = space;
    } else if (c == ':') {
        result = col;
    } else {
        result = nums[c  - '0'];
    }

    return result;
}


void setPNumLeftAndRight()
{
    pNumLeft = getBitPatternWithPosition(0);
    pNumRight = getBitPatternWithPosition(1);
}


//int second = 0;
//int minute = 0;
//int hour   = 0;
//
////  if -1 the display is shift automatically
//int autoShiftWindow = -1;
//
//void secondVector()
//{
//    second++;
//    if (second >= 60) {
//        second = 0;
//        minute ++;
//        if (minute >= 60) {
//            minute = 0;
//            hour++;
//            if (hour >= 24) {
//                hour = 0;
//            }
//        }
//    }
//
//    if (autoShiftWindow != -1) {
//        autoShiftWindow++;
//    }
//}


void shiftVector(const void* arg)
{
    iShift++;
    if (iShift >= 8) {
        iShift = 0;

        iDisplayBuffer++;
        if (iDisplayBuffer >= nDisplayBuffer) {
            iDisplayBuffer = 0;
        }
        setPNumLeftAndRight();
    }
}


static int iYoko = 0;
static int pYoko = 1;


void dynamicVector(void const* arg)
{
    int i = iYoko + iShift;

    common = 0x00;
    char rowData = (i < 8) ? pNumLeft[i] : pNumRight[i % 8];
    row    = rowData & 0x00ff;
    common = (pYoko)    & 0x00ff;
    iYoko++;
    pYoko *= 2;
    if (iYoko == 8) {
        iYoko = 0;
        pYoko = 1;
    }
}


//void disableTicker()
//{
//    secondRate.detach();
//    frameRate.detach();
//    dynamicRate.detach();
//}

//void enableTicker()
//{
//    secondRate.attach(secondVector,   1.0000);
//    frameRate.attach(shiftVector,     0.0500);
//    dynamicRate.attach(dynamicVector, 0.0001);
//}

static char buf[MaxReceiveBufferSize];

int main()
{
    slave.address(0x10 + deviceOffset);

    strcpy(displayBuffer, "x ");
    displayBuffer[0] = deviceOffset + '0';
    nDisplayBuffer = strlen(displayBuffer);

    iDisplayBuffer = 0;
    iShift         = 0;
    setPNumLeftAndRight();

    RtosTimer dynamicTimer(dynamicVector, osTimerPeriodic);
    dynamicTimer.start(1);
    
    RtosTimer frameRate(shiftVector, osTimerPeriodic);
    frameRate.start(50);
    int demoMode = true; 
    
    while(1) {
        int status = slave.receive();
        int charPos, shiftPos;
        switch (status) {
//            case I2CSlave::ReadAddressed:
//                slave.write(msg, strlen(msg) + 1); // Includes null char
//                break;

            case I2CSlave::WriteGeneral:
            case I2CSlave::WriteAddressed:
                if (demoMode) {
                    frameRate.stop();
                    demoMode = false;
                }
                if (slave.read(buf, MaxReceiveBufferSize)) {
                    if (buf[0] == 'x') {
                        charPos  = buf[1] - '0';
                        shiftPos = buf[2] - '0';

                        if (charPos >= 0 && charPos < MaxReceiveBufferSize) {
                            iDisplayBuffer = charPos;
                        }
                        if (shiftPos >= 0 && shiftPos < 8) {
                            iShift = shiftPos;
                        }
                    } else {
                        strncpy(displayBuffer, buf, MaxReceiveBufferSize);
                        displayBuffer[MaxReceiveBufferSize-1] = 0;
                        nDisplayBuffer = strlen(displayBuffer);
                        if (iDisplayBuffer >= nDisplayBuffer) iDisplayBuffer = 0;
                    }
                    setPNumLeftAndRight();
                }
                break;

            default:
                Thread::wait(1);
                break;
        }
    }
}

