#include "mbed.h"
#include "Adafruit_SSD1306.h"
#include "BMP180.h"

DigitalOut myled_R(LED1);

I2C i2c(PB_9, PB_8); // SDA, SCL    arduino pins

Adafruit_SSD1306_I2c myOled(i2c,NC,0x78,32,128);
BMP180 bmp180(&i2c);

int main(void) {

    while(1) {
        if (bmp180.init() != 0) {
            printf("Error communicating with BMP180\n");
        } else {
            printf("Initialized BMP180\n");
            break;
        }
        wait(1);
    }

    while(1) {
        bmp180.startTemperature();
        wait_ms(5);     // Wait for conversion to complete.
        float temp;
        if(bmp180.getTemperature(&temp) != 0) {
            printf("Error getting temperature\n");
            continue;
        }

        bmp180.startPressure(BMP180::ULTRA_LOW_POWER);
        wait_ms(10);    // Wait for conversion to complete
        int pressure;
        if(bmp180.getPressure(&pressure) != 0) {
            printf("Error getting pressure\n");
            continue;
        }
        
        myOled.printf("Temp= %f\r", temp);
        myOled.display();
        wait(0.01);
        
    }
}