/**********************************************************************
* Written by WAVToCode
* Date:             Fri May 03 06:07:07 PM
* FileName:         clap44.C
* Interleaved:      N/A
* Signed:           No
* No. of channels:  1
* No. of samples:   10420
* Bits/Sample:      24
**********************************************************************/

#define num_cl44 10420

const unsigned long cl44_data[num_cl44] = {
8388608, 9887744, 9771008, 10371840, 14968832, 15393792, 15662848, 15865344, /* 0-7 */
11736832, 3371264, 2556928, 2055168, 1689856, 1402880, 1162496, 912640, /* 8-15 */
11254528, 14079232, 14746112, 14429184, 3700224, 1906944, 1397248, 995072, /* 16-23 */
10984192, 14253312, 14871040, 15273728, 15629312, 8621824, 3527680, 1999616, /* 24-31 */
1860096, 6577152, 7646976, 1916928, 1124096, 3025152, 13422592, 14321408, /* 32-39 */
14781952, 15093760, 15258880, 15487488, 15626752, 15738112, 15865600, 13121792, /* 40-47 */
6717440, 10875392, 9069824, 3062272, 2240000, 1763840, 1392128, 1735680, /* 48-55 */
8446720, 9609728, 2788352, 1608960, 3991296, 4154624, 2980096, 7112704, /* 56-63 */
13000448, 14365696, 14857216, 11060736, 3412480, 1771264, 1884672, 6817536, /* 64-71 */
8380928, 5478400, 5696256, 7999744, 6162176, 3903744, 7237376, 11927808, /* 72-79 */
13510400, 14802944, 15164416, 15386880, 15554304, 15683584, 15789568, 15864064, /* 80-87 */
14062336, 8768512, 5651200, 4735744, 3598336, 2474240, 2033408, 1758720, /* 88-95 */
1531904, 1359872, 1168896, 1008640, 1049600, 4651008, 8086272, 12599552, /* 96-103 */
14047232, 13330176, 11949312, 11831552, 10940416, 9436416, 10516992, 12256512, /* 104-111 */
11316480, 8570368, 5960192, 4297472, 4836864, 8368896, 11677184, 12848896, /* 112-119 */
12877824, 12301568, 13097216, 13141760, 9757696, 7523328, 8930816, 11623680, /* 120-127 */
12139008, 12105984, 11400448, 9961984, 9563904, 8024576, 7154432, 5988352, /* 128-135 */
2852864, 1649408, 1696256, 2984960, 4932096, 3585024, 1417728, 1315328, /* 136-143 */
5297920, 6607104, 4316672, 4029440, 6086400, 10052096, 13137408, 12439552, /* 144-151 */
9199616, 8311808, 11004928, 12865024, 11866880, 12415488, 14453504, 15204608, /* 152-159 */
12062208, 8266496, 8163072, 8660736, 9200896, 11704064, 14278656, 14406144, /* 160-167 */
11005440, 6950144, 5082880, 4062208, 3408128, 3938304, 3816960, 4209920, /* 168-175 */
7578880, 10366976, 10955008, 11791872, 12083968, 12533504, 12431872, 11209216, /* 176-183 */
8508160, 5322496, 4891392, 6609664, 6725120, 5054464, 3813888, 3195648, /* 184-191 */
3098624, 4018944, 4648192, 5465344, 8256256, 11440640, 11947008, 10910464, /* 192-199 */
10900736, 11011840, 9274368, 7962368, 7555840, 7724032, 8666880, 8859392, /* 200-207 */
8268288, 8249600, 8553472, 8220672, 6801408, 5454336, 6013440, 8514816, /* 208-215 */
9225984, 8481536, 9423872, 10017792, 8954112, 9228032, 11208960, 12316416, /* 216-223 */
10835456, 8145152, 7216640, 7489024, 7003136, 8034816, 10285824, 9483264, /* 224-231 */
6706432, 4979968, 4849920, 4935936, 5156096, 6409984, 7836160, 8965120, /* 232-239 */
10824960, 11074560, 8773888, 8334592, 9442048, 9342976, 9005568, 8612608, /* 240-247 */
6951424, 4165888, 4385536, 7303680, 9576960, 10548992, 10021376, 9873664, /* 248-255 */
11379968, 11470848, 9355520, 7579904, 5709568, 3944704, 4318976, 5838592, /* 256-263 */
7650304, 8879616, 8848640, 9996800, 11324928, 10536704, 9490176, 9624832, /* 264-271 */
9452288, 8436224, 7481344, 8325632, 11168512, 12797184, 11771136, 10300416, /* 272-279 */
9476608, 8797184, 7848192, 6928128, 6332416, 6541568, 6852608, 6585088, /* 280-287 */
6073088, 5781248, 6186752, 6733312, 7274752, 8389120, 9056512, 7667456, /* 288-295 */
6648320, 7423744, 8671488, 9672704, 9706752, 9296896, 9717760, 9730048, /* 296-303 */
8964864, 9187584, 9143552, 7985664, 7494912, 8499712, 10604544, 11694336, /* 304-311 */
10283520, 7855616, 7033344, 8568576, 9922048, 8863744, 7208448, 6698240, /* 312-319 */
7292416, 7605504, 7208960, 8024576, 9668352, 10256384, 9356032, 8412160, /* 320-327 */
8485888, 8524032, 8347392, 9648128, 9770496, 6626816, 4910080, 6444288, /* 328-335 */
8141056, 8145408, 7247616, 7141888, 8413440, 9722368, 9406464, 8107264, /* 336-343 */
7879168, 8641792, 9024768, 8536832, 7527168, 6535936, 6056704, 6028288, /* 344-351 */
7208448, 9291776, 9613568, 8539392, 8970240, 10252288, 10309632, 9124096, /* 352-359 */
8799232, 8875520, 8573952, 8018944, 6995456, 6524416, 7824896, 9163264, /* 360-367 */
8793600, 8058368, 7757568, 7475712, 8042752, 9811200, 10852096, 9214720, /* 368-375 */
7412736, 7940096, 9240320, 8969472, 7809536, 7318528, 7214336, 7568128, /* 376-383 */
8933376, 9673984, 8133888, 6983936, 8226560, 10188288, 10843904, 9978880, /* 384-391 */
8538368, 8342528, 8664064, 7853056, 7982336, 9214976, 8750336, 7418624, /* 392-399 */
7628032, 8405504, 8311040, 7961088, 7479552, 6549504, 6539776, 7915008, /* 400-407 */
9113088, 8545792, 6671360, 5762048, 6460416, 8322304, 9993728, 9789440, /* 408-415 */
8502016, 7798016, 7447808, 7381248, 8158976, 9648384, 10819072, 9839104, /* 416-423 */
8272640, 8884224, 10034432, 10258176, 10578176, 10725376, 9533440, 8473600, /* 424-431 */
7925504, 8291584, 9101056, 9157888, 8488704, 7181312, 6814464, 7592960, /* 432-439 */
7025920, 5751808, 6415872, 7926272, 9295872, 11676928, 12302848, 12175872, /* 440-447 */
11998720, 12113152, 7571200, 5296640, 4567808, 4524544, 4888832, 5089536, /* 448-455 */
4617472, 8009728, 10596096, 11120896, 10260736, 7313408, 5919488, 5648640, /* 456-463 */
4425984, 7507456, 10827520, 11977472, 11738112, 11557888, 9196288, 6827776, /* 464-471 */
6005760, 5236992, 6130432, 7382784, 6095360, 5014272, 6567680, 10788096, /* 472-479 */
11998464, 11063808, 11274752, 12991232, 11047168, 9443072, 12401920, 14725120, /* 480-487 */
15198208, 15404800, 15582720, 15285504, 9003776, 4004864, 2674944, 2155008, /* 488-495 */
1535488, 2584064, 4643840, 6234112, 9277184, 9297664, 3589376, 1272320, /* 496-503 */
918272, 5030912, 10113280, 8297984, 3107584, 1248512, 2549760, 4350720, /* 504-511 */
8268544, 12453376, 13766656, 14355712, 15386880, 13057280, 6771968, 5839872, /* 512-519 */
9844992, 13219328, 14098944, 13250048, 12125696, 12595456, 14845184, 15783936, /* 520-527 */
15135488, 12864000, 11397120, 9452544, 5873920, 4072960, 3205888, 2398208, /* 528-535 */
1997312, 1776384, 1582848, 1475072, 1323520, 1174784, 1001472, 1321984, /* 536-543 */
3498496, 7774976, 10935552, 12098816, 11907840, 11742976, 12834816, 14671360, /* 544-551 */
15649024, 13901568, 11641856, 11459584, 10544896, 9226496, 8940800, 10011392, /* 552-559 */
11359744, 9812224, 7987456, 10728192, 14349312, 15055360, 14374912, 11930880, /* 560-567 */
9953024, 10070528, 11426304, 11774720, 10048256, 9355264, 8473856, 5304576, /* 568-575 */
3369216, 3378176, 2815744, 1872640, 2764544, 4448256, 4771072, 4490240, /* 576-583 */
4113920, 4680448, 6542080, 6935040, 6022656, 6146304, 7511040, 9067008, /* 584-591 */
8829696, 6908928, 5464576, 5649664, 5875968, 6097408, 8718592, 12894720, /* 592-599 */
14825728, 15307776, 13318656, 11718912, 11648256, 12226560, 13853440, 14500864, /* 600-607 */
12448000, 8478976, 4928512, 4561664, 6580736, 7742720, 7099136, 6100736, /* 608-615 */
5750016, 5976064, 7041280, 9161728, 10724096, 10133760, 7927552, 5964544, /* 616-623 */
5308928, 4805120, 4328960, 4551424, 5244160, 5769728, 6201344, 7150848, /* 624-631 */
7741184, 6385152, 4654848, 5370368, 7264768, 7915776, 9463808, 12369408, /* 632-639 */
13784832, 12994816, 12655872, 13669376, 12954368, 10526720, 8983552, 9033472, /* 640-647 */
10136832, 11102720, 11971840, 12455680, 10675200, 7830784, 7874304, 10081280, /* 648-655 */
11418880, 11317248, 9715712, 8208896, 7720960, 7672064, 7640064, 7462400, /* 656-663 */
7601664, 6732032, 4358144, 3569152, 4611584, 4451840, 3918848, 5270528, /* 664-671 */
6516480, 6270208, 5589760, 5120000, 5696512, 7435520, 8183296, 7140352, /* 672-679 */
7021824, 8427008, 9817856, 9830912, 8431104, 7199232, 6932736, 6540544, /* 680-687 */
5906944, 7478016, 11344896, 13568512, 14142720, 13195008, 11923968, 11553024, /* 688-695 */
12024576, 13475072, 14039552, 12165632, 8893696, 5372672, 3999232, 5418496, /* 696-703 */
6550784, 5998336, 5341440, 5418496, 5721856, 6339072, 8002048, 9750016, /* 704-711 */
9438464, 7660032, 5754880, 5212672, 5245952, 5101824, 5954560, 6918656, /* 712-719 */
7467008, 8184064, 9496064, 10576128, 9047040, 6144768, 6007040, 6993664, /* 720-727 */
6401792, 8033792, 12746496, 15411712, 13877760, 12076800, 12700672, 12722176, /* 728-735 */
10142208, 7725056, 8244992, 10755840, 12879360, 13730048, 13414912, 11211520, /* 736-743 */
7274240, 5168128, 6265600, 7669504, 7977984, 7244032, 6280192, 5711360, /* 744-751 */
4065536, 3012096, 4477184, 5922304, 5038080, 3471360, 4279040, 6749440, /* 752-759 */
7402496, 7413504, 9099008, 10040832, 8897536, 7792896, 7233024, 7710976, /* 760-767 */
9533952, 10386688, 9720064, 9242880, 10210560, 11584512, 11666176, 11641088, /* 768-775 */
11504128, 10211328, 8370432, 5801472, 4192512, 5597184, 7351040, 8517888, /* 776-783 */
10532864, 11339520, 10578944, 10429184, 11081216, 10544384, 8799744, 8377856, /* 784-791 */
7790848, 5340416, 3599872, 3281920, 3621632, 6067456, 10489344, 13201664, /* 792-799 */
11984128, 8784640, 6609152, 6509568, 7116544, 6093568, 5037568, 7155456, /* 800-807 */
10772224, 12238848, 11413504, 10302464, 9492992, 9800448, 11688448, 13001728, /* 808-815 */
12688896, 11128064, 7690752, 4602624, 5074176, 6842880, 6240512, 4747264, /* 816-823 */
5250560, 7098112, 7271424, 5559808, 4766720, 5134336, 5828352, 7343360, /* 824-831 */
9271040, 9849600, 9286656, 9802752, 10951936, 10608128, 9192192, 8156160, /* 832-839 */
7797248, 8797440, 11193344, 12221952, 10719488, 9307904, 9435392, 9688320, /* 840-847 */
8083200, 5817088, 6045440, 7220224, 6416128, 5818880, 7055616, 8586240, /* 848-855 */
10269696, 11452672, 10768896, 9880320, 10352128, 10483200, 8550912, 6640128, /* 856-863 */
6955776, 8036608, 8436480, 8356608, 7752448, 6392320, 5286400, 5753600, /* 864-871 */
6494720, 6192896, 6469376, 8128000, 9515264, 10056448, 9623296, 8723712, /* 872-879 */
9002752, 9179392, 8231168, 7831296, 8178944, 7498496, 5732096, 5557760, /* 880-887 */
7364096, 8617472, 8636672, 8267776, 7686400, 7159040, 7280384, 8443136, /* 888-895 */
10192896, 10775552, 10086656, 9995008, 10692096, 10997248, 10238464, 8951552, /* 896-903 */
8953344, 10365696, 10173952, 8238080, 8328192, 9615104, 8403456, 6118144, /* 904-911 */
5660416, 6574592, 7710720, 8376320, 8902912, 9706752, 9330176, 8051968, /* 912-919 */
7910400, 8294400, 7595520, 6975744, 7898112, 8267776, 7112192, 7249408, /* 920-927 */
9010944, 9612288, 8822784, 8363776, 8383744, 8616448, 8793344, 8233984, /* 928-935 */
7260160, 6388480, 6406400, 7628288, 8805632, 8993024, 8041472, 7256064, /* 936-943 */
8555776, 10090752, 9660672, 8876544, 8564224, 8772352, 9837568, 10036224, /* 944-951 */
8759296, 7962368, 7723008, 7335936, 7444224, 7995392, 8252928, 7788800, /* 952-959 */
7090944, 7139840, 7365632, 6991360, 7795712, 9714688, 9800704, 8626944, /* 960-967 */
8363520, 8592384, 7962368, 7492608, 8863232, 9884160, 9125376, 8315392, /* 968-975 */
7598080, 7436800, 8814592, 9976832, 9146368, 7929344, 7884544, 8502272, /* 976-983 */
9020160, 8847616, 8696320, 8905984, 8969472, 9678336, 10824704, 10558464, /* 984-991 */
9197312, 8683008, 9118976, 9170944, 8698624, 8752896, 9347840, 9131008, /* 992-999 */
7926272, 7281408, 7971328, 8203008, 6814976, 6154752, 6531840, 6210048, /* 1000-1007 */
6169344, 6848512, 7201536, 7279872, 6844928, 6128640, 6733568, 8258560, /* 1008-1015 */
8894976, 7910656, 7939840, 9631488, 10502912, 11877120, 13402368, 13433600, /* 1016-1023 */
12053760, 8818688, 6657792, 5753600, 4697600, 4790016, 6076416, 8434432, /* 1024-1031 */
11326208, 11379712, 7211520, 3855616, 4070144, 4638976, 5515008, 5996544, /* 1032-1039 */
5369600, 5618944, 7581184, 8206848, 8056320, 9751040, 11783424, 12027904, /* 1040-1047 */
12184576, 11533568, 9006336, 6838272, 7318528, 9248512, 10625536, 10138368, /* 1048-1055 */
8650240, 8745216, 10846720, 12443648, 11894784, 10229504, 9408768, 8636416, /* 1056-1063 */
6470656, 5479936, 6175744, 6440448, 5823232, 4769024, 4255232, 4387328, /* 1064-1071 */
4937728, 5218304, 4773120, 4354816, 4293632, 5739776, 7595008, 9502976, /* 1072-1079 */
10903552, 10751232, 10583296, 11358976, 12237056, 12686848, 11894784, 10813952, /* 1080-1087 */
10141952, 9782784, 9834240, 10118144, 10050304, 8913664, 7368448, 8257024, /* 1088-1095 */
10748160, 11143168, 11339264, 11616512, 10238720, 8737792, 8737536, 9046016, /* 1096-1103 */
8438016, 8377600, 9056000, 7889920, 5542912, 5949184, 7617792, 7444224, /* 1104-1111 */
6283520, 6232320, 6126848, 5980672, 5957376, 5080064, 3533056, 3051008, /* 1112-1119 */
6046720, 11446272, 14565120, 14749184, 14624512, 12705280, 7682048, 2857472, /* 1120-1127 */
1887488, 3108864, 3969280, 2903552, 4314880, 5513728, 6026240, 9826304, /* 1128-1135 */
14604800, 14675200, 12311552, 9006592, 6266112, 3732992, 2064640, 1495808, /* 1136-1143 */
4327680, 10261504, 11095040, 8723712, 10081024, 12401920, 13672960, 14926080, /* 1144-1151 */
14209536, 11772928, 10203648, 11128064, 11624960, 11788288, 12285440, 12828416, /* 1152-1159 */
11482624, 7538688, 4347648, 3924736, 4807168, 4614144, 2758656, 1285376, /* 1160-1167 */
2924544, 6404352, 7964672, 9488128, 11970048, 13687040, 14958848, 14748416, /* 1168-1175 */
12690432, 8951808, 5275392, 4822528, 7264256, 7823872, 7509248, 9973760, /* 1176-1183 */
13149184, 13008896, 11545600, 11806720, 12708608, 12474112, 9849344, 5901824, /* 1184-1191 */
2481152, 2205184, 3568128, 2766592, 1921024, 1628672, 912128, 991744, /* 1192-1199 */
2130944, 4460544, 6993152, 9710080, 12805888, 13784832, 14422784, 15133440, /* 1200-1207 */
15464960, 15831296, 14173184, 11892736, 11307520, 11493632, 12009216, 11498496, /* 1208-1215 */
10125568, 10143232, 8535040, 5347328, 2865408, 2072064, 2329088, 2973440, /* 1216-1223 */
4087040, 4806912, 5867520, 5760512, 5691392, 6539776, 6654464, 7771392, /* 1224-1231 */
11256576, 13396224, 11973888, 9009408, 6985728, 7614208, 8758272, 8918528, /* 1232-1239 */
7649792, 7594240, 8240384, 7403520, 6724096, 7105280, 8612096, 9851136, /* 1240-1247 */
10772480, 10922240, 11315200, 11643904, 10317056, 7412224, 5149952, 5942016, /* 1248-1255 */
8294912, 9891840, 9864704, 9001984, 8099584, 7058688, 6532096, 6996224, /* 1256-1263 */
6656512, 5203712, 4323584, 5491712, 8268800, 10696448, 11598848, 12071936, /* 1264-1271 */
12476928, 12024576, 11412480, 10494976, 10491648, 10448896, 7799552, 5033216, /* 1272-1279 */
6146816, 9325568, 10175744, 8662016, 8033280, 8506112, 8267520, 7441152, /* 1280-1287 */
7049216, 7971072, 8819456, 9139456, 8676096, 7502848, 7068160, 7857920, /* 1288-1295 */
8859648, 8599552, 8789760, 9312000, 8883200, 8985344, 8290560, 5469184, /* 1296-1303 */
4030208, 4960000, 7056640, 8728832, 8064256, 6680832, 6196224, 5558784, /* 1304-1311 */
4131840, 4377856, 6814976, 10188288, 10694656, 9754624, 9218816, 10404864, /* 1312-1319 */
12297216, 12653312, 10737408, 9425408, 8929280, 8089088, 7227392, 6152448, /* 1320-1327 */
7556352, 9859840, 10184960, 9154816, 8301056, 8449024, 9255936, 9542400, /* 1328-1335 */
9523200, 9743360, 9505024, 8679168, 8002816, 6474240, 6501376, 8255744, /* 1336-1343 */
8253184, 6606592, 5754624, 5875968, 6508288, 7571712, 8251648, 7820544, /* 1344-1351 */
6846976, 8387072, 10889472, 10619136, 9590528, 9266944, 9261056, 9292288, /* 1352-1359 */
9155840, 9067776, 8229888, 6601216, 7126784, 9620224, 9308416, 7768832, /* 1360-1367 */
8491008, 10221312, 10779904, 9979648, 8941824, 8513536, 9075456, 10435072, /* 1368-1375 */
11093760, 9705472, 7642368, 6706176, 6246656, 5609728, 4819712, 4567296, /* 1376-1383 */
4758784, 5031680, 5952000, 6308608, 6870272, 8313088, 8907776, 9558016, /* 1384-1391 */
10336000, 10831872, 12556288, 12798464, 10123264, 8040960, 7787520, 9121280, /* 1392-1399 */
9805824, 7990784, 7185152, 9097728, 9828352, 8293632, 6291712, 5932288, /* 1400-1407 */
7864064, 9378048, 9107712, 7961600, 6948864, 7651840, 9342464, 8886016, /* 1408-1415 */
7815936, 8997632, 10727936, 10320128, 8354048, 7313152, 7624192, 7634176, /* 1416-1423 */
7392512, 7358208, 7246080, 7415552, 7322880, 6856960, 6681088, 7650048, /* 1424-1431 */
9072128, 9540864, 8971776, 9244928, 9911296, 9817344, 9848576, 9086464, /* 1432-1439 */
8675328, 9609216, 11152384, 11601408, 9649408, 7735296, 7486720, 7611648, /* 1440-1447 */
7302656, 6785024, 6628864, 7051264, 8556544, 11504896, 12944384, 13005312, /* 1448-1455 */
13168384, 13184000, 11393280, 8806912, 6994432, 6779392, 6421760, 5207552, /* 1456-1463 */
3287552, 3309568, 5596416, 8320512, 9281792, 9327104, 9589248, 9729024, /* 1464-1471 */
8871424, 8253952, 8140544, 6827008, 6509312, 8344064, 8581632, 7561728, /* 1472-1479 */
6507264, 5633024, 6870528, 9339648, 10834432, 10864896, 10647808, 10600192, /* 1480-1487 */
10318336, 8919552, 7860736, 8034048, 7835392, 7077376, 6041088, 5311744, /* 1488-1495 */
5179904, 5297664, 6712320, 9178112, 11769600, 12950016, 12421632, 11554304, /* 1496-1503 */
10502912, 8546560, 7221248, 7161344, 8239104, 8037888, 6775552, 7297280, /* 1504-1511 */
9689600, 12097280, 12846336, 10508800, 9286144, 9448704, 8366592, 6909952, /* 1512-1519 */
7487744, 8291328, 7550976, 5231104, 3887616, 4278016, 5350912, 6867200, /* 1520-1527 */
8168704, 7391488, 5945344, 6889728, 8412416, 9425152, 10672384, 10526720, /* 1528-1535 */
8855040, 7888640, 9171456, 10975488, 10305024, 8315904, 8089344, 8355840, /* 1536-1543 */
7822336, 7789312, 7948288, 7729664, 6460160, 5645824, 7011584, 8065024, /* 1544-1551 */
8349184, 8950016, 10671360, 11789312, 11117824, 9185280, 6801664, 4561152, /* 1552-1559 */
5745408, 9393408, 11307520, 11944192, 12235264, 12902912, 13229824, 11481344, /* 1560-1567 */
8156928, 6241024, 5681920, 6424832, 6010624, 3795456, 1304576, 1396480, /* 1568-1575 */
4921088, 9644544, 11112192, 10670336, 9737728, 9541376, 10727424, 9158912, /* 1576-1583 */
5897472, 5475328, 6391296, 6817792, 8702720, 8714240, 6704896, 6740480, /* 1584-1591 */
7785472, 9552128, 12186880, 13984256, 13491712, 13174528, 12756480, 12690688, /* 1592-1599 */
12647680, 10169600, 8747008, 7154176, 5211648, 4249344, 4875776, 5204736, /* 1600-1607 */
4753920, 4975872, 7881984, 10488832, 10185216, 9311744, 8989952, 9947392, /* 1608-1615 */
10112000, 10183168, 9086208, 6825472, 6984192, 8153856, 7898624, 6501888, /* 1616-1623 */
5460736, 6112256, 7657984, 9069312, 9953792, 9214976, 9926912, 10957312, /* 1624-1631 */
11579136, 9878272, 7666688, 8610304, 9584896, 9223936, 11272448, 12663808, /* 1632-1639 */
12509696, 11790336, 10899968, 8933888, 5924864, 4704256, 4858112, 5276416, /* 1640-1647 */
6459392, 6489600, 7021056, 7410432, 9078272, 9063424, 8331776, 7822336, /* 1648-1655 */
7838976, 8286208, 8237824, 8481280, 8308480, 7665152, 7635712, 6679040, /* 1656-1663 */
5194752, 7031296, 6406144, 5025280, 6809600, 9279744, 11556864, 11149568, /* 1664-1671 */
8708608, 8531200, 9004544, 10820608, 13871616, 13398528, 10995712, 10014720, /* 1672-1679 */
10771456, 11077376, 9300992, 6968320, 5870080, 7166464, 8311552, 7809024, /* 1680-1687 */
6659072, 4905216, 4504320, 6632192, 7753216, 8997120, 8443136, 9099520, /* 1688-1695 */
10045696, 11699200, 11414016, 10419456, 10133760, 10686464, 10184192, 7987456, /* 1696-1703 */
7728128, 9742592, 10111232, 6909696, 3810816, 4263424, 6537728, 9117696, /* 1704-1711 */
10549248, 10888704, 10115840, 8144640, 6167040, 5053696, 5611520, 8484352, /* 1712-1719 */
10317312, 8259072, 8426752, 10722048, 10883328, 9766400, 8529920, 7962368, /* 1720-1727 */
7761152, 6785792, 6973696, 8134144, 7479040, 6038272, 3431936, 2241792, /* 1728-1735 */
3724032, 4702208, 5692928, 9643264, 14180864, 14870528, 13833472, 13037568, /* 1736-1743 */
11261440, 9841920, 9214720, 8285440, 9075968, 9559552, 9442560, 9427712, /* 1744-1751 */
7456768, 4172800, 4506368, 6119168, 11108608, 11455488, 7351040, 4424192, /* 1752-1759 */
3949056, 6757888, 9538816, 9648128, 10402304, 8638208, 6504704, 7684864, /* 1760-1767 */
7631872, 5140224, 4790016, 5615872, 6358016, 9418240, 10757120, 8145664, /* 1768-1775 */
7028480, 7996928, 9219584, 13389568, 14921216, 12808448, 11488256, 11581184, /* 1776-1783 */
12062976, 11441408, 9955328, 9040384, 6929152, 5650176, 6205952, 7168000, /* 1784-1791 */
7197696, 5245440, 4955136, 8535808, 11847424, 12014848, 10551552, 9971200, /* 1792-1799 */
12057344, 12265984, 10824704, 11117056, 10391296, 7030784, 4895232, 4790528, /* 1800-1807 */
4505856, 4441344, 5665280, 6846720, 4222464, 2814720, 6260736, 9725184, /* 1808-1815 */
11821056, 12828160, 11137024, 10346496, 10632192, 10205440, 10184448, 8820224, /* 1816-1823 */
7497728, 7739392, 6347776, 4944384, 6122240, 7602944, 9541888, 10707200, /* 1824-1831 */
10538496, 10671104, 12848640, 15096064, 14179072, 10925056, 6993408, 5883392, /* 1832-1839 */
6939136, 5369344, 3186432, 3627008, 4953088, 6464512, 7670528, 6468608, /* 1840-1847 */
4470784, 5512192, 8376320, 8780288, 7286016, 7312896, 7895296, 7118336, /* 1848-1855 */
4225024, 2551296, 5530112, 10660096, 14093056, 14349312, 10928640, 8506880, /* 1856-1863 */
9122816, 10107904, 10228992, 10219264, 9956352, 8051968, 4694016, 1920000, /* 1864-1871 */
1378048, 2295040, 3462400, 2867200, 3238912, 5707264, 6975488, 9208320, /* 1872-1879 */
12153600, 12948224, 13394176, 11483648, 9944320, 10696192, 12312832, 14455808, /* 1880-1887 */
14653696, 13770752, 12461568, 9656832, 7254272, 7131904, 8722944, 10895872, /* 1888-1895 */
13157376, 14624000, 13835264, 12367872, 8111872, 4010240, 3508224, 4391936, /* 1896-1903 */
4928768, 4510720, 4083712, 5282560, 7544064, 8528128, 8953088, 8871168, /* 1904-1911 */
7393024, 5378816, 3412480, 3058176, 4331008, 6907648, 9835008, 10244608, /* 1912-1919 */
8705024, 7596032, 7588608, 7783424, 7865600, 8161792, 9395712, 10541056, /* 1920-1927 */
12111104, 14150144, 13211392, 10513664, 8414720, 7538944, 7107328, 6931200, /* 1928-1935 */
6200832, 4268800, 4718848, 7268864, 8376064, 8844800, 10577152, 11982592, /* 1936-1943 */
11948544, 10228480, 9724416, 11135488, 11313408, 9712384, 5752832, 2514688, /* 1944-1951 */
4098560, 6820608, 8186880, 8449024, 6913536, 6438400, 7860736, 9838592, /* 1952-1959 */
11904768, 12140288, 11844608, 12378624, 12034816, 10359552, 9419520, 10062848, /* 1960-1967 */
10394624, 7927552, 5153024, 6194944, 7795200, 8045824, 7926016, 7863040, /* 1968-1975 */
7738112, 7528192, 7123200, 7622912, 7550720, 4637440, 3061504, 3656192, /* 1976-1983 */
4378624, 4760832, 4479488, 4865024, 5660672, 3843584, 2439936, 5089792, /* 1984-1991 */
9646848, 13512960, 15092736, 15455232, 14830080, 14119680, 14232576, 14585344, /* 1992-1999 */
13899008, 12691200, 11574016, 10431232, 8854528, 6373376, 5781248, 9162752, /* 2000-2007 */
11805440, 10888192, 10233088, 9178112, 6791680, 5964288, 7264000, 8875776, /* 2008-2015 */
10437888, 9524224, 6062080, 3020032, 2105088, 1875968, 3017984, 5289216, /* 2016-2023 */
4977152, 2776064, 3547648, 5877760, 6704896, 7399680, 9391616, 10591488, /* 2024-2031 */
9001984, 5846528, 4171520, 5667328, 9568256, 11515904, 10572800, 8641024, /* 2032-2039 */
9760256, 13782528, 13815040, 9426688, 6567680, 6500864, 5863936, 5874688, /* 2040-2047 */
7393024, 9441024, 10143744, 11058432, 13227264, 15209472, 14553600, 13740544, /* 2048-2055 */
14025216, 13210624, 13995264, 12625152, 9808128, 9177856, 9425408, 6817280, /* 2056-2063 */
3538944, 2007040, 911616, 1387264, 3546624, 5065728, 5218304, 4758784, /* 2064-2071 */
3302400, 3026688, 4054528, 5695488, 8441344, 11271936, 12562944, 12740864, /* 2072-2079 */
12936192, 13050368, 14425088, 15864832, 14278400, 9835520, 7119872, 7547136, /* 2080-2087 */
9018624, 9358080, 8203776, 6874368, 8289792, 11858944, 11432192, 7719936, /* 2088-2095 */
4279552, 4116992, 4536832, 3652352, 4176640, 5680640, 5324800, 7307264, /* 2096-2103 */
8758784, 7524864, 7762176, 6785024, 6463744, 7268352, 9030656, 11110400, /* 2104-2111 */
10571776, 8603392, 8312064, 9125376, 9459968, 8863232, 6088448, 4124928, /* 2112-2119 */
4644096, 8749824, 12910080, 13484544, 11176704, 10790912, 11873792, 11150080, /* 2120-2127 */
9860608, 8284160, 6441472, 5748224, 5724928, 4712704, 4783872, 5906944, /* 2128-2135 */
8384256, 10520064, 11536640, 11489536, 11958272, 13946368, 15531520, 15704576, /* 2136-2143 */
13490176, 10785536, 9406208, 7045888, 3296512, 2148352, 2597120, 3376128, /* 2144-2151 */
4205824, 6412800, 7870208, 7385344, 6252288, 6660096, 9752320, 13369344, /* 2152-2159 */
14950912, 14256384, 11562752, 10867456, 12513792, 13263104, 11366144, 9228032, /* 2160-2167 */
7690496, 5756928, 4364288, 3380992, 4955136, 9247232, 10779392, 8055040, /* 2168-2175 */
5067008, 4878848, 6374656, 6456320, 8119296, 10453248, 10838016, 9599744, /* 2176-2183 */
8679168, 8798720, 9148160, 9870848, 9972224, 9128704, 6594816, 4275712, /* 2184-2191 */
3395840, 3394816, 3170304, 5387776, 9277184, 13222912, 13879296, 13946624, /* 2192-2199 */
10723328, 7348992, 6856960, 7050240, 7229696, 7991808, 8251648, 7711744, /* 2200-2207 */
8371456, 9646848, 8851456, 6012672, 3946752, 2889984, 6297856, 9156096, /* 2208-2215 */
7699456, 6540032, 6146048, 6054656, 8854528, 12340224, 13930752, 13760512, /* 2216-2223 */
12460800, 12424960, 13115136, 12744960, 12230144, 9877760, 6480384, 5866240, /* 2224-2231 */
7402752, 8848128, 9316352, 9025792, 8190720, 9254144, 10715648, 11534336, /* 2232-2239 */
12451072, 12819456, 10827776, 7317504, 5697792, 5918720, 5284096, 4299264, /* 2240-2247 */
4242944, 3840256, 2536704, 1361152, 1996032, 2771200, 4046080, 7687936, /* 2248-2255 */
9875968, 10588672, 12534016, 13988608, 12865536, 10210304, 9547008, 11201792, /* 2256-2263 */
12187392, 12941056, 13364736, 10958336, 5948928, 3739648, 5777408, 8571904, /* 2264-2271 */
9762816, 10469632, 13109248, 14739968, 12838656, 9749248, 8593920, 8587264, /* 2272-2279 */
8656128, 8971776, 8328704, 6852352, 7358208, 10254336, 11269376, 10843136, /* 2280-2287 */
8733440, 4860928, 3186688, 5847296, 7654912, 6169856, 6335232, 8840704, /* 2288-2295 */
10177280, 8436224, 5095424, 3188224, 3558656, 5936128, 8205824, 7953408, /* 2296-2303 */
6984448, 7823872, 9598976, 12585728, 15005696, 14497024, 11081216, 7885056, /* 2304-2311 */
6188032, 5217024, 4559616, 4183552, 4480000, 5306880, 6512640, 7801600, /* 2312-2319 */
9106176, 9261824, 8975360, 9438464, 9424384, 9171456, 9036032, 9721856, /* 2320-2327 */
11599616, 13345280, 13482496, 11953408, 9710592, 7598592, 7052288, 9511424, /* 2328-2335 */
13383680, 15197952, 13911808, 12068352, 11566080, 8976128, 5854208, 4060928, /* 2336-2343 */
2367744, 2752512, 3942400, 3741952, 4028160, 5719808, 6606848, 6847744, /* 2344-2351 */
7014912, 5710848, 4557056, 5743872, 7197440, 7436032, 7824128, 9018624, /* 2352-2359 */
10743296, 11919104, 12588800, 12977408, 12499456, 11449856, 10139904, 9248768, /* 2360-2367 */
8844800, 8723456, 10746624, 11904256, 8937984, 5322240, 4290816, 3527168, /* 2368-2375 */
3461120, 4590848, 6140160, 8288768, 9902848, 9999616, 10744832, 11863040, /* 2376-2383 */
11498752, 10064640, 8186880, 6708224, 7083264, 8407040, 9832448, 9396480, /* 2384-2391 */
7841536, 8556800, 9084416, 8034048, 7567104, 6966272, 5515776, 6275840, /* 2392-2399 */
9086208, 11424000, 12375552, 12559872, 12777984, 13566208, 14390016, 14051072, /* 2400-2407 */
12068864, 10413568, 9520896, 6513920, 4531456, 4754176, 3400448, 1850880, /* 2408-2415 */
3618560, 6706688, 7513344, 5304320, 3169024, 4477696, 6300672, 6910720, /* 2416-2423 */
7669504, 8471296, 8179712, 6155776, 4071680, 3862272, 4777984, 5350912, /* 2424-2431 */
7153408, 10018816, 11638528, 12297984, 12648192, 12234496, 11686912, 11399680, /* 2432-2439 */
11236608, 11966720, 12903424, 11421440, 10381824, 11429120, 10542592, 6912256, /* 2440-2447 */
5252608, 6403328, 6776064, 6545920, 7754240, 9001728, 8957952, 8612096, /* 2448-2455 */
9577216, 10801408, 9359872, 6007552, 3851776, 3849728, 5346560, 6652416, /* 2456-2463 */
6577664, 5206784, 3696896, 4773376, 8087040, 9960704, 8795648, 8099840, /* 2464-2471 */
9071872, 9452032, 9744384, 10516736, 11195904, 12093440, 12054272, 10322688, /* 2472-2479 */
8605440, 8646656, 9681664, 9375488, 7258624, 5276672, 5202944, 5298176, /* 2480-2487 */
4834816, 5677824, 6919680, 6437120, 5334272, 7010816, 10212608, 11142144, /* 2488-2495 */
11766016, 13851648, 14204672, 12950528, 11608064, 10633472, 10718720, 11286272, /* 2496-2503 */
10870272, 9987584, 9590528, 8224768, 6195968, 5052160, 5198080, 6771456, /* 2504-2511 */
8845824, 9112576, 7054848, 5538304, 6724608, 8342528, 7685120, 5964544, /* 2512-2519 */
5404672, 7395072, 9683968, 9679360, 10526720, 11659776, 9711104, 7871488, /* 2520-2527 */
7203072, 6136064, 6194688, 7375104, 8058368, 7789312, 6220800, 3301632, /* 2528-2535 */
1347072, 2386432, 5132800, 6524672, 5963776, 5888512, 8368384, 11800320, /* 2536-2543 */
13546752, 12726784, 10813696, 10274304, 10400512, 10358528, 10804480, 10957568, /* 2544-2551 */
11652608, 12867840, 12139520, 9939456, 9249792, 9657856, 9116928, 7528192, /* 2552-2559 */
5097216, 4215040, 6330880, 8151552, 7352064, 5646336, 5449472, 6474240, /* 2560-2567 */
6061056, 5093632, 6412800, 8413696, 9361152, 9796864, 10187008, 10958592, /* 2568-2575 */
11332352, 10127616, 8007168, 6905856, 6791424, 6740992, 8462592, 11268096, /* 2576-2583 */
11446784, 9312512, 8049408, 8405760, 8503296, 6812928, 4598528, 3852800, /* 2584-2591 */
4302336, 4939008, 6477056, 8886016, 9883136, 9234688, 8803840, 9508352, /* 2592-2599 */
11321856, 12936448, 12649984, 11837184, 11371520, 11002880, 11489280, 11339008, /* 2600-2607 */
10730752, 10036992, 7286016, 4904704, 5213440, 6141440, 7775232, 9993216, /* 2608-2615 */
10374144, 9269248, 9047552, 10615296, 11664128, 10245376, 7896576, 5941760, /* 2616-2623 */
4509184, 4827648, 6797568, 8315392, 8968448, 8726528, 7118848, 4747264, /* 2624-2631 */
3292416, 3427328, 3547136, 3342336, 4204800, 6514688, 9453568, 11303424, /* 2632-2639 */
11245056, 10678784, 10728192, 10187264, 8939520, 8999424, 10168576, 10861056, /* 2640-2647 */
10729472, 10713600, 11550208, 12062976, 9881088, 6230528, 4879104, 5792256, /* 2648-2655 */
6076416, 5625344, 6892800, 9649920, 10466048, 8321024, 6173440, 6141440, /* 2656-2663 */
6488064, 5816320, 6322944, 8874752, 10638336, 10415616, 9788160, 9015296, /* 2664-2671 */
7208192, 5201664, 5383168, 8154368, 10392832, 9424640, 8195072, 9551616, /* 2672-2679 */
11303424, 11491584, 10534912, 9214720, 7062272, 4825600, 4791040, 7563520, /* 2680-2687 */
10525696, 10306816, 7521024, 4981504, 4571904, 6213888, 8422656, 10228736, /* 2688-2695 */
11393280, 12334336, 12871680, 11890944, 10288128, 9613312, 8887296, 8196608, /* 2696-2703 */
9443328, 11131648, 11629312, 11300352, 8824320, 4897536, 2011136, 913408, /* 2704-2711 */
1887744, 5131520, 8238592, 9044992, 8122624, 7343104, 6949120, 7408384, /* 2712-2719 */
10341632, 12472064, 10907648, 9004288, 8316416, 7577344, 7512320, 8196864, /* 2720-2727 */
7907072, 6687744, 5627392, 5886208, 6953984, 7948800, 9542656, 11164928, /* 2728-2735 */
11813632, 11504640, 10269696, 9266688, 10081280, 10417152, 8609280, 6573824, /* 2736-2743 */
4970496, 4708864, 6079232, 7308544, 9178368, 12455936, 14419968, 13731328, /* 2744-2751 */
11672320, 9702656, 8049920, 6788096, 6764544, 7358720, 7343616, 6955264, /* 2752-2759 */
6604032, 6619136, 6167552, 5074432, 5168128, 6586112, 7228416, 6939136, /* 2760-2767 */
7179776, 7829248, 7836160, 7370496, 7069952, 7988480, 9982464, 11051776, /* 2768-2775 */
11227648, 11992064, 12391424, 11076096, 9728256, 10481664, 12180480, 12302080, /* 2776-2783 */
10306816, 6922240, 4695040, 4421888, 4665600, 5196288, 5743104, 6182144, /* 2784-2791 */
7710976, 8740352, 6790912, 5060096, 6213888, 7913216, 8739072, 8890624, /* 2792-2799 */
9150976, 10590208, 12276736, 12417280, 11012352, 9093120, 7716352, 7374080, /* 2800-2807 */
7250176, 6366976, 5250048, 5681408, 7877376, 8668416, 6452224, 4348928, /* 2808-2815 */
4037888, 5048320, 6093312, 7062272, 9026048, 11743488, 13439744, 13372672, /* 2816-2823 */
12854528, 12193536, 10361344, 8413440, 8645376, 10393344, 11286016, 11402496, /* 2824-2831 */
12210432, 11443712, 9219840, 7631616, 7338240, 8833280, 9216000, 6538752, /* 2832-2839 */
4507648, 5347072, 6518272, 6876160, 7130112, 8909568, 11193600, 11377408, /* 2840-2847 */
10142464, 9455104, 7602944, 5669632, 5946624, 6629888, 6208768, 4983040, /* 2848-2855 */
4359424, 4950784, 6364672, 7062016, 6668800, 7415808, 9254656, 9974528, /* 2856-2863 */
9105408, 8452352, 8728576, 8751360, 7436032, 5585920, 5349888, 7138048, /* 2864-2871 */
9257728, 10437376, 11718656, 12437760, 12028160, 10993920, 10167296, 10391552, /* 2872-2879 */
10437632, 9115904, 7330048, 6049792, 6203648, 7657984, 9991168, 11670784, /* 2880-2887 */
10840832, 8588544, 7459840, 6877440, 6535424, 7358208, 8344320, 7854080, /* 2888-2895 */
6475520, 5794048, 5783808, 6492672, 7179776, 7241472, 6539520, 6561280, /* 2896-2903 */
7939328, 8287744, 6794752, 5368320, 5940224, 7675392, 8532736, 7996928, /* 2904-2911 */
7832576, 8955392, 9027072, 8786432, 10449152, 13376768, 15454208, 15298816, /* 2912-2919 */
12749312, 10893824, 11276800, 11886592, 10730240, 8852992, 8018176, 7908096, /* 2920-2927 */
7094784, 6061312, 6204672, 6847232, 6595584, 5749760, 5637632, 6095616, /* 2928-2935 */
5971456, 6088192, 8076800, 10223872, 9774592, 7656704, 6843648, 7246592, /* 2936-2943 */
7247360, 7552512, 8723200, 9752320, 8969472, 6571264, 5108736, 5214720, /* 2944-2951 */
6193408, 8183552, 10382336, 11447296, 10896128, 9811200, 9471232, 9179136, /* 2952-2959 */
8827904, 8391680, 8699648, 11087104, 12267520, 10380032, 8550144, 7992320, /* 2960-2967 */
8069632, 7973120, 7306240, 6924288, 7196160, 8382976, 8000256, 6034944, /* 2968-2975 */
3992320, 3158272, 4667392, 7497984, 8756736, 7707136, 6435328, 6807552, /* 2976-2983 */
8948736, 11963136, 13334272, 11844352, 10193664, 9538816, 8996352, 8811776, /* 2984-2991 */
9327104, 9574400, 9315584, 9115392, 9068288, 9595904, 10137600, 10017024, /* 2992-2999 */
9167360, 7239680, 5644288, 5274880, 4543488, 3324416, 2627328, 2924032, /* 3000-3007 */
4661248, 5630464, 5003264, 5871360, 7879424, 9418496, 11148544, 12933632, /* 3008-3015 */
13830400, 14014720, 12967424, 10873088, 8995584, 7757056, 6416384, 7175680, /* 3016-3023 */
10486784, 11390720, 8867584, 7561216, 9019648, 9646080, 8707328, 7404032, /* 3024-3031 */
6323200, 5906432, 6080000, 7190272, 8863488, 9085440, 8530688, 8400640, /* 3032-3039 */
8078592, 8315904, 9379584, 8700416, 6633728, 5931776, 6617088, 8275200, /* 3040-3047 */
9939968, 9445376, 8256256, 7510272, 7322112, 8313600, 8913408, 9121280, /* 3048-3055 */
9747200, 9290752, 8258816, 8280576, 9380096, 10176000, 9139968, 7704064, /* 3056-3063 */
7560960, 7918080, 8018944, 7809792, 7423232, 8319488, 10384896, 11320832, /* 3064-3071 */
9615616, 7730176, 7393792, 7472640, 7227392, 7321344, 7969024, 8550144, /* 3072-3079 */
8357376, 7168256, 7695872, 10454784, 11202304, 9498624, 8305664, 8824832, /* 3080-3087 */
9300224, 9520128, 10590208, 11599616, 10451200, 7576064, 5437696, 5698560, /* 3088-3095 */
6770176, 6732032, 5952512, 5819392, 6795776, 7966720, 8046336, 6736640, /* 3096-3103 */
6106880, 6146560, 5552128, 5481472, 6642688, 7940096, 8997376, 10580736, /* 3104-3111 */
11960320, 11596544, 9635584, 7877120, 7889408, 8986368, 8979712, 8587520, /* 3112-3119 */
9348096, 10091008, 9305856, 7442688, 6604288, 7484928, 8225280, 8057344, /* 3120-3127 */
8247040, 9313792, 9685504, 9178368, 9015552, 9253376, 9262080, 8649216, /* 3128-3135 */
7886848, 8154368, 9115904, 10426624, 11511552, 11159552, 9487360, 8435968, /* 3136-3143 */
8278784, 8419072, 8935936, 9042432, 7942144, 6572800, 5435904, 5070336, /* 3144-3151 */
5022208, 4858368, 6104064, 8692224, 9746688, 8465664, 7778048, 7535360, /* 3152-3159 */
6890496, 7666176, 10094336, 9903616, 6863360, 5587200, 6905856, 8703488, /* 3160-3167 */
9554432, 8386048, 7035648, 8301824, 10287104, 11104000, 10681344, 9966848, /* 3168-3175 */
9821696, 9601536, 8742656, 8346368, 8566272, 8762112, 9385472, 9768192, /* 3176-3183 */
8658432, 6626048, 5527808, 5952000, 6969856, 8122880, 9423360, 10781440, /* 3184-3191 */
11868928, 11945984, 11258112, 10098688, 8876032, 8280832, 8020480, 7140096, /* 3192-3199 */
6459904, 6720512, 7381504, 7312384, 6925824, 6121728, 5419776, 5553152, /* 3200-3207 */
5358592, 5111808, 6298368, 7627520, 7968512, 8635648, 9172736, 9512448, /* 3208-3215 */
9667072, 9167360, 9080832, 9154304, 9268736, 10262016, 11686912, 12697856, /* 3216-3223 */
12451840, 10305792, 7732736, 7745024, 8240128, 7048704, 6468864, 6968064, /* 3224-3231 */
7275264, 8155392, 9592064, 9737984, 9002752, 9126656, 9519360, 9173504, /* 3232-3239 */
8758272, 8680192, 8290304, 8435968, 9214464, 8974336, 8273152, 8236032, /* 3240-3247 */
7626752, 6507008, 6346240, 6674688, 6564608, 6320640, 6425088, 6368256, /* 3248-3255 */
6079744, 6398720, 7112960, 8057856, 9389056, 10241536, 10253824, 9950720, /* 3256-3263 */
9991936, 10024704, 9600000, 8542464, 7449600, 7791360, 8655616, 8192768, /* 3264-3271 */
8065536, 9696000, 11466240, 11373568, 10407936, 10395648, 10624768, 10087936, /* 3272-3279 */
8785920, 7012096, 5840128, 6299392, 7252224, 7038720, 6609664, 7338496, /* 3280-3287 */
8357376, 8849664, 8804352, 8258816, 8123136, 8658944, 9021696, 8728320, /* 3288-3295 */
8262656, 7806208, 7030528, 6954496, 7424768, 7451648, 7761408, 8230400, /* 3296-3303 */
7750656, 6906368, 7386624, 8342528, 7746560, 6937088, 7585792, 8813312, /* 3304-3311 */
9588736, 10370560, 11675136, 11613952, 10782464, 10398976, 9518848, 8981504, /* 3312-3319 */
9784832, 10462464, 9810432, 7993600, 6834176, 7509504, 8744704, 9691392, /* 3320-3327 */
10389504, 9353984, 7114752, 6643456, 8104448, 8880896, 8375552, 7974656, /* 3328-3335 */
7147520, 6089472, 6150144, 6138624, 6192384, 6928384, 7082496, 5587456, /* 3336-3343 */
4522752, 5725184, 6884864, 6963456, 7522304, 8313088, 8530432, 8517120, /* 3344-3351 */
8548096, 9211648, 10349056, 10640384, 10081280, 10504448, 11668736, 11860480, /* 3352-3359 */
10958592, 9651968, 9137152, 9691648, 10176256, 10593536, 10936832, 11101696, /* 3360-3367 */
10864640, 9501440, 8121344, 8107008, 8290560, 7556352, 7153152, 6930176, /* 3368-3375 */
5821184, 5496320, 6044928, 6196736, 7072256, 7991552, 7439104, 6990080, /* 3376-3383 */
7305728, 7066368, 6670336, 7148544, 8409856, 8843264, 8218112, 7597568, /* 3384-3391 */
6663424, 6359040, 7761152, 9424384, 10045696, 10100736, 10419456, 10219264, /* 3392-3399 */
9605888, 9846016, 10025216, 9874688, 10760448, 10887680, 8552960, 6692352, /* 3400-3407 */
7208704, 7915264, 7500800, 6932224, 7038720, 7779584, 8384000, 8708608, /* 3408-3415 */
8546304, 8453632, 8722176, 8691712, 9208064, 10095872, 9671936, 8496896, /* 3416-3423 */
7928064, 8222464, 8847616, 9228800, 9612032, 10183680, 10451456, 9833728, /* 3424-3431 */
8803072, 8431872, 8102656, 6876160, 6545664, 7171584, 6881536, 6504448, /* 3432-3439 */
6678528, 6710528, 6678784, 7138048, 7093504, 6473472, 6780672, 7049216, /* 3440-3447 */
6443520, 5941760, 6374144, 7558656, 8216832, 8139520, 8866816, 10391040, /* 3448-3455 */
11035904, 10553600, 10314752, 10536704, 11215360, 11671808, 10652928, 9143040, /* 3456-3463 */
9384448, 11158272, 11785216, 10714368, 9862400, 9896704, 9976064, 9460480, /* 3464-3471 */
8614400, 7779328, 7715584, 8336384, 7989248, 6136064, 4986112, 5312256, /* 3472-3479 */
5568000, 5949696, 6790400, 6688768, 6110208, 6766080, 7578624, 7723776, /* 3480-3487 */
7811328, 7779840, 7630848, 7878144, 8299776, 8489216, 8361728, 7937536, /* 3488-3495 */
7966464, 8121600, 8027648, 8424448, 8638464, 8071168, 8571648, 9764352, /* 3496-3503 */
10082048, 10732288, 11167232, 9995776, 9060864, 9392896, 10010112, 10546944, /* 3504-3511 */
10655744, 9957376, 9964800, 10572288, 10081792, 9387008, 8843776, 7406592, /* 3512-3519 */
6324992, 7118592, 8480512, 8754688, 7961344, 6862080, 6096128, 6178560, /* 3520-3527 */
6757376, 7715072, 8863488, 9114880, 8589056, 8137984, 7864320, 7320320, /* 3528-3535 */
6404864, 6294272, 7043072, 7214592, 7262208, 8317696, 9549568, 9324800, /* 3536-3543 */
8386048, 8302848, 8800768, 9297664, 9619456, 9427712, 8832768, 8543488, /* 3544-3551 */
8795904, 9489920, 10341888, 10250240, 9484032, 8939776, 8875776, 9011712, /* 3552-3559 */
8877056, 8992000, 9556992, 9351424, 8120832, 7352064, 8038912, 8663808, /* 3560-3567 */
8317184, 7803648, 7696384, 7729408, 7120384, 6686464, 7004160, 7131136, /* 3568-3575 */
7221760, 8256256, 9233152, 8873472, 8830976, 9459456, 8828672, 7748096, /* 3576-3583 */
7599616, 7695104, 8061184, 8376576, 7946752, 7554560, 7915008, 8000256, /* 3584-3591 */
7756800, 8217856, 9210624, 9633792, 8926976, 7760640, 7277056, 7469312, /* 3592-3599 */
8107776, 8389376, 7620352, 7438848, 8245248, 8438784, 8046080, 8397056, /* 3600-3607 */
9005824, 8675584, 8268800, 8500992, 8923904, 9714688, 10756096, 11013632, /* 3608-3615 */
10568704, 9751040, 9338880, 9577472, 9331200, 8280576, 7907328, 8387840, /* 3616-3623 */
8754688, 8887808, 8253696, 7189760, 6894848, 6874624, 6571264, 7338240, /* 3624-3631 */
9031424, 9542656, 8846336, 8188160, 6942208, 5652480, 5721856, 6462976, /* 3632-3639 */
7459072, 8795648, 9486336, 9431808, 9064960, 8328960, 8489728, 9845248, /* 3640-3647 */
10745600, 10771712, 10159104, 8900352, 8167680, 8597504, 9625088, 10651392, /* 3648-3655 */
10083072, 8024320, 6422272, 6234112, 6884096, 7927552, 9090304, 9416704, /* 3656-3663 */
8913408, 7981824, 6993664, 6891008, 7694080, 8628224, 9359616, 9193216, /* 3664-3671 */
8130816, 7570432, 8373760, 9263360, 9173248, 8709632, 8611072, 8369664, /* 3672-3679 */
7782656, 7997440, 9528832, 10448384, 9855488, 9072128, 9000192, 9653248, /* 3680-3687 */
10055680, 8779776, 6800896, 6753024, 8193792, 8985344, 8986880, 9060352, /* 3688-3695 */
9648640, 10205440, 9224448, 7212288, 6273024, 6747136, 7481344, 7463936, /* 3696-3703 */
7196672, 7038208, 6674688, 6345216, 7129600, 8612864, 8687104, 7994368, /* 3704-3711 */
8623360, 9223680, 8450560, 7754752, 7516672, 7209728, 7242496, 7267328, /* 3712-3719 */
7140352, 7689472, 8433408, 9133568, 10479872, 11026176, 9713664, 8088576, /* 3720-3727 */
7780864, 8133888, 8003072, 8032000, 9053952, 10521856, 11052544, 10532352, /* 3728-3735 */
10167040, 10054912, 9761536, 9481472, 8915712, 8271616, 7999744, 7511040, /* 3736-3743 */
6848000, 6596864, 6889984, 7434496, 7412224, 7085056, 7054848, 7511552, /* 3744-3751 */
8449280, 8950016, 8669952, 8658944, 8966400, 8991488, 8701184, 8289792, /* 3752-3759 */
8147200, 8115200, 8073472, 8801024, 9905408, 10816512, 11266816, 10530560, /* 3760-3767 */
9658880, 9382912, 8799744, 8252672, 8732928, 9006848, 8306944, 7754240, /* 3768-3775 */
7910912, 8351232, 8511744, 8147712, 7975936, 8174848, 7822336, 6949888, /* 3776-3783 */
6476032, 6441216, 6356992, 6259200, 6805504, 8288000, 9500672, 9078528, /* 3784-3791 */
8104704, 7999232, 8023040, 7796992, 8152320, 8579328, 8012032, 7806976, /* 3792-3799 */
8840960, 9403392, 9208832, 9288704, 9335296, 8843520, 8436224, 8595456, /* 3800-3807 */
9143552, 8968704, 7638784, 7174912, 7967488, 8313600, 8109568, 8078592, /* 3808-3815 */
8177664, 8192256, 8376832, 9047808, 9697536, 9981696, 9615872, 8602624, /* 3816-3823 */
7357184, 6733568, 7750912, 9133824, 9054464, 8496640, 8741120, 9653248, /* 3824-3831 */
10415872, 9862912, 8892672, 8892928, 9164544, 8963328, 8632320, 8568064, /* 3832-3839 */
8844032, 9152256, 8790016, 7337984, 6149632, 6545408, 7440128, 7319808, /* 3840-3847 */
6755840, 6465024, 5987840, 5804032, 6814720, 8214528, 8813312, 8754176, /* 3848-3855 */
9038336, 9741568, 10270720, 10362880, 9791488, 9593856, 10521344, 10797312, /* 3856-3863 */
9398528, 7960064, 8016128, 9102080, 9820928, 9820928, 9351680, 8244480, /* 3864-3871 */
7133952, 7232768, 8074240, 8769024, 9347840, 9774592, 9496320, 8320256, /* 3872-3879 */
6913024, 6360832, 6754304, 6848000, 6866944, 7386112, 7537152, 7397888, /* 3880-3887 */
7330304, 7251968, 7510016, 7822848, 7430912, 6725632, 7184896, 8803072, /* 3888-3895 */
10314496, 10979072, 10559488, 9396736, 8719104, 9214208, 9903104, 9831680, /* 3896-3903 */
9148672, 8740608, 8855808, 9098752, 9151232, 9071616, 8839168, 8570624, /* 3904-3911 */
8552960, 9084160, 9961472, 10244608, 9742592, 8999680, 8186112, 7605248, /* 3912-3919 */
7082496, 6515200, 6909952, 8327424, 9411840, 9073664, 7547904, 6377728, /* 3920-3927 */
6617088, 7603200, 8197376, 8014848, 7552512, 7544320, 7716608, 7605504, /* 3928-3935 */
7730432, 8057344, 7572224, 6884096, 7430656, 8245760, 8070144, 7853824, /* 3936-3943 */
8372736, 8981760, 9643776, 10045184, 9717760, 9236224, 9193728, 9842688, /* 3944-3951 */
10644480, 10403584, 9472512, 9035520, 8626176, 8257280, 8472320, 8747264, /* 3952-3959 */
8703488, 8664064, 8955648, 8786688, 7633408, 7401728, 8222976, 8229888, /* 3960-3967 */
7583744, 7097088, 6811904, 7091712, 7761920, 8087040, 8177152, 8140288, /* 3968-3975 */
7825152, 7905024, 8847360, 9650688, 9627648, 9388288, 9030400, 8310272, /* 3976-3983 */
8061184, 8504064, 8545280, 8281088, 8581120, 8930816, 8812544, 8576512, /* 3984-3991 */
8055808, 7444992, 7175936, 7363840, 8042496, 8476160, 8371712, 8636416, /* 3992-3999 */
8910848, 8531968, 8662784, 9315584, 9347584, 8929792, 8934400, 9684736, /* 4000-4007 */
10412800, 9897472, 8758528, 8704512, 9277440, 9160960, 8437504, 7918080, /* 4008-4015 */
8236800, 8809472, 8374272, 7388672, 7382784, 8076288, 8160000, 7538944, /* 4016-4023 */
6902784, 6748416, 7076096, 7862784, 8903936, 9492736, 9170176, 8624384, /* 4024-4031 */
8514048, 8716032, 8999936, 8775424, 7344896, 5735168, 5977344, 7217920, /* 4032-4039 */
7399424, 7116288, 7166464, 7302144, 7606272, 8121088, 8774400, 9415680, /* 4040-4047 */
9657344, 9514752, 9239552, 9149440, 9547520, 10137088, 10734848, 11223808, /* 4048-4055 */
10965504, 10191360, 9731840, 9584896, 9279488, 8640512, 7935232, 7608832, /* 4056-4063 */
7757056, 7848192, 7375616, 6778112, 6882560, 7285760, 7157248, 6689280, /* 4064-4071 */
6666240, 7170560, 7332352, 7116544, 7367680, 7854336, 7501568, 6979328, /* 4072-4079 */
7478016, 8353024, 8663808, 8754688, 9187840, 9530880, 9323264, 9266432, /* 4080-4087 */
10057984, 11363328, 12085504, 11216640, 9493504, 8952320, 9326336, 9347840, /* 4088-4095 */
9327872, 9175296, 8508928, 7884288, 7774976, 7823872, 7625984, 7458560, /* 4096-4103 */
7568384, 7505664, 7217664, 7027200, 7018496, 7369728, 8047104, 8470528, /* 4104-4111 */
8242688, 7555840, 7033344, 7120384, 7400192, 7477504, 7620608, 7892736, /* 4112-4119 */
8265984, 8902400, 9647104, 10214912, 10356736, 10205184, 10252800, 10429184, /* 4120-4127 */
10244096, 9280768, 8115200, 8030976, 8705792, 8879616, 8450048, 8331264, /* 4128-4135 */
8977152, 9787136, 9848576, 8990464, 8193280, 8028672, 7871744, 7490560, /* 4136-4143 */
7106304, 6679296, 6452736, 6255872, 6005504, 6270720, 7018240, 7815936, /* 4144-4151 */
8602624, 9100544, 8918528, 8079360, 7347456, 7312384, 7542016, 7561984, /* 4152-4159 */
7681280, 8370432, 9168128, 9499904, 9689600, 10139904, 10425088, 10037760, /* 4160-4167 */
9342464, 8918272, 8564480, 8083456, 7982848, 8659456, 9420032, 9765888, /* 4168-4175 */
9983488, 10060800, 9623808, 8466176, 7312128, 7213056, 7679232, 7717120, /* 4176-4183 */
7283456, 6819584, 6831360, 7519744, 8113408, 7905792, 7946496, 8993792, /* 4184-4191 */
9957120, 10025728, 9685760, 9300992, 8657152, 7920896, 7785472, 8272128, /* 4192-4199 */
8372480, 7822336, 7424768, 7709184, 8457472, 8758784, 8589056, 8713984, /* 4200-4207 */
8845568, 8430592, 7896576, 7848448, 8201728, 8781312, 9303040, 9134336, /* 4208-4215 */
8161280, 7293440, 7368960, 7846144, 7867648, 7665408, 7720960, 8052736, /* 4216-4223 */
8392960, 8491264, 8380672, 8179200, 8116224, 8543232, 9208320, 9414912, /* 4224-4231 */
9195776, 9500416, 10112512, 9892352, 9134592, 8553728, 8231424, 8392704, /* 4232-4239 */
8907520, 9015296, 8434944, 7837440, 7811840, 8114944, 8386048, 8393984, /* 4240-4247 */
8215296, 8259328, 8181760, 7637504, 7236864, 7118592, 7237120, 7715328, /* 4248-4255 */
7810560, 7139328, 6529024, 6545920, 7326720, 8596992, 9381632, 9309440, /* 4256-4263 */
9031936, 9077504, 9404160, 9543424, 9422592, 9355520, 9154304, 8744192, /* 4264-4271 */
8602880, 8787200, 9064448, 9492992, 9681664, 9347840, 8971776, 8801024, /* 4272-4279 */
8669696, 8563456, 8758272, 9209088, 9293312, 8768512, 8096768, 7754496, /* 4280-4287 */
7539712, 6930432, 6153728, 6022144, 6630656, 7164928, 7309056, 7641856, /* 4288-4295 */
8370688, 8953600, 9007360, 8642560, 8379136, 8428288, 8565248, 8707840, /* 4296-4303 */
8669696, 8384512, 8285952, 8673536, 9256960, 9708288, 9888256, 9619200, /* 4304-4311 */
9018624, 8536576, 8232704, 8033792, 8156160, 8483328, 8723456, 8878336, /* 4312-4319 */
8919552, 8766464, 8632064, 8657152, 8461824, 8004864, 7715328, 7691008, /* 4320-4327 */
7851008, 7860992, 7555840, 7549696, 7733248, 7552768, 7462656, 7771648, /* 4328-4335 */
7985408, 8015872, 8368896, 9018880, 9214976, 8676608, 8057856, 7904256, /* 4336-4343 */
8075264, 8360704, 8732672, 8949248, 8853504, 8791552, 8822272, 8659200, /* 4344-4351 */
8510464, 8690432, 9049856, 9275392, 9184256, 8956160, 8921600, 8882432, /* 4352-4359 */
8463360, 7845632, 7661056, 8242176, 8950016, 9141248, 8960000, 8619264, /* 4360-4367 */
8227840, 8108288, 8238080, 8235776, 8079104, 7963136, 7853824, 7886848, /* 4368-4375 */
8129280, 8002560, 7623680, 7950336, 8504576, 8242432, 7697664, 7788800, /* 4376-4383 */
8448512, 8960256, 8760320, 8182784, 7963392, 8260096, 8725504, 9073408, /* 4384-4391 */
8980480, 8420096, 8226304, 8897280, 9305600, 8508416, 7497216, 7372288, /* 4392-4399 */
7827456, 8368128, 8963584, 9411584, 9405696, 8972288, 8596736, 8552448, /* 4400-4407 */
8512256, 8386560, 8387584, 8363776, 8154368, 7903744, 7745024, 7930368, /* 4408-4415 */
8242944, 8090624, 7804416, 7913728, 8219648, 8353792, 8188160, 7805440, /* 4416-4423 */
7492864, 7500288, 7602944, 7574528, 7610880, 7984128, 8306432, 8252672, /* 4424-4431 */
8303360, 8788224, 9272832, 8982016, 8255232, 8337408, 9024256, 9428480, /* 4432-4439 */
9716480, 9760256, 9240064, 8773888, 8755712, 8874496, 8830976, 8660224, /* 4440-4447 */
8602624, 8488448, 8212480, 8244736, 8548608, 8609024, 8347648, 8023296, /* 4448-4455 */
7955456, 8444416, 9038336, 9026816, 9001728, 9383424, 9304064, 8445184, /* 4456-4463 */
7714048, 7705600, 7876864, 7675648, 7519744, 7723264, 7852032, 7918592, /* 4464-4471 */
8237824, 8455936, 8379904, 8515840, 8722688, 8513792, 8237056, 8095744, /* 4472-4479 */
7920384, 7892736, 8122880, 8262656, 8065536, 7859712, 7951104, 8433408, /* 4480-4487 */
9130496, 9383168, 9073408, 8762368, 8644096, 8789504, 9152256, 9291264, /* 4488-4495 */
9275648, 9274368, 8856064, 8124928, 7903744, 8199424, 8320256, 8225536, /* 4496-4503 */
8173824, 8111616, 7771392, 7224064, 7025920, 7427072, 7917312, 7750144, /* 4504-4511 */
7165696, 7144960, 7776512, 8101888, 7880192, 7898112, 8323072, 8547072, /* 4512-4519 */
8769024, 9191168, 9105152, 8370688, 7923456, 8215040, 8856576, 9337856, /* 4520-4527 */
9258752, 8909824, 8784896, 8889088, 8861440, 8599808, 8529152, 8854528, /* 4528-4535 */
9118976, 9020672, 8835072, 8725248, 8519168, 8448512, 8782336, 8813568, /* 4536-4543 */
8392448, 8465664, 8973568, 9225984, 9136128, 8851712, 8774400, 8943104, /* 4544-4551 */
8675072, 8000256, 7871232, 8146432, 7743744, 6878464, 6788608, 7222272, /* 4552-4559 */
6962176, 6304000, 6280704, 6924288, 7705600, 8320512, 8699136, 8981248, /* 4560-4567 */
9050368, 8773632, 8703744, 9100800, 9380608, 9353984, 9495040, 9602048, /* 4568-4575 */
9033472, 8578560, 9022976, 9346816, 8866048, 8353024, 8376576, 8704256, /* 4576-4583 */
8926208, 8893440, 8579328, 8076032, 7426816, 6838016, 7055104, 8056832, /* 4584-4591 */
8876032, 8990208, 8601856, 8149760, 7565568, 7040768, 7271680, 7756544, /* 4592-4599 */
7489792, 7107072, 7681280, 8549888, 8797440, 8823808, 8898560, 8781056, /* 4600-4607 */
8664576, 8838144, 8990208, 9072384, 9178880, 9034752, 9108480, 9521408, /* 4608-4615 */
9358592, 8780800, 8649728, 8573696, 8315648, 8168960, 8135424, 8045824, /* 4616-4623 */
7990272, 8152576, 8195584, 7895552, 7766528, 8122112, 8482048, 8560384, /* 4624-4631 */
8677376, 8855296, 8900352, 8865792, 8809216, 8628224, 8123136, 7540992, /* 4632-4639 */
7369984, 7285760, 7155200, 7555328, 8137472, 8086272, 7633408, 7549440, /* 4640-4647 */
7922688, 8214272, 8144640, 8015360, 8121600, 8481792, 8838400, 8947712, /* 4648-4655 */
8932352, 8771072, 8368384, 8358912, 8967936, 9341184, 9143040, 8956928, /* 4656-4663 */
9065984, 9052672, 8952832, 9128960, 9048576, 8344576, 7974912, 8491520, /* 4664-4671 */
9124864, 9181696, 8787200, 8410112, 8302336, 8334592, 8304896, 8233472, /* 4672-4679 */
8254464, 8221696, 8243712, 8342016, 8020992, 7456768, 7256832, 7596544, /* 4680-4687 */
8030464, 7926016, 7586816, 7909120, 8669440, 8776448, 8253184, 7894272, /* 4688-4695 */
8073472, 8474368, 8569856, 8336384, 8042752, 7903744, 8089856, 8403456, /* 4696-4703 */
8516608, 8377856, 8118016, 8189440, 8603648, 8970240, 9119744, 9032192, /* 4704-4711 */
8782080, 8687616, 8646656, 8322304, 8116480, 8400896, 8690688, 8773120, /* 4712-4719 */
8709120, 8416512, 8294144, 8609792, 8824064, 8571136, 8218624, 7958016, /* 4720-4727 */
7768064, 7799808, 7839744, 7700480, 7608064, 7667200, 7819008, 8140288, /* 4728-4735 */
8589056, 8891904, 8914176, 8872192, 8923136, 8950528, 8866560, 8635904, /* 4736-4743 */
8487936, 8465408, 8414976, 8526336, 8902400, 9153536, 9054976, 8716544, /* 4744-4751 */
8409344, 8277248, 8369664, 8329472, 7950592, 7689472, 8046080, 8656640, /* 4752-4759 */
8616960, 8144640, 8057344, 8252672, 8451584, 8704000, 8796672, 8526336, /* 4760-4767 */
8054272, 7804416, 7857664, 8081408, 8359680, 8102144, 7686400, 7915520, /* 4768-4775 */
8332544, 8297216, 7922432, 7716352, 7885312, 8068608, 8136192, 8584704, /* 4776-4783 */
9229056, 9436160, 9269760, 9153280, 9298688, 9669888, 9765632, 9116928, /* 4784-4791 */
8496640, 8690432, 9041920, 8682496, 8167424, 8048384, 7750400, 7126784, /* 4792-4799 */
6955520, 7302144, 7358464, 6942720, 6965248, 7694080, 8326912, 8638464, /* 4800-4807 */
8806656, 8712960, 8509952, 8666880, 9094144, 9345792, 9192704, 8754944, /* 4808-4815 */
8589056, 9071360, 9371648, 8803072, 8166144, 8002304, 7969024, 7857920, /* 4816-4823 */
7886336, 8193536, 8367360, 8114432, 8001536, 8354048, 8444160, 8175872, /* 4824-4831 */
8306432, 8677888, 8798976, 8605696, 8126208, 7848960, 8295168, 8926208, /* 4832-4839 */
8995328, 8640512, 8271360, 8120320, 8399872, 8777728, 8671232, 8246272, /* 4840-4847 */
8020992, 8136704, 8278272, 8013568, 7721984, 8037632, 8234496, 7793152, /* 4848-4855 */
7596544, 7798272, 7989504, 8383488, 8579584, 8411392, 8283136, 8249088, /* 4856-4863 */
8256768, 8378880, 8416256, 8181248, 7754752, 7581440, 7972352, 8403456, /* 4864-4871 */
8518400, 8786688, 9085696, 8979712, 8788224, 8898816, 9009408, 9012480, /* 4872-4879 */
8941312, 8852992, 8771840, 8525568, 8290560, 8497664, 8969728, 8829952, /* 4880-4887 */
8246528, 8115712, 8431616, 8624640, 8470784, 8126976, 7835136, 7851008, /* 4888-4895 */
8262912, 8525312, 8444928, 8513792, 8605184, 8506368, 8401152, 8104704, /* 4896-4903 */
7808512, 8056832, 8476672, 8408320, 7942400, 7816960, 8081920, 8127232, /* 4904-4911 */
7795456, 7724288, 8141568, 8568576, 8485376, 8088064, 8141312, 8849152, /* 4912-4919 */
9360128, 8986880, 8414976, 8314368, 8409088, 8495872, 8702208, 8987392, /* 4920-4927 */
9328896, 9401088, 8932352, 8463872, 8417792, 8457728, 8493056, 8521984, /* 4928-4935 */
8362240, 8163840, 7989504, 7897344, 8014848, 8134912, 8081664, 8129536, /* 4936-4943 */
8207616, 8031488, 7764736, 7592704, 7429120, 7400960, 7749120, 8302592, /* 4944-4951 */
8518656, 8186624, 7946752, 8299264, 8622848, 8681984, 9179904, 9632512, /* 4952-4959 */
9189632, 8651776, 8763648, 9040640, 8890368, 8439808, 8274944, 8444928, /* 4960-4967 */
8430848, 8285440, 8428544, 8634112, 8470272, 7974912, 7690496, 7877632, /* 4968-4975 */
8260096, 8362240, 8474112, 8946432, 9221120, 8846080, 8299264, 8205568, /* 4976-4983 */
8475904, 8777984, 8724992, 8332544, 8127744, 8238592, 8079616, 7909120, /* 4984-4991 */
8019200, 8026880, 7771136, 7647744, 8051456, 8425472, 8096768, 7846400, /* 4992-4999 */
8303104, 8550144, 8052992, 7738880, 8029696, 8165376, 8150784, 8282368, /* 5000-5007 */
8483840, 8849152, 8975104, 8613632, 8392704, 8432640, 8523264, 8813312, /* 5008-5015 */
9030400, 8957440, 8811776, 8547584, 8329984, 8380672, 8428800, 8465664, /* 5016-5023 */
8601088, 8581632, 8373248, 8297216, 8328192, 8312576, 8247040, 8106496, /* 5024-5031 */
7972352, 8000256, 8033792, 8132352, 8630016, 8842752, 8272896, 7645184, /* 5032-5039 */
7230720, 7389440, 8379136, 9066240, 8749568, 8362752, 8678656, 9250816, /* 5040-5047 */
9112320, 8444160, 8148992, 8401408, 8763392, 8826368, 8512256, 8413440, /* 5048-5055 */
8683520, 8672000, 8351488, 8090368, 8030720, 8239360, 8390656, 8076800, /* 5056-5063 */
7537920, 7490560, 8003584, 8308992, 8205056, 8258560, 8588800, 8987648, /* 5064-5071 */
9419264, 9576192, 9207296, 8672512, 8396544, 8273664, 8179968, 8112128, /* 5072-5079 */
7826432, 7699968, 8001536, 8158464, 7941120, 7611392, 7444736, 7745280, /* 5080-5087 */
8384768, 8572160, 8378624, 8491264, 8738048, 8738304, 8606464, 8641792, /* 5088-5095 */
8724736, 8622080, 8625664, 8895488, 9069312, 8867584, 8507392, 8342016, /* 5096-5103 */
8414720, 8464640, 8481536, 8410880, 8366848, 8348672, 8158464, 8041216, /* 5104-5111 */
8324096, 8385536, 8162816, 8104960, 8105728, 8122368, 8327424, 8415488, /* 5112-5119 */
8125440, 7909632, 8288256, 8740352, 8699392, 8431104, 8178176, 8115712, /* 5120-5127 */
8466432, 8756992, 8540928, 8274432, 8345344, 8514560, 8527616, 8557312, /* 5128-5135 */
8605696, 8426496, 7936256, 7672576, 7929600, 8306432, 8489472, 8466176, /* 5136-5143 */
8338688, 8011264, 7846144, 8262656, 8708096, 8628480, 8365824, 8448768, /* 5144-5151 */
8899072, 9051648, 8649984, 8256768, 8249344, 8535808, 8613632, 8252928, /* 5152-5159 */
8096256, 8369152, 8442112, 8288512, 8294400, 8545536, 8744704, 8831232, /* 5160-5167 */
8830464, 8483584, 8022784, 8057344, 8279808, 8238336, 8017152, 7895296, /* 5168-5175 */
8071936, 8245248, 8187136, 8048128, 8084992, 8243200, 8391424, 8244736, /* 5176-5183 */
8040960, 8203776, 8578048, 8817152, 8903168, 8702464, 8385792, 8257536, /* 5184-5191 */
8290048, 8189440, 8062976, 8297984, 8619008, 8602368, 8348672, 8231936, /* 5192-5199 */
8644864, 9030656, 8614144, 8169472, 8421120, 8532224, 8218880, 8125184, /* 5200-5207 */
8337664, 8551168, 8537856, 8551424, 8803328, 8859392, 8425984, 8087808, /* 5208-5215 */
8114688, 8316672, 8552192, 8375552, 7971840, 7992832, 8188416, 8059392, /* 5216-5223 */
8019712, 8445440, 9038336, 9511936, 9261312, 8320512, 7859200, 8104448, /* 5224-5231 */
8341248, 8535808, 8718336, 8605184, 8182272, 7845888, 8049664, 8282624, /* 5232-5239 */
8032000, 8030976, 8360704, 8323584, 8061184, 8047104, 8263680, 8412416, /* 5240-5247 */
8149504, 7867392, 8094976, 8525824, 8544512, 8257280, 8281344, 8814336, /* 5248-5255 */
9169664, 9135872, 9042432, 8781312, 8481024, 8283904, 8093440, 8093184, /* 5256-5263 */
8391936, 8691200, 8567040, 8110592, 8041984, 8382976, 8464128, 8423168, /* 5264-5271 */
8386560, 8236800, 8186880, 8325632, 8411392, 8410368, 8446464, 8448768, /* 5272-5279 */
8399360, 8290560, 8078336, 8053248, 8281088, 8317952, 8080128, 8057856, /* 5280-5287 */
8091392, 7930112, 7956736, 8186624, 8326912, 8482048, 8530944, 8308736, /* 5288-5295 */
8205824, 8391680, 8599040, 8636928, 8631808, 8571648, 8474368, 8455680, /* 5296-5303 */
8461824, 8465920, 8685312, 8991232, 9018368, 8641280, 8243200, 8264192, /* 5304-5311 */
8372224, 8346112, 8523520, 8643584, 8479744, 8412672, 8398336, 8315136, /* 5312-5319 */
8132608, 8134912, 8565760, 8848384, 8511488, 8256768, 8506368, 8691456, /* 5320-5327 */
8461056, 8250112, 8245504, 8258560, 8267008, 8185600, 7822336, 7658496, /* 5328-5335 */
7953920, 8261376, 8379648, 8249088, 7965696, 7921408, 8035840, 8114688, /* 5336-5343 */
8158464, 8186368, 8364800, 8554240, 8351744, 8206336, 8397312, 8542976, /* 5344-5351 */
8568576, 8694528, 8814592, 8740608, 8503808, 8403200, 8454144, 8555008, /* 5352-5359 */
8633600, 8470784, 8286976, 8410112, 8620800, 8775168, 8907264, 8858880, /* 5360-5367 */
8681216, 8681216, 8979456, 9103104, 8660480, 8168448, 8264960, 8473344, /* 5368-5375 */
8406528, 8292608, 8206080, 8060416, 8026112, 8065792, 8047360, 8108032, /* 5376-5383 */
8219392, 8126208, 8015360, 7888128, 7704576, 7912704, 8297472, 8186880, /* 5384-5391 */
8029696, 8178944, 8301568, 8446720, 8546560, 8438528, 8472576, 8615424, /* 5392-5399 */
8489984, 8280064, 8405248, 8802048, 9115904, 9057024, 8863232, 8823808, /* 5400-5407 */
8730368, 8389376, 8235264, 8308736, 8326912, 8483328, 8642304, 8443136, /* 5408-5415 */
8192768, 7929088, 7662080, 7968000, 8524288, 8543488, 8266496, 8188160, /* 5416-5423 */
8111360, 7913472, 7988480, 8418304, 8580864, 8336384, 8190976, 8148992, /* 5424-5431 */
8003584, 8014592, 8231936, 8411904, 8512512, 8631296, 8763904, 8785152, /* 5432-5439 */
8861440, 8957952, 8762368, 8545024, 8435456, 8241920, 8274944, 8500736, /* 5440-5447 */
8439552, 8179200, 8225536, 8421120, 8401408, 8277760, 8281344, 8211968, /* 5448-5455 */
8061696, 8301312, 8683520, 8689664, 8513024, 8347648, 8331520, 8465152, /* 5456-5463 */
8486656, 8553216, 8687872, 8599296, 8402432, 8256512, 8134912, 8246016, /* 5464-5471 */
8569344, 8647680, 8505088, 8581888, 8771072, 8677376, 8352256, 8163328, /* 5472-5479 */
8164096, 7975680, 7662336, 7704320, 8033536, 8203008, 8205568, 8207104, /* 5480-5487 */
8253184, 8371200, 8377856, 8271616, 8317696, 8513792, 8668416, 8762112, /* 5488-5495 */
8846080, 8883712, 8742144, 8451072, 8250624, 8175616, 8279808, 8472576, /* 5496-5503 */
8386816, 8057856, 8009984, 8339456, 8584192, 8398080, 8187136, 8303872, /* 5504-5511 */
8451328, 8594944, 8758272, 8659200, 8500992, 8586496, 8643584, 8534016, /* 5512-5519 */
8357632, 8276224, 8318208, 8274688, 8131840, 8030976, 7930880, 7853568, /* 5520-5527 */
7947776, 8126208, 8082176, 8041984, 8349696, 8609792, 8547840, 8527360, /* 5528-5535 */
8563968, 8512768, 8528384, 8631040, 8675840, 8652032, 8567808, 8451840, /* 5536-5543 */
8260864, 8092672, 8173824, 8335616, 8370432, 8377088, 8389888, 8410112, /* 5544-5551 */
8506624, 8685568, 8787712, 8805632, 8865792, 8733184, 8332032, 8185856, /* 5552-5559 */
8385024, 8405504, 8175616, 7933184, 7844864, 7916544, 7890944, 7817984, /* 5560-5567 */
7995136, 8329472, 8489216, 8384256, 8328448, 8493568, 8531712, 8346624, /* 5568-5575 */
8292864, 8436480, 8654080, 8777216, 8719872, 8566784, 8375040, 8242176, /* 5576-5583 */
8352000, 8635136, 8885248, 9027584, 8922112, 8583936, 8308224, 8337408, /* 5584-5591 */
8517632, 8547584, 8402432, 8346368, 8425472, 8486912, 8499456, 8512256, /* 5592-5599 */
8511744, 8431872, 8252160, 8058624, 8116992, 8481536, 8703232, 8428800, /* 5600-5607 */
8077312, 8063488, 8163072, 8058112, 7887872, 7864832, 7879680, 7797504, /* 5608-5615 */
7731200, 7833600, 8021504, 8078848, 8000256, 8042240, 8280576, 8580608, /* 5616-5623 */
8752896, 8699904, 8556032, 8433408, 8359680, 8489472, 8713472, 8710400, /* 5624-5631 */
8576000, 8540672, 8657664, 8795392, 8908032, 9017600, 8944896, 8640512, /* 5632-5639 */
8456960, 8472832, 8498944, 8534272, 8533248, 8462080, 8395264, 8258048, /* 5640-5647 */
8054784, 8109312, 8500736, 8792064, 8658176, 8395776, 8321280, 8281856, /* 5648-5655 */
8241664, 8257024, 8162048, 7930368, 7785728, 7894784, 8067584, 7987712, /* 5656-5663 */
7847936, 7995392, 8171520, 8156928, 8196352, 8323072, 8450048, 8601088, /* 5664-5671 */
8726528, 8769024, 8712704, 8655104, 8595968, 8464896, 8413952, 8497152, /* 5672-5679 */
8546816, 8571136, 8693760, 8789248, 8758784, 8722688, 8708864, 8705792, /* 5680-5687 */
8707840, 8599552, 8457216, 8440320, 8434432, 8273152, 8133376, 8216576, /* 5688-5695 */
8325888, 8193536, 8031488, 8168448, 8341504, 8252928, 8151296, 8140800, /* 5696-5703 */
8120320, 8182016, 8332032, 8370432, 8300288, 8276224, 8334848, 8349440, /* 5704-5711 */
8235520, 8062976, 8015616, 8171264, 8453120, 8656896, 8567040, 8259584, /* 5712-5719 */
8219392, 8550912, 8668416, 8423680, 8206848, 8126208, 8114176, 8113664, /* 5720-5727 */
8056064, 8105984, 8377600, 8562944, 8515328, 8522752, 8701952, 8778752, /* 5728-5735 */
8624384, 8483584, 8524288, 8596480, 8557056, 8463104, 8516864, 8640000, /* 5736-5743 */
8677120, 8700672, 8713984, 8651520, 8557824, 8449536, 8391424, 8398848, /* 5744-5751 */
8246272, 7969792, 7840768, 7811072, 7752960, 7774720, 7945728, 8181504, /* 5752-5759 */
8293632, 8220160, 8157440, 8306688, 8576512, 8678400, 8670208, 8730368, /* 5760-5767 */
8703488, 8551680, 8490240, 8568064, 8622080, 8562176, 8432640, 8396032, /* 5768-5775 */
8508416, 8614400, 8501760, 8221952, 8117760, 8262400, 8341248, 8273920, /* 5776-5783 */
8224256, 8195072, 8158208, 8131328, 8111360, 8258048, 8577024, 8677376, /* 5784-5791 */
8513536, 8495360, 8611584, 8584192, 8531968, 8600320, 8683008, 8665088, /* 5792-5799 */
8522496, 8342784, 8301056, 8383488, 8384512, 8294144, 8339456, 8540160, /* 5800-5807 */
8575744, 8309248, 8088576, 8154624, 8293632, 8293632, 8343040, 8492032, /* 5808-5815 */
8400384, 8151552, 8174592, 8424960, 8569344, 8584448, 8553728, 8526592, /* 5816-5823 */
8486144, 8404736, 8438528, 8564736, 8508672, 8307456, 8225792, 8359168, /* 5824-5831 */
8554496, 8547584, 8344320, 8285184, 8365312, 8256256, 8118272, 8263680, /* 5832-5839 */
8469248, 8445440, 8317184, 8128512, 7877376, 7865600, 8068864, 8162304, /* 5840-5847 */
8190208, 8297728, 8326656, 8200448, 8174592, 8428800, 8645632, 8568832, /* 5848-5855 */
8549376, 8672000, 8537088, 8309248, 8419584, 8657664, 8703488, 8696576, /* 5856-5863 */
8777472, 8794112, 8674560, 8531968, 8433664, 8323584, 8278016, 8379392, /* 5864-5871 */
8431616, 8291072, 8166144, 8166656, 8192256, 8291840, 8450304, 8448512, /* 5872-5879 */
8284672, 8185856, 8261632, 8377856, 8328704, 8203776, 8224000, 8283392, /* 5880-5887 */
8223488, 8111616, 8084992, 8195072, 8309760, 8230656, 8150016, 8289024, /* 5888-5895 */
8471552, 8520960, 8572672, 8681984, 8698112, 8527872, 8448000, 8673536, /* 5896-5903 */
8832768, 8616448, 8437248, 8549376, 8659712, 8604160, 8559104, 8606976, /* 5904-5911 */
8649216, 8583680, 8363776, 8080640, 8046080, 8336384, 8483072, 8305920, /* 5912-5919 */
8188928, 8136704, 7976448, 8005120, 8251392, 8243968, 7992576, 7943424, /* 5920-5927 */
8149248, 8358400, 8494848, 8546816, 8503552, 8505344, 8570880, 8544512, /* 5928-5935 */
8549888, 8696064, 8683264, 8428800, 8304384, 8435968, 8586240, 8584448, /* 5936-5943 */
8463360, 8357120, 8356096, 8431104, 8435968, 8341504, 8331264, 8510976, /* 5944-5951 */
8648192, 8527360, 8320512, 8232192, 8206848, 8225536, 8357120, 8481536, /* 5952-5959 */
8504576, 8584704, 8711424, 8713472, 8535808, 8254976, 8061952, 8075008, /* 5960-5967 */
8143360, 8152064, 8139264, 8144896, 8237568, 8267264, 8087808, 8038144, /* 5968-5975 */
8238080, 8279296, 8223744, 8487936, 8877824, 8914944, 8615424, 8377856, /* 5976-5983 */
8384000, 8455424, 8405760, 8299520, 8280576, 8369920, 8379904, 8237312, /* 5984-5991 */
8202240, 8346112, 8464640, 8529664, 8569088, 8513792, 8425472, 8310272, /* 5992-5999 */
8178688, 8209664, 8404480, 8533760, 8527360, 8467712, 8374784, 8233216, /* 6000-6007 */
8219392, 8413440, 8545024, 8460800, 8381440, 8426496, 8484864, 8427008, /* 6008-6015 */
8285952, 8276992, 8464640, 8634880, 8602880, 8414976, 8276224, 8293888, /* 6016-6023 */
8321280, 8329216, 8429568, 8526080, 8490752, 8396800, 8367360, 8410368, /* 6024-6031 */
8416768, 8308480, 8168448, 8143360, 8270592, 8421632, 8527360, 8621056, /* 6032-6039 */
8651520, 8514560, 8398592, 8437504, 8423424, 8302080, 8252672, 8307456, /* 6040-6047 */
8312832, 8249600, 8221440, 8259840, 8319744, 8450560, 8598272, 8569600, /* 6048-6055 */
8478464, 8506112, 8484352, 8365312, 8422400, 8617216, 8538624, 8193280, /* 6056-6063 */
8014848, 8134144, 8270080, 8357632, 8551424, 8771072, 8762880, 8466688, /* 6064-6071 */
8169728, 8200960, 8465664, 8587008, 8499200, 8375808, 8265984, 8254976, /* 6072-6079 */
8412928, 8494336, 8318720, 8159232, 8230656, 8369408, 8413952, 8393984, /* 6080-6087 */
8342528, 8247808, 8236288, 8342016, 8336640, 8235264, 8334080, 8544256, /* 6088-6095 */
8519680, 8350976, 8273664, 8244736, 8220416, 8281344, 8351232, 8346880, /* 6096-6103 */
8350208, 8406016, 8485888, 8519168, 8502272, 8519168, 8530688, 8429056, /* 6104-6111 */
8332032, 8426240, 8590080, 8602624, 8471552, 8350464, 8318720, 8377344, /* 6112-6119 */
8496640, 8596224, 8599040, 8549888, 8537344, 8497664, 8396032, 8337152, /* 6120-6127 */
8356864, 8397056, 8452608, 8498176, 8444672, 8338944, 8258816, 8202496, /* 6128-6135 */
8259584, 8493824, 8622848, 8422400, 8176384, 8194304, 8364032, 8495104, /* 6136-6143 */
8494592, 8357120, 8169984, 8034048, 8078592, 8318464, 8535808, 8527360, /* 6144-6151 */
8343808, 8153856, 8142336, 8271616, 8268800, 8175872, 8237824, 8323072, /* 6152-6159 */
8311808, 8374784, 8504064, 8548864, 8496384, 8443648, 8451328, 8491008, /* 6160-6167 */
8555520, 8643072, 8655360, 8574208, 8525824, 8501504, 8415232, 8369920, /* 6168-6175 */
8427008, 8494080, 8521472, 8520192, 8482816, 8485888, 8554240, 8536320, /* 6176-6183 */
8374784, 8229888, 8231168, 8334592, 8385024, 8287488, 8085504, 7983360, /* 6184-6191 */
8074496, 8210176, 8309760, 8391168, 8334592, 8143872, 8050944, 8152832, /* 6192-6199 */
8282624, 8257024, 8214272, 8316928, 8405760, 8363264, 8354304, 8386560, /* 6200-6207 */
8342528, 8338432, 8471296, 8627456, 8724736, 8778752, 8792576, 8779008, /* 6208-6215 */
8786176, 8767488, 8644608, 8555008, 8617216, 8739328, 8742656, 8625152, /* 6216-6223 */
8502784, 8351488, 8114688, 7952640, 7939072, 7951872, 7977216, 8099840, /* 6224-6231 */
8204544, 8200960, 8189952, 8191488, 8133376, 8115456, 8236288, 8380416, /* 6232-6239 */
8434432, 8432640, 8403456, 8373760, 8423168, 8556544, 8703232, 8760832, /* 6240-6247 */
8683008, 8559360, 8540672, 8640768, 8670720, 8511232, 8346368, 8300032, /* 6248-6255 */
8286464, 8279040, 8328960, 8360960, 8332800, 8322048, 8361472, 8468480, /* 6256-6263 */
8540672, 8429568, 8293888, 8315648, 8354560, 8305664, 8273408, 8316416, /* 6264-6271 */
8388864, 8384512, 8284416, 8210688, 8267520, 8403712, 8477184, 8466688, /* 6272-6279 */
8472576, 8491264, 8453120, 8498432, 8604416, 8542208, 8381696, 8345088, /* 6280-6287 */
8338176, 8260608, 8178432, 8125696, 8087040, 8131840, 8283392, 8440576, /* 6288-6295 */
8464384, 8371200, 8325632, 8422144, 8601344, 8680448, 8569856, 8434432, /* 6296-6303 */
8440064, 8532992, 8519424, 8360448, 8286976, 8409600, 8528640, 8506368, /* 6304-6311 */
8450048, 8445440, 8490752, 8473088, 8366080, 8333312, 8422400, 8470272, /* 6312-6319 */
8456192, 8413696, 8294144, 8190976, 8186624, 8154368, 8048384, 8034816, /* 6320-6327 */
8175872, 8325888, 8333312, 8272128, 8286976, 8360704, 8419584, 8439296, /* 6328-6335 */
8388608, 8227072, 8120320, 8272896, 8546048, 8668928, 8612096, 8476672, /* 6336-6343 */
8399872, 8525056, 8754432, 8868864, 8806400, 8624896, 8457728, 8416768, /* 6344-6351 */
8430080, 8384000, 8285440, 8183296, 8177152, 8247808, 8264192, 8215040, /* 6352-6359 */
8182016, 8212224, 8257536, 8285440, 8354048, 8461568, 8430848, 8273664, /* 6360-6367 */
8288000, 8524800, 8631296, 8526592, 8483840, 8564992, 8624896, 8598016, /* 6368-6375 */
8541440, 8530176, 8527616, 8423424, 8306944, 8329216, 8354048, 8254208, /* 6376-6383 */
8209920, 8326912, 8440832, 8425216, 8335104, 8283648, 8316416, 8333312, /* 6384-6391 */
8273408, 8217344, 8215808, 8236544, 8247040, 8245248, 8259840, 8287232, /* 6392-6399 */
8285952, 8344320, 8543744, 8737024, 8772608, 8715264, 8728576, 8832512, /* 6400-6407 */
8866048, 8749568, 8570880, 8410880, 8303104, 8308224, 8369408, 8315136, /* 6408-6415 */
8214528, 8214016, 8179968, 8056576, 8080128, 8220160, 8215296, 8124672, /* 6416-6423 */
8146944, 8192000, 8140800, 8112384, 8250112, 8431616, 8500992, 8491008, /* 6424-6431 */
8463360, 8443648, 8480768, 8526848, 8521728, 8571136, 8634112, 8554496, /* 6432-6439 */
8404736, 8311552, 8237568, 8132608, 8140544, 8335360, 8577024, 8675072, /* 6440-6447 */
8564992, 8369408, 8291328, 8321024, 8315392, 8325376, 8432896, 8420608, /* 6448-6455 */
8251136, 8232704, 8429312, 8579584, 8545792, 8420608, 8404480, 8509952, /* 6456-6463 */
8553728, 8526848, 8546304, 8599552, 8591616, 8501248, 8334336, 8145152, /* 6464-6471 */
8014592, 7986944, 8075776, 8296704, 8527104, 8594688, 8539648, 8506880, /* 6472-6479 */
8461568, 8366592, 8341760, 8424960, 8468480, 8398080, 8386304, 8465920, /* 6480-6487 */
8458240, 8370176, 8348928, 8414976, 8464640, 8462336, 8468736, 8542464, /* 6488-6495 */
8581376, 8481024, 8334336, 8253696, 8225536, 8231936, 8254464, 8278272, /* 6496-6503 */
8362496, 8428032, 8366592, 8289280, 8329984, 8422912, 8485632, 8496384, /* 6504-6511 */
8480768, 8475648, 8468480, 8393472, 8270080, 8196352, 8237824, 8318208, /* 6512-6519 */
8372736, 8435968, 8464640, 8372480, 8269312, 8316160, 8408320, 8413952, /* 6520-6527 */
8417024, 8453632, 8436480, 8413440, 8405504, 8321280, 8298752, 8430848, /* 6528-6535 */
8461568, 8289792, 8219904, 8336384, 8393984, 8306176, 8289280, 8450048, /* 6536-6543 */
8599296, 8565504, 8444160, 8398336, 8369152, 8323840, 8386560, 8480256, /* 6544-6551 */
8421888, 8280320, 8216064, 8270336, 8362240, 8332800, 8256000, 8401408, /* 6552-6559 */
8670208, 8742912, 8633600, 8568320, 8591616, 8601600, 8507136, 8400896, /* 6560-6567 */
8390400, 8366848, 8260864, 8232448, 8335360, 8415232, 8437760, 8422144, /* 6568-6575 */
8342272, 8255744, 8187392, 8144640, 8177408, 8206336, 8175104, 8234496, /* 6576-6583 */
8374784, 8455424, 8508160, 8572672, 8531456, 8376576, 8281856, 8348928, /* 6584-6591 */
8474368, 8541696, 8562432, 8572160, 8515584, 8368384, 8233216, 8227328, /* 6592-6599 */
8293120, 8323072, 8332544, 8410624, 8516096, 8542464, 8492288, 8420864, /* 6600-6607 */
8338176, 8308224, 8320512, 8334336, 8380672, 8433152, 8371456, 8300288, /* 6608-6615 */
8454400, 8684800, 8667392, 8519680, 8488448, 8486400, 8432128, 8406272, /* 6616-6623 */
8409600, 8417536, 8419840, 8360448, 8260608, 8173312, 8130048, 8186624, /* 6624-6631 */
8320000, 8356352, 8212992, 8081664, 8169472, 8342016, 8352768, 8286464, /* 6632-6639 */
8320256, 8401152, 8475904, 8570368, 8619264, 8599552, 8563456, 8496640, /* 6640-6647 */
8401152, 8369152, 8406016, 8411904, 8389120, 8432640, 8513280, 8493056, /* 6648-6655 */
8378624, 8328448, 8345856, 8305664, 8259328, 8353280, 8482560, 8431616, /* 6656-6663 */
8301568, 8297472, 8387840, 8483328, 8598016, 8653056, 8541440, 8399104, /* 6664-6671 */
8388864, 8442880, 8410112, 8248576, 8077056, 8055808, 8175872, 8275456, /* 6672-6679 */
8266752, 8274176, 8385536, 8526592, 8612096, 8624896, 8576256, 8530432, /* 6680-6687 */
8544256, 8542464, 8485632, 8438528, 8400384, 8386048, 8447488, 8466176, /* 6688-6695 */
8358656, 8295424, 8295936, 8273920, 8290560, 8344576, 8307968, 8190464, /* 6696-6703 */
8163072, 8212224, 8201216, 8148224, 8187392, 8313856, 8418560, 8452608, /* 6704-6711 */
8548608, 8707840, 8731648, 8637440, 8628992, 8694528, 8687616, 8612096, /* 6712-6719 */
8545280, 8496128, 8386048, 8233728, 8168960, 8237568, 8279296, 8255744, /* 6720-6727 */
8278784, 8355328, 8427264, 8395520, 8243968, 8177920, 8313600, 8393984, /* 6728-6735 */
8296960, 8243968, 8329216, 8383744, 8348672, 8324608, 8304384, 8262144, /* 6736-6743 */
8266752, 8363264, 8472320, 8455680, 8349184, 8370688, 8499200, 8509440, /* 6744-6751 */
8441344, 8475136, 8583936, 8636928, 8601088, 8557824, 8561664, 8508416, /* 6752-6759 */
8350464, 8241664, 8282880, 8377600, 8392448, 8294400, 8210688, 8272384, /* 6760-6767 */
8393984, 8398848, 8300032, 8238848, 8292352, 8418304, 8436224, 8336640, /* 6768-6775 */
8260608, 8244736, 8341248, 8524544, 8545280, 8380672, 8341504, 8437248, /* 6776-6783 */
8467456, 8434944, 8402432, 8404480, 8460544, 8453376, 8398848, 8425216, /* 6784-6791 */
8447488, 8409600, 8427776, 8495616, 8470784, 8355840, 8299520, 8326656, /* 6792-6799 */
8350464, 8345088, 8346112, 8362240, 8366080, 8317696, 8227840, 8194560, /* 6800-6807 */
8256256, 8344576, 8396288, 8432384, 8494592, 8496128, 8418304, 8466176, /* 6808-6815 */
8596992, 8573696, 8489216, 8491264, 8465408, 8381696, 8319232, 8306944, /* 6816-6823 */
8352768, 8392192, 8379648, 8365056, 8360192, 8360704, 8410624, 8442624, /* 6824-6831 */
8384256, 8357120, 8427008, 8478976, 8428544, 8389120, 8456704, 8507904, /* 6832-6839 */
8455168, 8414976, 8442368, 8418816, 8366336, 8371968, 8402432, 8387328, /* 6840-6847 */
8315392, 8251392, 8261888, 8296192, 8300032, 8298240, 8323328, 8327168, /* 6848-6855 */
8302848, 8288512, 8326400, 8386816, 8411392, 8387328, 8346368, 8353536, /* 6856-6863 */
8367872, 8352256, 8347648, 8384768, 8416512, 8457216, 8521472, 8561664, /* 6864-6871 */
8527872, 8471552, 8441344, 8445952, 8445696, 8407040, 8355072, 8346368, /* 6872-6879 */
8404480, 8475136, 8464384, 8431360, 8479232, 8492288, 8415744, 8392960, /* 6880-6887 */
8420352, 8403456, 8394496, 8372736, 8283136, 8229888, 8227584, 8221696, /* 6888-6895 */
8220416, 8240640, 8278272, 8356608, 8375808, 8265728, 8186624, 8240896, /* 6896-6903 */
8336128, 8427520, 8476928, 8413440, 8353792, 8430592, 8513792, 8516352, /* 6904-6911 */
8555264, 8621824, 8581120, 8489216, 8499712, 8527360, 8427520, 8328704, /* 6912-6919 */
8371456, 8428544, 8378624, 8296448, 8276992, 8325632, 8420352, 8488704, /* 6920-6927 */
8504576, 8476672, 8422400, 8372736, 8398848, 8474368, 8484352, 8400640, /* 6928-6935 */
8351744, 8389632, 8409344, 8360448, 8270336, 8237568, 8318976, 8381952, /* 6936-6943 */
8374784, 8411648, 8470272, 8452608, 8381952, 8295168, 8189952, 8125696, /* 6944-6951 */
8119040, 8156160, 8246784, 8299008, 8317184, 8415232, 8545536, 8589312, /* 6952-6959 */
8588800, 8578304, 8560128, 8603648, 8645632, 8603136, 8552192, 8531712, /* 6960-6967 */
8481024, 8407552, 8351232, 8323840, 8319232, 8284928, 8261120, 8318976, /* 6968-6975 */
8319232, 8238848, 8284160, 8346624, 8252416, 8203264, 8312320, 8428032, /* 6976-6983 */
8424192, 8340736, 8323328, 8435712, 8505856, 8432640, 8328192, 8287744, /* 6984-6991 */
8354560, 8456960, 8463104, 8389888, 8358400, 8388096, 8413696, 8421632, /* 6992-6999 */
8443136, 8447744, 8408832, 8399104, 8416512, 8354560, 8273152, 8317952, /* 7000-7007 */
8455168, 8534016, 8501504, 8469504, 8489216, 8473344, 8400128, 8354560, /* 7008-7015 */
8354560, 8352000, 8341760, 8329216, 8343040, 8373248, 8390144, 8410624, /* 7016-7023 */
8427008, 8411904, 8388096, 8390144, 8412416, 8446976, 8486400, 8500480, /* 7024-7031 */
8436736, 8361728, 8379648, 8397312, 8301824, 8193536, 8184576, 8211456, /* 7032-7039 */
8209408, 8226816, 8268032, 8268800, 8253184, 8283904, 8389376, 8506624, /* 7040-7047 */
8563200, 8556288, 8515584, 8482048, 8484096, 8511488, 8509184, 8466432, /* 7048-7055 */
8419840, 8398592, 8419072, 8463616, 8455424, 8381184, 8321024, 8366336, /* 7056-7063 */
8443904, 8479488, 8483328, 8456448, 8418048, 8385280, 8360704, 8329216, /* 7064-7071 */
8319232, 8313088, 8301312, 8303360, 8344064, 8403200, 8441344, 8435968, /* 7072-7079 */
8421120, 8403712, 8399872, 8402688, 8384512, 8333824, 8285696, 8289280, /* 7080-7087 */
8341248, 8387840, 8392704, 8377856, 8404480, 8436480, 8445440, 8479488, /* 7088-7095 */
8540928, 8595712, 8592896, 8476672, 8324096, 8248320, 8227584, 8186880, /* 7096-7103 */
8183552, 8241152, 8295680, 8322560, 8338944, 8358144, 8406528, 8434944, /* 7104-7111 */
8431616, 8425984, 8421632, 8396032, 8389888, 8432384, 8511232, 8562688, /* 7112-7119 */
8535552, 8478976, 8473344, 8485632, 8471040, 8448000, 8422144, 8390912, /* 7120-7127 */
8363264, 8315904, 8230656, 8163328, 8163840, 8189952, 8234752, 8335616, /* 7128-7135 */
8437504, 8486144, 8471296, 8432896, 8414208, 8422912, 8427776, 8444160, /* 7136-7143 */
8478208, 8461312, 8406016, 8392192, 8406784, 8444416, 8487680, 8464640, /* 7144-7151 */
8391936, 8338944, 8322304, 8316160, 8318720, 8337920, 8356608, 8383488, /* 7152-7159 */
8404736, 8403712, 8370688, 8321024, 8308992, 8344832, 8390144, 8427008, /* 7160-7167 */
8439808, 8393728, 8329472, 8320512, 8345344, 8335104, 8333312, 8356352, /* 7168-7175 */
8375296, 8381440, 8412672, 8481536, 8494848, 8452864, 8456192, 8521984, /* 7176-7183 */
8567296, 8566528, 8555008, 8517888, 8437504, 8361728, 8349952, 8386560, /* 7184-7191 */
8408832, 8370432, 8303616, 8261888, 8248064, 8240896, 8252672, 8298240, /* 7192-7199 */
8339712, 8351744, 8347136, 8353280, 8350208, 8344576, 8362496, 8401408, /* 7200-7207 */
8438528, 8467200, 8494080, 8515584, 8503808, 8470272, 8437248, 8413952, /* 7208-7215 */
8403712, 8397312, 8391424, 8384000, 8386816, 8387840, 8352768, 8307712, /* 7216-7223 */
8304640, 8310272, 8311552, 8323584, 8341504, 8343552, 8316160, 8286208, /* 7224-7231 */
8312064, 8381952, 8430592, 8449536, 8471296, 8516352, 8552960, 8545536, /* 7232-7239 */
8533248, 8530688, 8497408, 8415232, 8333056, 8310016, 8308992, 8290560, /* 7240-7247 */
8278016, 8295936, 8317440, 8337152, 8365056, 8390912, 8402176, 8409344, /* 7248-7255 */
8415488, 8427264, 8460288, 8486144, 8490240, 8477696, 8445952, 8401152, /* 7256-7263 */
8345344, 8318208, 8360192, 8429312, 8417536, 8336896, 8279040, 8275200, /* 7264-7271 */
8296704, 8335616, 8384256, 8400128, 8402176, 8424448, 8436736, 8427776, /* 7272-7279 */
8409600, 8405760, 8424448, 8440832, 8442368, 8448256, 8454144, 8413440, /* 7280-7287 */
8331264, 8259584, 8247040, 8300288, 8379904, 8436224, 8467712, 8479232, /* 7288-7295 */
8456960, 8455424, 8468736, 8431360, 8356096, 8308224, 8302592, 8320256, /* 7296-7303 */
8329984, 8326144, 8318208, 8336640, 8394496, 8482816, 8527872, 8529920, /* 7304-7311 */
8523008, 8504320, 8471808, 8456448, 8450304, 8415744, 8349440, 8270592, /* 7312-7319 */
8212736, 8197632, 8234496, 8290560, 8313600, 8304896, 8304128, 8329728, /* 7320-7327 */
8378368, 8419072, 8444160, 8463872, 8477184, 8483584, 8497408, 8506112, /* 7328-7335 */
8482560, 8428288, 8360960, 8318464, 8329472, 8378368, 8442368, 8479232, /* 7336-7343 */
8472832, 8450304, 8412160, 8355328, 8319232, 8324352, 8344320, 8346624, /* 7344-7351 */
8317696, 8301056, 8335104, 8387072, 8410624, 8418560, 8422400, 8409088, /* 7352-7359 */
8378112, 8357376, 8353024, 8346368, 8357120, 8401408, 8453376, 8475904, /* 7360-7367 */
8470784, 8455680, 8423424, 8388864, 8379136, 8382976, 8369920, 8357120, /* 7368-7375 */
8360704, 8358912, 8348672, 8356096, 8375296, 8394240, 8421632, 8430592, /* 7376-7383 */
8423936, 8417024, 8405504, 8391168, 8396032, 8402432, 8388864, 8366336, /* 7384-7391 */
8357888, 8374016, 8393728, 8397312, 8380928, 8367616, 8370944, 8386816, /* 7392-7399 */
8388608, 8382208, 8362752, 8348160, 8347648, 8353536, 8359424, 8384768, /* 7400-7407 */
8427776, 8464640, 8490496, 8511488, 8525824, 8526080, 8517888, 8484096, /* 7408-7415 */
8431872, 8381696, 8343552, 8305408, 8271104, 8250112, 8264448, 8287488, /* 7416-7423 */
8301056, 8297728, 8300800, 8318720, 8353536, 8391680, 8418816, 8430336, /* 7424-7431 */
8423680, 8390400, 8348416, 8345856, 8385536, 8436480, 8462592, 8458240, /* 7432-7439 */
8445184, 8430848, 8420864, 8415744, 8409856, 8400128, 8402688, 8402432, /* 7440-7447 */
8374016, 8343552, 8335872, 8359680, 8404480, 8449024, 8476672, 8486400, /* 7448-7455 */
8471040, 8435712, 8389888, 8335872, 8301312, 8288000, 8288768, 8309504, /* 7456-7463 */
8341760, 8379136, 8414976, 8438016, 8419840, 8376832, 8342528, 8346112, /* 7464-7471 */
8370176, 8392960, 8418048, 8446208, 8463872, 8459008, 8449792, 8455680, /* 7472-7479 */
8464128, 8455168, 8432128, 8414464, 8406016, 8380672, 8338176, 8304384, /* 7480-7487 */
8303360, 8327168, 8358400, 8373504, 8371456, 8365056, 8362752, 8367872, /* 7488-7495 */
8388608, 8424704, 8459520, 8471808, 8445696, 8397568, 8362240, 8359168, /* 7496-7503 */
8365312, 8353536, 8324352, 8294144, 8278272, 8268288, 8280576, 8322816, /* 7504-7511 */
8392192, 8458496, 8488704, 8481536, 8468992, 8457472, 8449024, 8449792, /* 7512-7519 */
8447232, 8447488, 8457984, 8472576, 8463616, 8436736, 8424704, 8428288, /* 7520-7527 */
8421888, 8404736, 8393728, 8385280, 8359168, 8320768, 8278784, 8255232, /* 7528-7535 */
8255488, 8275456, 8292352, 8315904, 8349184, 8371456, 8375296, 8361216, /* 7536-7543 */
8363776, 8387840, 8428544, 8466688, 8489984, 8496128, 8481536, 8457216, /* 7544-7551 */
8432640, 8417536, 8413952, 8424192, 8429056, 8424704, 8412672, 8403456, /* 7552-7559 */
8399616, 8399104, 8404224, 8385792, 8320512, 8259328, 8248320, 8269568, /* 7560-7567 */
8299008, 8330752, 8357120, 8377088, 8388352, 8380928, 8360448, 8341504, /* 7568-7575 */
8319232, 8313344, 8329984, 8366848, 8396032, 8423936, 8451328, 8479744, /* 7576-7583 */
8510720, 8539648, 8547840, 8527616, 8506368, 8485120, 8450816, 8404480, /* 7584-7591 */
8356352, 8321536, 8314112, 8332800, 8363008, 8383232, 8392448, 8401664, /* 7592-7599 */
8420352, 8447232, 8464128, 8444928, 8393472, 8330240, 8286976, 8276224, /* 7600-7607 */
8284416, 8312320, 8356864, 8393728, 8409088, 8403712, 8381696, 8370688, /* 7608-7615 */
8376320, 8371456, 8353024, 8329216, 8309504, 8315392, 8352256, 8390144, /* 7616-7623 */
8398592, 8398848, 8410624, 8425472, 8441344, 8448512, 8436736, 8412160, /* 7624-7631 */
8420608, 8450048, 8470528, 8469248, 8453376, 8424192, 8392448, 8365824, /* 7632-7639 */
8345600, 8343808, 8353536, 8357888, 8360192, 8371456, 8384000, 8394752, /* 7640-7647 */
8403968, 8415744, 8413184, 8383232, 8358912, 8354560, 8344064, 8305408, /* 7648-7655 */
8276480, 8283648, 8322816, 8377856, 8427520, 8454144, 8469248, 8477952, /* 7656-7663 */
8470272, 8453120, 8448000, 8463360, 8475904, 8468480, 8445440, 8399616, /* 7664-7671 */
8358400, 8352768, 8357632, 8352000, 8340992, 8333312, 8334592, 8349440, /* 7672-7679 */
8373504, 8396800, 8413696, 8426240, 8424448, 8410112, 8387840, 8373248, /* 7680-7687 */
8369664, 8375296, 8378880, 8368128, 8343296, 8340480, 8367872, 8380416, /* 7688-7695 */
8370688, 8359168, 8365568, 8381440, 8393472, 8407552, 8429824, 8455424, /* 7696-7703 */
8476416, 8490240, 8481792, 8443392, 8401920, 8392192, 8419840, 8448512, /* 7704-7711 */
8448256, 8412672, 8359936, 8293888, 8248320, 8236544, 8243968, 8258304, /* 7712-7719 */
8286976, 8328448, 8365312, 8384256, 8396800, 8406784, 8409344, 8405760, /* 7720-7727 */
8408320, 8414464, 8430848, 8461312, 8494080, 8518400, 8529664, 8521472, /* 7728-7735 */
8508160, 8506624, 8497920, 8465664, 8411904, 8363008, 8316672, 8275200, /* 7736-7743 */
8236544, 8203008, 8182528, 8197376, 8232448, 8277248, 8324352, 8359936, /* 7744-7751 */
8368640, 8365056, 8361728, 8372992, 8395520, 8425472, 8458240, 8475136, /* 7752-7759 */
8472832, 8478464, 8497664, 8515584, 8516608, 8499200, 8475904, 8446720, /* 7760-7767 */
8419840, 8393984, 8368896, 8349952, 8348672, 8359680, 8389888, 8429312, /* 7768-7775 */
8442112, 8428544, 8402944, 8380416, 8354048, 8339456, 8334336, 8345600, /* 7776-7783 */
8358656, 8364032, 8356352, 8339456, 8316416, 8297728, 8300800, 8329984, /* 7784-7791 */
8363264, 8386560, 8396032, 8403200, 8424960, 8452352, 8462848, 8448256, /* 7792-7799 */
8427008, 8398848, 8365056, 8346368, 8345088, 8353280, 8365568, 8382720, /* 7800-7807 */
8390400, 8385792, 8389376, 8401920, 8424192, 8450816, 8479744, 8487168, /* 7808-7815 */
8471040, 8449536, 8432128, 8403712, 8375808, 8360960, 8359680, 8377344, /* 7816-7823 */
8400640, 8410624, 8406528, 8394752, 8380416, 8360192, 8348672, 8349184, /* 7824-7831 */
8359936, 8363520, 8364032, 8359680, 8347136, 8327424, 8295424, 8267264, /* 7832-7839 */
8252160, 8250368, 8272640, 8326144, 8380672, 8419328, 8443648, 8475136, /* 7840-7847 */
8511744, 8547072, 8556544, 8559872, 8558592, 8535552, 8484864, 8419072, /* 7848-7855 */
8368640, 8338432, 8326912, 8317696, 8307968, 8301312, 8313856, 8332288, /* 7856-7863 */
8344064, 8346880, 8350208, 8355072, 8355072, 8347392, 8335360, 8336128, /* 7864-7871 */
8347648, 8366592, 8389376, 8415232, 8431104, 8439296, 8445184, 8462336, /* 7872-7879 */
8482560, 8485120, 8461824, 8420864, 8394496, 8397312, 8411904, 8420608, /* 7880-7887 */
8416768, 8401920, 8379904, 8353792, 8337152, 8333056, 8334336, 8343040, /* 7888-7895 */
8359424, 8373248, 8373504, 8372736, 8382464, 8402176, 8418048, 8421632, /* 7896-7903 */
8418816, 8421888, 8431872, 8436224, 8437248, 8428288, 8392960, 8347648, /* 7904-7911 */
8324864, 8322560, 8320768, 8317440, 8327168, 8357632, 8405248, 8447744, /* 7912-7919 */
8470272, 8471040, 8456704, 8457984, 8461056, 8447488, 8415744, 8377344, /* 7920-7927 */
8348672, 8327168, 8304640, 8282112, 8280832, 8302336, 8315136, 8325120, /* 7928-7935 */
8345344, 8374016, 8397312, 8418816, 8431616, 8436480, 8436992, 8434432, /* 7936-7943 */
8416000, 8392704, 8378112, 8382464, 8401408, 8430080, 8449792, 8447744, /* 7944-7951 */
8432896, 8421376, 8402688, 8393216, 8391936, 8396800, 8388096, 8354048, /* 7952-7959 */
8304640, 8286464, 8302592, 8329472, 8351744, 8379136, 8401664, 8419584, /* 7960-7967 */
8418304, 8398080, 8369152, 8346112, 8341760, 8357376, 8371456, 8365312, /* 7968-7975 */
8349184, 8356608, 8377088, 8402432, 8432128, 8468480, 8489472, 8484608, /* 7976-7983 */
8474880, 8462848, 8457728, 8449280, 8426496, 8397056, 8378368, 8375040, /* 7984-7991 */
8371456, 8364800, 8363776, 8376064, 8396544, 8415744, 8417536, 8388096, /* 7992-7999 */
8337152, 8294144, 8277504, 8287232, 8307712, 8330752, 8356608, 8382208, /* 8000-8007 */
8410112, 8429312, 8432896, 8432384, 8443904, 8453888, 8454912, 8437504, /* 8008-8015 */
8406528, 8369152, 8345344, 8343808, 8352000, 8369920, 8390400, 8403968, /* 8016-8023 */
8415232, 8431104, 8446976, 8440832, 8421120, 8403968, 8387328, 8377856, /* 8024-8031 */
8361472, 8342016, 8332800, 8338432, 8347648, 8365824, 8378112, 8389120, /* 8032-8039 */
8391168, 8398592, 8418560, 8445696, 8457728, 8442112, 8392192, 8332032, /* 8040-8047 */
8297728, 8293632, 8321024, 8366080, 8399872, 8417536, 8422912, 8414208, /* 8048-8055 */
8395776, 8382976, 8388864, 8407040, 8423424, 8418560, 8407040, 8389632, /* 8056-8063 */
8374528, 8372992, 8396544, 8422656, 8428544, 8424192, 8412928, 8395776, /* 8064-8071 */
8361472, 8323328, 8312064, 8334592, 8363520, 8394496, 8435456, 8474112, /* 8072-8079 */
8480768, 8459264, 8413184, 8366848, 8344576, 8352768, 8373504, 8389632, /* 8080-8087 */
8401152, 8405248, 8398080, 8380672, 8359168, 8352256, 8347392, 8343552, /* 8088-8095 */
8330752, 8324096, 8321792, 8330752, 8346368, 8360704, 8380672, 8417024, /* 8096-8103 */
8456192, 8473600, 8480000, 8474624, 8448256, 8424960, 8439040, 8464640, /* 8104-8111 */
8474624, 8469760, 8460544, 8437760, 8394496, 8354048, 8327936, 8305664, /* 8112-8119 */
8292352, 8281856, 8271616, 8285184, 8318208, 8357888, 8382464, 8394752, /* 8120-8127 */
8388096, 8380672, 8385024, 8410112, 8442112, 8457472, 8449792, 8448000, /* 8128-8135 */
8450560, 8440320, 8425728, 8424448, 8427520, 8421376, 8396800, 8368896, /* 8136-8143 */
8348672, 8340480, 8316672, 8293888, 8284928, 8287744, 8303616, 8343040, /* 8144-8151 */
8393216, 8434688, 8452096, 8459264, 8449024, 8414208, 8368640, 8340480, /* 8152-8159 */
8340480, 8349440, 8379904, 8423680, 8464640, 8491264, 8499200, 8501760, /* 8160-8167 */
8489728, 8449536, 8393472, 8361472, 8354816, 8337152, 8305408, 8283136, /* 8168-8175 */
8274688, 8288000, 8319744, 8350976, 8368128, 8371200, 8370176, 8369664, /* 8176-8183 */
8364800, 8360448, 8360192, 8363264, 8372224, 8386304, 8410880, 8438272, /* 8184-8191 */
8476416, 8510976, 8521216, 8499712, 8473088, 8454144, 8437504, 8420608, /* 8192-8199 */
8410624, 8402688, 8397568, 8397056, 8396544, 8380416, 8350720, 8323584, /* 8200-8207 */
8309504, 8303616, 8302336, 8306688, 8321024, 8342016, 8359424, 8372992, /* 8208-8215 */
8386048, 8396544, 8388608, 8369664, 8355584, 8361984, 8382464, 8409856, /* 8216-8223 */
8443136, 8468480, 8475136, 8477952, 8475648, 8468992, 8453376, 8419072, /* 8224-8231 */
8376576, 8348416, 8334080, 8332032, 8335872, 8352512, 8358400, 8358656, /* 8232-8239 */
8365312, 8387072, 8411136, 8428288, 8436736, 8431616, 8408320, 8383744, /* 8240-8247 */
8367616, 8361472, 8362496, 8348928, 8336128, 8334848, 8354816, 8380160, /* 8248-8255 */
8406784, 8413184, 8400384, 8383488, 8380160, 8380928, 8371712, 8349952, /* 8256-8263 */
8335104, 8339712, 8355072, 8358144, 8351232, 8348928, 8357888, 8386816, /* 8264-8271 */
8425984, 8457472, 8473088, 8487424, 8493568, 8496640, 8487680, 8472576, /* 8272-8279 */
8451328, 8430080, 8412672, 8393472, 8373248, 8361728, 8357120, 8366592, /* 8280-8287 */
8377600, 8376064, 8360960, 8345344, 8332800, 8329728, 8335872, 8354304, /* 8288-8295 */
8374272, 8384256, 8379648, 8369408, 8360192, 8352512, 8350464, 8360960, /* 8296-8303 */
8374784, 8381184, 8372992, 8368640, 8377856, 8388352, 8383488, 8393728, /* 8304-8311 */
8421120, 8452352, 8464640, 8462080, 8460288, 8461824, 8449536, 8426240, /* 8312-8319 */
8387072, 8354048, 8348416, 8374784, 8406016, 8429568, 8429568, 8405504, /* 8320-8327 */
8369152, 8347136, 8342528, 8345088, 8331264, 8297728, 8275968, 8289792, /* 8328-8335 */
8325376, 8359168, 8382720, 8391936, 8398080, 8404992, 8422400, 8437760, /* 8336-8343 */
8456192, 8474368, 8493568, 8493824, 8485632, 8460544, 8429056, 8389632, /* 8344-8351 */
8366592, 8363008, 8371200, 8363264, 8346112, 8332288, 8319488, 8310272, /* 8352-8359 */
8313600, 8334336, 8357888, 8379136, 8402432, 8408576, 8398848, 8395520, /* 8360-8367 */
8410880, 8422656, 8428032, 8420864, 8408576, 8376576, 8338176, 8307968, /* 8368-8375 */
8302848, 8323584, 8354560, 8395008, 8428800, 8454400, 8471040, 8480512, /* 8376-8383 */
8474112, 8462080, 8430080, 8380160, 8337408, 8327936, 8347136, 8373248, /* 8384-8391 */
8389120, 8394496, 8387072, 8376832, 8361984, 8366336, 8396288, 8425472, /* 8392-8399 */
8422400, 8390400, 8352512, 8323072, 8322816, 8344320, 8381184, 8412928, /* 8400-8407 */
8425984, 8416512, 8396800, 8385280, 8373760, 8367104, 8378880, 8400128, /* 8408-8415 */
8415488, 8427264, 8436992, 8451072, 8456448, 8438784, 8401664, 8367104, /* 8416-8423 */
8350976, 8339968, 8331520, 8328192, 8328192, 8329728, 8340736, 8352256, /* 8424-8431 */
8366080, 8387584, 8415744, 8453120, 8485888, 8485632, 8451584, 8422144, /* 8432-8439 */
8397568, 8376064, 8349952, 8338432, 8345088, 8361984, 8385536, 8397824, /* 8440-8447 */
8395264, 8384512, 8388352, 8411392, 8431360, 8427776, 8409856, 8393728, /* 8448-8455 */
8372992, 8360448, 8355840, 8363264, 8380672, 8403712, 8422144, 8432384, /* 8456-8463 */
8423168, 8401152, 8369664, 8331520, 8302592, 8294656, 8307456, 8332800, /* 8464-8471 */
8369152, 8405760, 8428288, 8435200, 8434176, 8427264, 8410880, 8397312, /* 8472-8479 */
8391424, 8386560, 8376320, 8383488, 8396032, 8401408, 8401920, 8408064, /* 8480-8487 */
8416768, 8419072, 8425216, 8420864, 8409856, 8404736, 8405504, 8397056, /* 8488-8495 */
8375040, 8346624, 8328448, 8333824, 8348416, 8360448, 8376320, 8395008, /* 8496-8503 */
8404992, 8405504, 8411904, 8427264, 8430848, 8424448, 8422400, 8421376, /* 8504-8511 */
8413696, 8391424, 8358656, 8329984, 8318464, 8317184, 8316416, 8318464, /* 8512-8519 */
8327424, 8346880, 8365056, 8380160, 8395776, 8410112, 8422912, 8440576, /* 8520-8527 */
8460032, 8483328, 8501248, 8505088, 8502016, 8491776, 8474112, 8451328, /* 8528-8535 */
8417280, 8379136, 8333056, 8296704, 8272896, 8262400, 8260352, 8269824, /* 8536-8543 */
8284416, 8295680, 8312576, 8347136, 8363776, 8361216, 8362240, 8375040, /* 8544-8551 */
8390144, 8403968, 8419840, 8426240, 8427264, 8423424, 8420608, 8418560, /* 8552-8559 */
8424192, 8428032, 8441856, 8458496, 8470528, 8465920, 8458240, 8458752, /* 8560-8567 */
8463360, 8460544, 8443904, 8414464, 8382464, 8350976, 8318976, 8305664, /* 8568-8575 */
8314624, 8325888, 8327680, 8336384, 8346624, 8355584, 8368384, 8395776, /* 8576-8583 */
8418304, 8414976, 8389632, 8363264, 8348928, 8345088, 8342016, 8341760, /* 8584-8591 */
8343296, 8349952, 8367616, 8395264, 8423936, 8432640, 8437760, 8438272, /* 8592-8599 */
8431360, 8402432, 8372224, 8349696, 8344832, 8357376, 8386048, 8416000, /* 8600-8607 */
8450048, 8483328, 8504064, 8500224, 8484608, 8467456, 8448768, 8413696, /* 8608-8615 */
8378624, 8354560, 8337920, 8326144, 8320768, 8317440, 8313088, 8322816, /* 8616-8623 */
8337408, 8355840, 8358144, 8352768, 8340736, 8334592, 8337408, 8348672, /* 8624-8631 */
8365056, 8391680, 8412672, 8417024, 8408320, 8390912, 8374784, 8369408, /* 8632-8639 */
8380928, 8399360, 8410624, 8420864, 8431872, 8434944, 8425472, 8417024, /* 8640-8647 */
8408320, 8400128, 8400640, 8417792, 8440320, 8454656, 8456960, 8450560, /* 8648-8655 */
8437504, 8426752, 8404224, 8376320, 8347136, 8334336, 8335360, 8349952, /* 8656-8663 */
8375808, 8395264, 8391936, 8376320, 8360704, 8350464, 8335360, 8323072, /* 8664-8671 */
8314112, 8312320, 8312832, 8313344, 8320768, 8334336, 8357632, 8386816, /* 8672-8679 */
8417024, 8455936, 8500736, 8526592, 8531200, 8512768, 8478208, 8431104, /* 8680-8687 */
8387840, 8358656, 8340736, 8343040, 8354816, 8364288, 8364288, 8352000, /* 8688-8695 */
8341504, 8339712, 8349696, 8363520, 8372992, 8387840, 8408320, 8421120, /* 8696-8703 */
8422400, 8425216, 8417280, 8403456, 8391424, 8383488, 8374784, 8374784, /* 8704-8711 */
8371200, 8362240, 8363264, 8397568, 8438784, 8467968, 8484608, 8477952, /* 8712-8719 */
8460800, 8436992, 8413696, 8373760, 8333568, 8307712, 8295680, 8286208, /* 8720-8727 */
8290048, 8305152, 8319232, 8332288, 8353280, 8372224, 8389376, 8398336, /* 8728-8735 */
8410880, 8429056, 8442112, 8447232, 8453632, 8453888, 8445184, 8431104, /* 8736-8743 */
8417536, 8397568, 8381440, 8375808, 8375552, 8373504, 8362752, 8345344, /* 8744-8751 */
8337152, 8342784, 8361472, 8389376, 8405760, 8415232, 8421376, 8422656, /* 8752-8759 */
8404992, 8370944, 8350464, 8351744, 8374272, 8406272, 8427264, 8416256, /* 8760-8767 */
8389888, 8372992, 8373760, 8374528, 8371200, 8374016, 8387072, 8406528, /* 8768-8775 */
8412672, 8410880, 8405760, 8396032, 8388096, 8393728, 8394752, 8387840, /* 8776-8783 */
8376832, 8372480, 8372736, 8373504, 8372992, 8377856, 8385280, 8390400, /* 8784-8791 */
8392192, 8387072, 8381184, 8378368, 8382464, 8387072, 8390144, 8395264, /* 8792-8799 */
8400896, 8405504, 8409600, 8414208, 8408576, 8394752, 8373760, 8357632, /* 8800-8807 */
8344832, 8342528, 8356352, 8381696, 8416256, 8444928, 8463360, 8467200, /* 8808-8815 */
8451584, 8417280, 8380672, 8356608, 8342016, 8342016, 8347904, 8357376, /* 8816-8823 */
8375296, 8393728, 8409088, 8409600, 8403200, 8401152, 8386304, 8365056, /* 8824-8831 */
8346368, 8337920, 8334080, 8341248, 8352768, 8364032, 8377856, 8397056, /* 8832-8839 */
8419840, 8435968, 8436480, 8435712, 8437760, 8437760, 8423936, 8408064, /* 8840-8847 */
8390656, 8377600, 8385024, 8397312, 8396288, 8379648, 8367360, 8368384, /* 8848-8855 */
8370944, 8376064, 8378368, 8377856, 8374528, 8370688, 8367360, 8360192, /* 8856-8863 */
8356352, 8357632, 8361216, 8368384, 8387328, 8402688, 8402688, 8394240, /* 8864-8871 */
8390400, 8388608, 8394752, 8399360, 8406016, 8413440, 8419072, 8420096, /* 8872-8879 */
8430848, 8443904, 8463616, 8456960, 8421888, 8382976, 8361984, 8351488, /* 8880-8887 */
8345088, 8334848, 8313600, 8295168, 8297472, 8327936, 8359680, 8380672, /* 8888-8895 */
8407040, 8428032, 8442624, 8451840, 8459008, 8459264, 8451584, 8430080, /* 8896-8903 */
8394240, 8366592, 8365056, 8374016, 8393728, 8397824, 8392448, 8388096, /* 8904-8911 */
8395008, 8395264, 8382976, 8365824, 8349696, 8335104, 8327936, 8330496, /* 8912-8919 */
8331264, 8330752, 8334592, 8346624, 8365568, 8386816, 8404224, 8423680, /* 8920-8927 */
8444672, 8466688, 8488960, 8494592, 8483584, 8458496, 8430080, 8407552, /* 8928-8935 */
8390912, 8377088, 8360192, 8346368, 8332800, 8314880, 8306944, 8314624, /* 8936-8943 */
8340224, 8377344, 8414208, 8431872, 8421888, 8408320, 8408320, 8416768, /* 8944-8951 */
8417792, 8406016, 8389632, 8378880, 8385280, 8393728, 8387840, 8367616, /* 8952-8959 */
8355072, 8362240, 8377600, 8388096, 8387072, 8368384, 8347904, 8348416, /* 8960-8967 */
8365568, 8385280, 8402176, 8420096, 8424704, 8422912, 8416512, 8408064, /* 8968-8975 */
8395008, 8380416, 8369408, 8369664, 8379648, 8397824, 8413440, 8419584, /* 8976-8983 */
8423168, 8425216, 8426752, 8423424, 8414464, 8400896, 8379904, 8357888, /* 8984-8991 */
8346880, 8345344, 8342784, 8335104, 8330240, 8329472, 8322816, 8324096, /* 8992-8999 */
8337408, 8364800, 8397568, 8425216, 8448000, 8462336, 8466944, 8460288, /* 9000-9007 */
8452864, 8445696, 8432896, 8425728, 8420352, 8407296, 8385792, 8365568, /* 9008-9015 */
8346880, 8335360, 8345088, 8358912, 8371200, 8376576, 8367616, 8351232, /* 9016-9023 */
8334592, 8320512, 8315392, 8331264, 8356352, 8385536, 8417280, 8450816, /* 9024-9031 */
8473344, 8488960, 8473856, 8444928, 8405248, 8378112, 8369152, 8375040, /* 9032-9039 */
8385792, 8402688, 8405504, 8394240, 8370432, 8346880, 8327168, 8316672, /* 9040-9047 */
8319744, 8337920, 8367104, 8400128, 8424704, 8441600, 8451072, 8448512, /* 9048-9055 */
8443904, 8437760, 8429824, 8422912, 8420096, 8417792, 8406272, 8387072, /* 9056-9063 */
8365824, 8356352, 8353536, 8347904, 8334848, 8320000, 8304128, 8299264, /* 9064-9071 */
8297984, 8307712, 8326656, 8347648, 8376576, 8409344, 8436480, 8448000, /* 9072-9079 */
8457216, 8459520, 8460288, 8453376, 8447488, 8448512, 8457472, 8459008, /* 9080-9087 */
8442624, 8413184, 8384768, 8373248, 8379648, 8392448, 8395264, 8386816, /* 9088-9095 */
8370432, 8359680, 8352000, 8348160, 8336896, 8327168, 8321024, 8328448, /* 9096-9103 */
8337408, 8349696, 8357888, 8366592, 8374528, 8384768, 8399616, 8413440, /* 9104-9111 */
8422912, 8430336, 8426240, 8413696, 8392704, 8377600, 8371200, 8371968, /* 9112-9119 */
8379904, 8385024, 8390656, 8395008, 8404736, 8411904, 8412672, 8408320, /* 9120-9127 */
8402688, 8397056, 8402176, 8409600, 8414208, 8408576, 8404480, 8409344, /* 9128-9135 */
8414976, 8414464, 8404224, 8389632, 8365312, 8346880, 8344320, 8350720, /* 9136-9143 */
8352768, 8358656, 8369920, 8376320, 8376832, 8383488, 8402176, 8420864, /* 9144-9151 */
8427520, 8421888, 8415232, 8407040, 8397824, 8383744, 8365824, 8345600, /* 9152-9159 */
8336128, 8349696, 8363264, 8358400, 8341760, 8337152, 8351488, 8386304, /* 9160-9167 */
8411392, 8418048, 8411648, 8405248, 8412416, 8424960, 8433664, 8429568, /* 9168-9175 */
8413184, 8393984, 8382208, 8381184, 8387840, 8397312, 8413696, 8427008, /* 9176-9183 */
8424192, 8412160, 8395264, 8380416, 8372480, 8368896, 8368384, 8378624, /* 9184-9191 */
8397568, 8416768, 8424192, 8422400, 8410368, 8397056, 8396032, 8394240, /* 9192-9199 */
8382464, 8352512, 8329216, 8313856, 8304640, 8304384, 8320256, 8340736, /* 9200-9207 */
8355328, 8371712, 8390400, 8404736, 8412672, 8413952, 8410368, 8402176, /* 9208-9215 */
8393984, 8394496, 8402944, 8408064, 8406528, 8407040, 8416768, 8434688, /* 9216-9223 */
8445952, 8445696, 8439808, 8433408, 8413440, 8385024, 8364800, 8353280, /* 9224-9231 */
8340224, 8329984, 8336896, 8359168, 8382464, 8403712, 8422656, 8430848, /* 9232-9239 */
8427008, 8416512, 8408064, 8399616, 8391168, 8379392, 8372224, 8376064, /* 9240-9247 */
8382208, 8380928, 8363520, 8339712, 8317184, 8314368, 8337920, 8376576, /* 9248-9255 */
8407296, 8423936, 8428032, 8413696, 8390144, 8360448, 8337664, 8328448, /* 9256-9263 */
8332800, 8353792, 8377088, 8400640, 8425728, 8451584, 8476672, 8492032, /* 9264-9271 */
8492544, 8478464, 8453120, 8421888, 8396032, 8380928, 8372992, 8368640, /* 9272-9279 */
8363520, 8359936, 8359936, 8364544, 8362752, 8350720, 8338688, 8327680, /* 9280-9287 */
8320512, 8317440, 8319232, 8332032, 8351744, 8366592, 8380672, 8398080, /* 9288-9295 */
8420608, 8442624, 8456448, 8462080, 8454144, 8452864, 8455936, 8456192, /* 9296-9303 */
8433920, 8400128, 8375552, 8368640, 8367616, 8364288, 8360448, 8360448, /* 9304-9311 */
8364544, 8371200, 8368384, 8358656, 8353536, 8358912, 8370688, 8386048, /* 9312-9319 */
8389376, 8396288, 8400128, 8398592, 8390912, 8396032, 8398592, 8391680, /* 9320-9327 */
8383744, 8386816, 8398848, 8413440, 8420608, 8422656, 8417024, 8409856, /* 9328-9335 */
8401664, 8396544, 8395264, 8395520, 8390400, 8380928, 8367360, 8360960, /* 9336-9343 */
8363264, 8368128, 8368384, 8359680, 8348928, 8348416, 8368128, 8387328, /* 9344-9351 */
8396800, 8391936, 8387328, 8386560, 8388864, 8394240, 8397824, 8406528, /* 9352-9359 */
8410112, 8412416, 8420096, 8427264, 8422400, 8410112, 8398336, 8387328, /* 9360-9367 */
8386560, 8381184, 8374784, 8363008, 8355328, 8350720, 8351232, 8348672, /* 9368-9375 */
8345344, 8355328, 8377344, 8402432, 8419072, 8424960, 8434176, 8444416, /* 9376-9383 */
8442112, 8419328, 8392448, 8375552, 8381440, 8392704, 8392960, 8382720, /* 9384-9391 */
8376320, 8371456, 8372480, 8370688, 8370432, 8377856, 8389376, 8402432, /* 9392-9399 */
8399360, 8385280, 8374272, 8375040, 8376576, 8369920, 8360192, 8359936, /* 9400-9407 */
8365824, 8370944, 8374784, 8380416, 8391680, 8405504, 8425216, 8442368, /* 9408-9415 */
8454912, 8454656, 8447744, 8427776, 8403456, 8381696, 8361728, 8350208, /* 9416-9423 */
8342528, 8339456, 8340224, 8348928, 8366848, 8393472, 8414464, 8419328, /* 9424-9431 */
8408320, 8388352, 8378112, 8386048, 8397568, 8401152, 8397056, 8391936, /* 9432-9439 */
8388864, 8383744, 8377088, 8368384, 8358912, 8355584, 8355584, 8368896, /* 9440-9447 */
8386560, 8406016, 8412672, 8417024, 8417792, 8420608, 8421376, 8417280, /* 9448-9455 */
8407808, 8392192, 8377600, 8365824, 8356608, 8351232, 8354048, 8362496, /* 9456-9463 */
8378624, 8401920, 8421376, 8427776, 8427008, 8427008, 8425216, 8417024, /* 9464-9471 */
8410368, 8393216, 8371200, 8345600, 8330240, 8326912, 8334848, 8344320, /* 9472-9479 */
8358400, 8373248, 8385280, 8398848, 8412160, 8417536, 8416768, 8417280, /* 9480-9487 */
8416000, 8406016, 8388352, 8382464, 8377344, 8372992, 8367360, 8364544, /* 9488-9495 */
8363776, 8364032, 8368640, 8372224, 8379392, 8394240, 8416000, 8429056, /* 9496-9503 */
8424960, 8413952, 8411136, 8424448, 8443392, 8450304, 8448256, 8446720, /* 9504-9511 */
8438528, 8413440, 8386816, 8369408, 8360960, 8339456, 8310528, 8284160, /* 9512-9519 */
8281600, 8297984, 8326400, 8353280, 8379904, 8401664, 8420864, 8429056, /* 9520-9527 */
8434432, 8437504, 8436736, 8423424, 8396800, 8366592, 8343808, 8336640, /* 9528-9535 */
8345600, 8355584, 8367872, 8382976, 8402944, 8418304, 8420864, 8420608, /* 9536-9543 */
8419840, 8421376, 8418304, 8410880, 8410368, 8416512, 8417792, 8413440, /* 9544-9551 */
8403200, 8395264, 8385280, 8377856, 8363008, 8339968, 8325120, 8330240, /* 9552-9559 */
8350720, 8369152, 8379392, 8385536, 8391936, 8394240, 8392704, 8396800, /* 9560-9567 */
8415488, 8429568, 8425472, 8405248, 8384256, 8375296, 8383232, 8393472, /* 9568-9575 */
8399360, 8399360, 8399104, 8393472, 8383744, 8365056, 8344832, 8339200, /* 9576-9583 */
8348672, 8357120, 8363776, 8382464, 8407040, 8428288, 8438272, 8433152, /* 9584-9591 */
8420864, 8409344, 8402432, 8400128, 8400896, 8399360, 8388864, 8381440, /* 9592-9599 */
8377088, 8375040, 8378880, 8393216, 8410112, 8415232, 8402176, 8380160, /* 9600-9607 */
8360704, 8345856, 8339200, 8342528, 8354048, 8365312, 8375552, 8383488, /* 9608-9615 */
8397824, 8411648, 8421376, 8428800, 8426752, 8420096, 8409856, 8407296, /* 9616-9623 */
8407296, 8402432, 8390400, 8369152, 8355328, 8345600, 8343552, 8346880, /* 9624-9631 */
8357632, 8373504, 8391168, 8410880, 8423936, 8425472, 8411648, 8391168, /* 9632-9639 */
8372480, 8366592, 8374272, 8387840, 8407552, 8418816, 8422144, 8415744, /* 9640-9647 */
8412160, 8413952, 8405248, 8396544, 8384512, 8370432, 8351744, 8335104, /* 9648-9655 */
8325120, 8322560, 8332800, 8347392, 8360192, 8377088, 8400896, 8421888, /* 9656-9663 */
8437760, 8442112, 8437504, 8424704, 8409856, 8396800, 8381696, 8376064, /* 9664-9671 */
8372736, 8383744, 8399872, 8419584, 8435712, 8448000, 8447744, 8438528, /* 9672-9679 */
8421120, 8403968, 8382720, 8361984, 8347136, 8340480, 8339968, 8340480, /* 9680-9687 */
8338432, 8334080, 8334592, 8340736, 8346368, 8345600, 8349696, 8359424, /* 9688-9695 */
8371200, 8385792, 8399616, 8411904, 8421888, 8427776, 8430336, 8422912, /* 9696-9703 */
8413696, 8404224, 8404736, 8407296, 8412160, 8411904, 8410368, 8416768, /* 9704-9711 */
8428800, 8438528, 8439296, 8439552, 8436992, 8424192, 8410880, 8395008, /* 9712-9719 */
8380160, 8360960, 8338688, 8316928, 8305664, 8302080, 8303872, 8309760, /* 9720-9727 */
8314368, 8325120, 8342272, 8358400, 8373760, 8396032, 8420352, 8437760, /* 9728-9735 */
8446208, 8450048, 8450304, 8439808, 8421888, 8403968, 8390912, 8391424, /* 9736-9743 */
8395520, 8398336, 8391424, 8388608, 8389120, 8390400, 8389632, 8391680, /* 9744-9751 */
8391680, 8394496, 8394240, 8392192, 8384256, 8375296, 8371456, 8375552, /* 9752-9759 */
8391424, 8405248, 8408064, 8403968, 8404480, 8415744, 8421888, 8417280, /* 9760-9767 */
8399616, 8384768, 8370944, 8354304, 8342272, 8334336, 8335872, 8350720, /* 9768-9775 */
8368384, 8382208, 8379648, 8370944, 8367616, 8367872, 8370176, 8369664, /* 9776-9783 */
8376832, 8391168, 8403200, 8406528, 8397568, 8390400, 8388352, 8396288, /* 9784-9791 */
8403712, 8411904, 8423680, 8436736, 8444928, 8441600, 8424960, 8408832, /* 9792-9799 */
8389632, 8376832, 8369408, 8362752, 8355584, 8360448, 8382208, 8405504, /* 9800-9807 */
8423168, 8429312, 8427008, 8415232, 8398848, 8381184, 8366080, 8352000, /* 9808-9815 */
8345344, 8349952, 8358400, 8367360, 8375808, 8377856, 8373760, 8379648, /* 9816-9823 */
8392448, 8402688, 8402176, 8396288, 8386304, 8378624, 8370432, 8370432, /* 9824-9831 */
8378880, 8396288, 8412160, 8416768, 8404992, 8386816, 8375040, 8372224, /* 9832-9839 */
8374016, 8369920, 8365056, 8365312, 8377344, 8397312, 8409344, 8410112, /* 9840-9847 */
8402944, 8397568, 8400384, 8403712, 8411136, 8413440, 8411904, 8408064, /* 9848-9855 */
8406272, 8407040, 8401664, 8395520, 8391680, 8390400, 8390400, 8382464, /* 9856-9863 */
8372736, 8361728, 8354816, 8355072, 8356864, 8367360, 8372480, 8377344, /* 9864-9871 */
8383232, 8389376, 8393472, 8392960, 8394240, 8398080, 8402944, 8408832, /* 9872-9879 */
8408832, 8408064, 8407808, 8399616, 8386304, 8371456, 8365312, 8372224, /* 9880-9887 */
8380928, 8389888, 8385792, 8384768, 8388096, 8387584, 8380416, 8371456, /* 9888-9895 */
8365824, 8369664, 8381952, 8384256, 8385280, 8386304, 8391680, 8398336, /* 9896-9903 */
8409856, 8420096, 8427008, 8429824, 8429056, 8418816, 8401152, 8380416, /* 9904-9911 */
8363008, 8350464, 8350208, 8355584, 8371200, 8380928, 8387584, 8388352, /* 9912-9919 */
8388352, 8392960, 8396800, 8399616, 8396800, 8398848, 8399872, 8401408, /* 9920-9927 */
8392448, 8385280, 8381184, 8385024, 8393472, 8402432, 8400128, 8393216, /* 9928-9935 */
8386560, 8382208, 8374784, 8365568, 8370432, 8378624, 8379392, 8376832, /* 9936-9943 */
8378112, 8386048, 8392192, 8388608, 8380928, 8375296, 8376576, 8384000, /* 9944-9951 */
8397568, 8404224, 8400640, 8394752, 8392448, 8397312, 8397824, 8398336, /* 9952-9959 */
8399872, 8403200, 8401152, 8398848, 8401920, 8411136, 8411136, 8406016, /* 9960-9967 */
8392960, 8384768, 8381952, 8377856, 8370688, 8366848, 8375808, 8389888, /* 9968-9975 */
8398336, 8393728, 8379648, 8366080, 8359424, 8355584, 8354816, 8358656, /* 9976-9983 */
8359424, 8363520, 8375040, 8392704, 8407808, 8409600, 8401152, 8392704, /* 9984-9991 */
8388096, 8391936, 8397568, 8411904, 8427520, 8443392, 8452608, 8453120, /* 9992-9999 */
8445696, 8425728, 8406528, 8383744, 8365056, 8351488, 8340736, 8330496, /* 10000-10007 */
8321536, 8321280, 8331520, 8346880, 8365056, 8381184, 8396032, 8404224, /* 10008-10015 */
8405504, 8410112, 8416768, 8422144, 8418560, 8408576, 8398848, 8392704, /* 10016-10023 */
8381952, 8379648, 8383744, 8385792, 8384512, 8388608, 8394240, 8399616, /* 10024-10031 */
8397568, 8389632, 8385280, 8381952, 8380928, 8381184, 8384768, 8388608, /* 10032-10039 */
8386304, 8381696, 8377344, 8380416, 8381696, 8380160, 8379904, 8389376, /* 10040-10047 */
8398592, 8400384, 8397056, 8398592, 8406272, 8415744, 8417280, 8413952, /* 10048-10055 */
8407040, 8396288, 8378880, 8366592, 8362496, 8360960, 8358144, 8357888, /* 10056-10063 */
8359424, 8370688, 8386816, 8405504, 8412672, 8412160, 8402176, 8392960, /* 10064-10071 */
8387840, 8389120, 8390400, 8390144, 8385792, 8381440, 8381440, 8386048, /* 10072-10079 */
8385792, 8384256, 8385024, 8399104, 8415232, 8425728, 8423424, 8415744, /* 10080-10087 */
8398848, 8379648, 8366592, 8366080, 8375552, 8387584, 8396288, 8395520, /* 10088-10095 */
8386560, 8375040, 8366848, 8357376, 8344064, 8336384, 8337920, 8343552, /* 10096-10103 */
8352000, 8368128, 8391424, 8415488, 8436992, 8452608, 8454912, 8448512, /* 10104-10111 */
8438528, 8430592, 8426240, 8421376, 8412160, 8399872, 8381952, 8362496, /* 10112-10119 */
8340224, 8325632, 8321792, 8323840, 8332800, 8354560, 8382720, 8403712, /* 10120-10127 */
8420096, 8435200, 8448768, 8456448, 8454912, 8440832, 8414720, 8382464, /* 10128-10135 */
8360704, 8348416, 8346880, 8350464, 8353024, 8354560, 8356864, 8366592, /* 10136-10143 */
8379392, 8391680, 8396800, 8395264, 8386048, 8375552, 8371456, 8375552, /* 10144-10151 */
8378112, 8382720, 8390400, 8402688, 8409856, 8413696, 8407552, 8389120, /* 10152-10159 */
8373248, 8367872, 8370176, 8383744, 8396032, 8401664, 8411136, 8425728, /* 10160-10167 */
8437760, 8437248, 8415744, 8392960, 8373248, 8368128, 8374528, 8384512, /* 10168-10175 */
8385792, 8376576, 8371712, 8376064, 8387072, 8399360, 8410112, 8419072, /* 10176-10183 */
8413696, 8404480, 8393728, 8385536, 8379904, 8378368, 8375296, 8368384, /* 10184-10191 */
8364544, 8360448, 8354816, 8350464, 8351488, 8359424, 8376576, 8390656, /* 10192-10199 */
8401664, 8410112, 8419840, 8432128, 8439552, 8436992, 8428800, 8412672, /* 10200-10207 */
8384512, 8354560, 8338688, 8333568, 8335104, 8342784, 8349440, 8361728, /* 10208-10215 */
8375296, 8392448, 8403200, 8409088, 8405504, 8405248, 8409856, 8414976, /* 10216-10223 */
8414464, 8409088, 8400896, 8399872, 8402688, 8404736, 8406528, 8405504, /* 10224-10231 */
8404224, 8400896, 8397056, 8392448, 8395008, 8400896, 8400128, 8392704, /* 10232-10239 */
8385536, 8382464, 8377600, 8362240, 8345088, 8336640, 8336128, 8346368, /* 10240-10247 */
8363264, 8381184, 8400640, 8416000, 8421632, 8419328, 8415488, 8409344, /* 10248-10255 */
8399616, 8386560, 8380416, 8373760, 8364032, 8356864, 8356352, 8367104, /* 10256-10263 */
8381184, 8391680, 8396544, 8396288, 8394240, 8394752, 8392704, 8388864, /* 10264-10271 */
8378112, 8371456, 8380672, 8399360, 8416256, 8417024, 8417536, 8411392, /* 10272-10279 */
8408832, 8400896, 8396032, 8399360, 8411904, 8421888, 8427008, 8424704, /* 10280-10287 */
8414208, 8402432, 8387584, 8374784, 8361216, 8357632, 8353792, 8349440, /* 10288-10295 */
8347136, 8348672, 8350208, 8352768, 8358912, 8368384, 8375808, 8376064, /* 10296-10303 */
8372992, 8369152, 8364032, 8361216, 8370432, 8384768, 8404480, 8421120, /* 10304-10311 */
8438528, 8441088, 8439296, 8437760, 8433152, 8419328, 8407552, 8392192, /* 10312-10319 */
8381440, 8372224, 8367616, 8370688, 8376320, 8388864, 8393472, 8390400, /* 10320-10327 */
8383744, 8383232, 8390400, 8395264, 8398336, 8387840, 8380416, 8373504, /* 10328-10335 */
8374272, 8384256, 8391936, 8397568, 8394240, 8390912, 8381696, 8374784, /* 10336-10343 */
8371200, 8372224, 8375040, 8386048, 8401664, 8416768, 8423168, 8415488, /* 10344-10351 */
8402432, 8386560, 8377088, 8370176, 8368384, 8375040, 8382464, 8385536, /* 10352-10359 */
8382976, 8384000, 8384256, 8383488, 8377856, 8374272, 8374016, 8379904, /* 10360-10367 */
8391168, 8394496, 8391936, 8391424, 8401408, 8417536, 8429824, 8438784, /* 10368-10375 */
8439040, 8429568, 8415744, 8400128, 8383232, 8361216, 8343040, 8335104, /* 10376-10383 */
8336896, 8341248, 8358400, 8376576, 8395776, 8402432, 8404992, 8401152, /* 10384-10391 */
8387840, 8374272, 8363776, 8359936, 8354816, 8350208, 8353792, 8365056, /* 10392-10399 */
8387072, 8404224, 8420352, 8433920, 8454144, 8464896, 8463104, 8450304, /* 10400-10407 */
8431104, 8406528, 8382208, 8363520, 8353792, 8351744, 8354304, 8357376, /* 10408-10415 */
8365056, 8375296, 8380928, 8379904}; /* 10416-10419 */