/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include <stdio.h>
#include <string.h>


#include "ble/services/UARTService.h"

#define NEED_CONSOLE_OUTPUT 0 /* Set this if you need debug messages on the console;
* it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
#define DEBUG(...) { printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */



Serial pc(USBTX, USBRX);
BLEDevice  ble;
DigitalOut led1(P0_13);
DigitalOut led2(P0_14);
DigitalOut led3(P0_15);
DigitalOut led4(P0_16);
InterruptIn button1(P0_11);
 uint8_t state;
 uint8_t open;
 
 uint8_t longble[255];
 uint8_t lb=0 ;

UARTService *uartServicePtr;

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    ble.startAdvertising();
}
/*
void opendoor()
{
    led4=0;
    led3=1;
    wait(3);
    led4=0;
    led3=0;
    wait(10);
    led4=1;
    led3=0;
    wait(3);
    led4=0;
    led3=0;
    
    }*/

void onDataWritten(const GattWriteCallbackParams *params)
{
    if ((uartServicePtr != NULL) && (params->handle == uartServicePtr->getTXCharacteristicHandle())) {
      //  uint16_t bytesRead = params->len;
        DEBUG("received %u bytes\n\r", bytesRead);
        ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, params->len);//  uint16_t bytesRead = params->len;
        if(((*(params->data))=='<')&&((*(params->data+1))=='S')&&((*(params->data+2))=='>')){ //  <S>    
            lb=0;
            memset(longble,'\0',sizeof(longble));
         
            }
        if(((*(params->data))=='<')&&((*(params->data+1))=='E')&&((*(params->data+2))=='>')){ //  <E> 
        uint8_t target[255]; 
        memcpy( target, longble + 3, strlen((const char*)longble) ); 
        pc.printf("%S\r\n",target);
        //  pc.printf("%S\r\n",longble)  ;
        // pc.printf("%d\r\n",(sizeof(longble)))  ; 
        }
        
        uint8_t blein[params->len];       
        for(uint8_t count=0 ; count<((params->len)) ; ++count){   //取得藍芽資料
            blein[count]= *((params->data)+count);
            longble[count+lb]= *((params->data)+count);
            }
        //x=0;    
        lb+=(params->len);
        if(lb>110)
        lb=0;

 //       uint8_t *a; 
 //       uint8_t test[]  = "OPEN";
       // a = longble;   
        //ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), a, 20);

        //ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), params->data, params->len);//  uint16_t bytesRead = params->len;        
            
        //uint8_t test[]  = "123456789012345678901";
       // uint8_t *a;
        //a = test;
        // ble.updateCharacteristicValue(uartServicePtr->getRXCharacteristicHandle(), a, params->len);
    }
}

void button1_pressed()
{   

    }

void periodicCallback(void)
{
    led1 = !led1;
    led2= state;
    if (open==1){
        open=0;
        led3=0;
        led4=1;
        wait(1);
        led3=1;
        led4=0;
        wait(1);
        led3=0;
        led4=0;
        }

}

int main(void)
{
    led1 = 1;
    led2 = 1;
    led3 = 1;
    led4 = 1;
    Ticker ticker;
    ticker.attach(periodicCallback, 1);

    DEBUG("Initialising the nRF51822\n\r");
    ble.init();
    ble.onDisconnection(disconnectionCallback);
    ble.onDataWritten(onDataWritten);

    /* setup advertising */
    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED);
    ble.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME,
                                     (const uint8_t *)"BLE UART", sizeof("BLE UART") - 1);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS,
                                     (const uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.setAdvertisingInterval(1000); /* 1000ms; in multiples of 0.625ms. */
    ble.startAdvertising();

    UARTService uartService(ble);
    uartServicePtr = &uartService;

    while (true) {
        ble.waitForEvent();
    }
}
