#ifndef NEOPIXEL_H
#define NEOPIXEL_H
#include "mbed.h"
#include <vector>

/*
// Example

NeoPixelOut npx(D12,6);//出力ピン　LEDの個数

int main() {
    wait(0.2); // wait for HSE to stabilize
    
    npx.global_scale = 1.0f; // Adjust brightness　明るさを変えるとき以外書かなくていいよ。
    npx.normalize = true; // Equalize brightness to make r + g + b = 255 falseでいい気がする。
    
    npx.setPixelColor(0,0xff0000);
    npx.setPixelColor(1,0xffff00);
    npx.setPixelColor(2,0x00ff00);
    npx.setPixelColor(3,0x00ffff);
    npx.setPixelColor(4,0x0000ff);
    npx.setPixelColor(5,0xff00ff);
    
    npx.show();
    
    while(1);
}
*/



/**
 * @brief Struct for easy manipulation of RGB colors.
 *
 * Set components in the xrgb.r (etc.) and you will get
 * the hex in xrgb.num.
 */
union Pixel {
    /** Struct for access to individual color components */
    struct __attribute__((packed)) {
        uint8_t b;
        uint8_t g;
        uint8_t r;
        uint8_t a; // unused
    };

    /** RGB color as a single uint32_t */
    uint32_t hex;
};


class NeoPixelOut : DigitalOut {
private:
    void byte(uint32_t b);
    int num_pixels_;
    vector<Pixel> strip_;
    
public:
    bool normalize;
    float global_scale; 

    NeoPixelOut(PinName pin, int num = 0);
    
    void send(Pixel *colors, uint32_t count, bool flipwait=true);
    void changeNum(uint32_t num);
    void setBrightness(float brightness);//0～1
    void setPixelColor(uint32_t i,uint32_t color);
    void show();
    void off(bool flag = true);//送信するかしないか。デフォルトでする。
    uint32_t color(uint8_t b,uint8_t g,uint8_t r);
    int numPixels();
    
    /** Wait long enough to make the colors show up */
    void flip(void);
};


#endif /* NEOPIXEL_H */