#ifndef LIDARLite_h
#define LIDARLite_h

#include <mbed.h>

/*このライブラリは、Arduinoのlidar lite v3ライブラリを移植したものです。
 *I2C i2c(PB_4,PA_7);
 *LIDARLite lidar_x(i2c);
 *I2Cのクラスオブジェクトをあらかじめ作り、参照渡ししてください。
 */

const char  LIDARLITE_ADDR_DEFAULT = 0x62 << 1;

class LIDARLite
{
    public:
        LIDARLite(I2C &i2c);
        void begin(int = 0, char = LIDARLITE_ADDR_DEFAULT);
        void configure(int = 0, char = LIDARLITE_ADDR_DEFAULT);
        void setI2Caddr(char, bool, char = LIDARLITE_ADDR_DEFAULT);
        void reset(char = LIDARLITE_ADDR_DEFAULT);
        int distance(bool = true, char = LIDARLITE_ADDR_DEFAULT);
        void write(char, char, char = LIDARLITE_ADDR_DEFAULT);
        void read(char, int, char*, bool, char );
        void correlationRecordToSerial(char = '\n', int = 256, char = LIDARLITE_ADDR_DEFAULT);
    private:
        I2C &i2c_;
};

#endif