#include "Matrice.h"

Matrice ::~Matrice(){
   if (_spi) delete _spi; // destruction de l'objet SPI
   if (_cs) delete _cs;
   // delete les carres while matrice
}

Matrice::Matrice()
{
_spi=NULL;
_cs=NULL;
state=false;
 for ( int i =0; i<=64;i++)
      {
          buffer[i]= 0x00;
      } 
      
for (int row = 0; row <= 3; row++)
    {
        for (int col=0; col <= 3; col++)
        {
          matrice1[row][col]=NULL;
        }
    }
}

Matrice::Matrice(SPI * spi,DigitalOut *cs ){ // Constructeur avec la liason SPI 
   for ( int i =0; i<=64;i++)
      {
          buffer[i]= 0x00;
      } 
      
for (int row = 0; row <= 3; row++)
    {
        for (int col=0; col <= 3; col++)
        {
          matrice1[row][col]=NULL;
        }
    }
  beginSPI(spi, cs);
  
}


 void Matrice::ajoutCarre(char x, char y, int couleur)
{
 if (x<=3 || y<=3)
  {
      if ( matrice1[x][y]) delete (matrice1[x][y]);
      matrice1[x][y] =  new Carre(couleur); 
  }
}

void Matrice::supprimerCarre(char x, char y)
{
  if (matrice1[x][y]!=NULL)
  {
  delete (matrice1[x][y]);
  matrice1[x][y] = NULL;
  }
}

void Matrice::setDispo()
{
 for (int row = 0; row <= 3; row++)
    {
        for (int col=0; col <= 3; col++)
        {
          if (matrice1 [row][col]==NULL) matricedispo[row][col] = 0;
          else matricedispo[row][col] = 1;
        }
    }

}


void Matrice::ajoutCarreAleatroire()
{
  int y;
  int x;
  int couleur;
  couleur = rand()%1;

do {
  y=rand()%3;
  x=rand()%3;
 }
 while(matrice1[x][y]!= NULL);
 
 matrice1[x][y] = new Carre(couleur); 
}

void Matrice::matricetobuffer()
{
int position=0; 
               
for (int row = 0; row <= 3; row++)
    {
        for (int col=0; col <= 3; col++)
        {
          if (matrice1[row][col]!=NULL)
          {
             ajoutCarretobuffer(position,matrice1[row][col]->getCouleur()) ;
          }
          position=position+1;
        }
    }

    
}


void Matrice::beginSPI( SPI * spi, DigitalOut *cs){
       state=false;
       if (_spi) delete _spi; // on verifie qu'une liason spi n'existe pas déja 
       _spi=spi;  
       if (_cs)delete _cs;//Creation du Chip Select/ 
        _cs=cs;      
       if (_spi && _cs)
       { 
        state = true; // Etat de la liason SPI
        _spi->format(8); // 8 bits de données 
        _spi->frequency(100000); // frequence 10khz -> Max 125khz
        _cs->write(1); // CS/ a 1)
        }
    
   }
  
void Matrice::ecrireMatrice()
{
    matricetobuffer();
    if (state == true)
    {
    // Select the device by seting chip select low
       _cs->write(0);

    wait_ms(1);
    //Ecriture des 64 leds
    for ( int i =0; i<=64;i++)
    {
       _spi->write(buffer[i]);
     }
   wait_ms(1);
    // Remontee de CS/
    _cs->write(1);
    }   
}

void Matrice::ajoutCarretobuffer (int position,int couleur)
{
  switch(position) {
    case 0 : 
            // dessin du carre
            buffer[0]= couleur;
            buffer[1]= couleur;
            buffer[8]= couleur;
            buffer[9]= couleur;          
             break;       
    case 1 :  
            buffer[2]= couleur;
            buffer[3]= couleur;
            buffer[10]= couleur;
            buffer[11]= couleur;                 
            break;     
              
    case 2 : 
            buffer[4]= couleur;
            buffer[5]= couleur;
            buffer[12]= couleur;
            buffer[13]= couleur;
             break;    
       
    case 3 : 
            buffer[6]= couleur;
            buffer[7]= couleur;
            buffer[14]= couleur;
            buffer[15]= couleur;
             break;        
             
     case 4 : 
            buffer[16]= couleur;
            buffer[17]= couleur;
            buffer[24]= couleur;
            buffer[25]= couleur;
             break; 
     case 5 : 
            buffer[18]= couleur;
            buffer[19]= couleur;
            buffer[26]= couleur;
            buffer[27]= couleur;
             break; 
     
     case 6 : 
            buffer[20]= couleur;
            buffer[21]= couleur;
            buffer[28]= couleur;
            buffer[29]= couleur;
             break; 
             
     case 7 :    
            buffer[22]= couleur;
            buffer[23]= couleur;
            buffer[30]= couleur;
            buffer[31]= couleur;
             break; 
             
    case 8 :    
            buffer[32]= couleur;
            buffer[33]= couleur;
            buffer[40]= couleur;
            buffer[41]= couleur;
             break;         
    
     
       case 9 :  
            buffer[34]= couleur;
            buffer[35]= couleur;
            buffer[42]= couleur;
            buffer[43]= couleur;
             break;         
    
     
      
      case 10 :   
            buffer[36]= couleur;
            buffer[37]= couleur;
            buffer[44]= couleur;
            buffer[45]= couleur;
             break;         
    
     
       case 11 :     
            buffer[38]= couleur;
            buffer[39]= couleur;
            buffer[46]= couleur;
            buffer[47]= couleur;
             break;    
             
         case 12 : 
            buffer[48]= couleur;
            buffer[49]= couleur;
            buffer[56]= couleur;
            buffer[57]= couleur;
             break;  
             
         case 13 :     
            buffer[50]= couleur;
            buffer[51]= couleur;
            buffer[58]= couleur;
            buffer[59]= couleur;
             break;  
                  
         case 14 :   
            buffer[52]= couleur;
            buffer[53]= couleur;
            buffer[60]= couleur;
            buffer[61]= couleur;
             break;            
     
       case 15 :     
            buffer[54]= couleur;
            buffer[55]= couleur;
            buffer[62]= couleur;
            buffer[63]= couleur;
             break;            
     
 }
    

}
