/**
  ******************************************************************************
  * @file    main.h
  * @author  You
  * @version V?.?.?
  * @date    Today
  * @brief   メインのヘッダファイル
  ******************************************************************************
  */

/* ヘッダ再呼び出し防止のための定義 ------------------------------------------*/

#ifndef _MAIN_H_
#define _MAIN_H_

/* ファイル追加 --------------------------------------------------------------*/
#include "YKNCT.h"
#include "mbed.h"
#include "YKNCT_I2C.h"
#include <math.h>
#include "BNO055.h"

/* 定数定義 ------------------------------------------------------------------*/
#define CIRCLE sbdbt.CIRCLE
#define SQUARE sbdbt.SQUARE
#define CROSS  sbdbt.CROSS
#define TRIANGLE  sbdbt.TRIANGLE
#define LEFTkey  sbdbt.LEFTkey
#define RIGHTkey  sbdbt.RIGHTkey
#define UPkey  sbdbt.UPkey
#define DOWNkey  sbdbt.DOWNkey

#define M_PI 3.14159265359

/* マクロ定義 ----------------------------------------------------------------*/
//#define PALETTE(color)\
//for(int s=0; s<3; s++) LED[s]=color&1<<s
#define PALETTE(color)\
for(int s=0; s<3; s++)\
i2c.Out_Set(Out_Data, s+6, color&1<<s)\

/* 型定義 --------------------------------------------------------------------*/

typedef enum {
    BLACK,
    BLUE,
    RED,
    MAGENTA,
    GREEN,
    CYAN,
    YELLOW,
    WHITE,

    COLOR_MAX

} _COLOR_;

MD_I2C_Data_TypeDef MD_Data[] = {
    { 8, 0, 0, 0, {0}},     //足回り
    { 9, 1, 0, 0, {0}},
    {10, 0, 0, 0, {0}},
    {11, 1, 0, 0, {0}},
    {12, 0, 0, 0, {0}},     // 洗濯物回収
    {13, 1, 0, 0, {0}},     // 上下機構
    {14, 0, 0, 0, {0}},     // 洗濯物排出
    {15, 1, 0, 0, {0}}      // 左右移動
};

IN_I2C_Data_TypeDef In_Data[] = {
    {1,0,0},        // 洗濯物排出(初期位置)
    {1,1,0},        // 洗濯物排出(停止)
    {1,2,0},        // 腕(最大  タオル)
    {1,3,0},         // 腕(初期位置)
    {3,0,0},        // 上下機構(上)
    {3,1,0},        //        (下)
    {3,2,0},         // 腕(シーツ兼シャツ）
    {3,3,0},         // ゾーン切り替え
    {0,0,0},         // 竿検知
};

OUT_I2C_Data_TypeDef Out_Data[] = {
    {0,0,0},        // 腕の上下
    {0,1,0},        // 爪
    {0,2,0},        // タオルの先
    {1,0,0},        // タオルの中央
    {1,1,0},        // 全体
    {1,2,0},        // タオル展開
    {41,0,0},        // g
    {41,1,0},        // r
    {41,2,0},        // b;
};
/* 変数宣言 ------------------------------------------------------------------*/

/* 関数宣言 ------------------------------------------------------------------*/
//メカナム基本動作
void mecanum_Move(int lx, int ly, int rx);

//角度補正
//n_angle: 現在の角度
//t_angle: 目標の角度
void AngleCorrection(double n_angle, double t_angle);

/*クラス宣言-------------------------------------------------------------------*/
Y_I2C i2c(PB_9, PB_8);           // I2C
SBDBT sbdbt(PA_0, PA_1, 9600);   // SDBDT
BNO055 bno(PC_9, PA_8);
DigitalOut LED[]= {PA_10,PB_4,PB_5};
Serial pc(USBTX, USBRX, 115200);

//半自動の時に使う
Timer tim;

//角度補正の時に使う
Timer drift_tim;

//上下移動の保持に使う
Timer keep_tim[2];

#endif /* _MAIN_H_ */

/******************************** END OF FILE *********************************/
