/* ファイル追加 --------------------------------------------------------------*/
//#include "YKNCT.h"
#include "encoder.h"
//#include "mbed.h"
/* MDを使用しない場合は以下ソースを読み込まない */
//#ifdef YKNCT_EX_ENCODER_ENABLED

/* 型定義 --------------------------------------------------------------------*/

/* 定数定義 ------------------------------------------------------------------*/
// encoder pins: p5 = CS, p6 = CLK,p8 = DO
 Encoder encoder[Encoder_MAX] = {
          Encoder(PC_1,PC_0,PC_3),
};
/* マクロ定義 ----------------------------------------------------------------*/

/* 変数定義 ------------------------------------------------------------------*/
double enc[Encoder_MAX][2]={0};
/* 関数プロトタイプ宣言 ------------------------------------------------------*/

/* 関数定義 ------------------------------------------------------------------*/

/**
  */
  
void encoder_conversion(){
     //エンコーダの処理
     // 角度取得,26回に1度だけ実行される
        if(encoder->Encoder_Read(encoder,1)) {
            
 }
      
}
  
Encoder::Encoder(PinName p1,PinName p2,PinName p3) : CS(p1), CLK(p2), DO(p3)
{
    
}

int Encoder::Encoder_Read(Encoder *e,uint8_t MAX)
{
    static uint8_t cnt = 0;                 /* 読み取り処理用カウント */

    /* カウントが奇数 */
    if(cnt%2 == 1) {
        /* カウントが1以外 */
        if(cnt != 1) {
            for(int i=0; i<MAX; i++) {
                /* データ読み取り用のピンが1なら変数の対応するビットに1を立てる */
                if(e[i].DO) {
                    e[i].read_buf |= ((e[i].DO) << ((25-cnt)/2));
                }
            }
        }

        /* カウントが25以外 */
        if(cnt != 25) {
            /* CLKをLOWに */
            CLK = 0;
        }
        /* カウントが25 */
        else {
            /* CSをHIGHに */
            CS = 1;

            for(int i=0; i<MAX; i++) {
                /* 読み取り完了したデータを格納 */
                e[i].read_val = e[i].read_buf;
                /* 読み取りデータを角度に変換して格納 */
                e[i].degree = (uint32_t)e[i].read_val * 360 / 4096;
                /* バッファクリア */
                e[i].read_buf = 0;
            }

            /* 読み取り完了の知らせ */
            cnt = 0;
            return 1;
        }
    }
    /* カウントが偶数 */
    else {
        /* CLKをHIGHに */
        CLK = 1;

        if(cnt == 0) {
            /* CSをLOWに */
            CS = 0;
        }
    }

    cnt++;     /* カウントアップ */

    return 0;
}


//#endif /* YKNCT_EX_ENCODER_ENABLED */

/******************************** END OF FILE *********************************/
