#include "YKNCT_I2C.h"

Y_I2C::Y_I2C(PinName sda, PinName scl) : i2c(sda, scl)
{
    i2c.frequency(100000);
}

void Y_I2C::Out_Set(OUT_I2C_Data_TypeDef *OUT_I2C_Data, uint8_t num, uint8_t value)
{
    (OUT_I2C_Data+num) -> out_data =value;
}

void Y_I2C::Out(OUT_I2C_Data_TypeDef *OUT_I2C_Data, uint8_t MAX)
{
    int cnt=0; //何個出力したかを保存する
    int ad_cnt=0; //同じアドレスの数を保存する
    while(cnt<MAX) {
        char data=0;
        int tmp_address=(OUT_I2C_Data+cnt)->DevAddress+59;
        
        //同じアドレスの数を数える
        for(ad_cnt=0;; ad_cnt++) {
            if(tmp_address!=(OUT_I2C_Data+cnt+ad_cnt)->DevAddress+59)
                break;
        }
        //一枚の基板に出力するデータを格納する
        for(int j=0; j<ad_cnt; j++) data|=(OUT_I2C_Data+cnt+j)->out_data<<j;

        i2c.write(((OUT_I2C_Data+cnt)->DevAddress+59)<<1, &data, 1);
        cnt+=ad_cnt;
    }
}

void Y_I2C::Servo_Set(SERVO_I2C_Data_TypeDef *SERVO_I2C_Data, uint8_t num, uint16_t pulse)
{
    (SERVO_I2C_Data+num)->pulse=pulse;
}

//4biteづつ送信する
void Y_I2C::Servo(SERVO_I2C_Data_TypeDef *SERVO_I2C_Data, uint8_t MAX)
{
    for(int i=0; i<(MAX+1)/2; i++) {
        char data[4]= {0};
        
        //MAXが奇数で最後の時
        if(i==MAX/2 && MAX%2==1) {
            for(int j=0; j<2; j++)
                //16bitのpulse1つを8bitづつに分けてdataに保存する
                data[j]=(SERVO_I2C_Data+i*2+j/2)->pulse>>(1-j%2)*8;
        } else {
            for(int j=0; j<4; j++)
                //16bitのpulse2つを8bitづつに分けてdataに保存する
                data[j]=(SERVO_I2C_Data+i*2+j/2)->pulse>>(1-j%2)*8;
        }
        i2c.write(((SERVO_I2C_Data+i)->DevAddress+93)<<1, data, 4);
    }
}

void Y_I2C::In(IN_I2C_Data_TypeDef *IN_I2C_Data, uint8_t num)
{
    char data;
    uint8_t array=(IN_I2C_Data+num)->Number;

    i2c.read(((IN_I2C_Data+num)->DevAddress+25)<<1, &data, 1);

    (IN_I2C_Data+num)->in_data=data&1<<array;
}

void Y_I2C::Adc(ADC_I2C_Data_TypeDef *ADC_I2C_Data, uint8_t num)
{
    char data[8]= {0};
    uint8_t array=(ADC_I2C_Data+num)->Number;
//  adc 42 line 110
    i2c.read((((ADC_I2C_Data+num) -> DevAddress)+42)<<1, data, 8);

    (ADC_I2C_Data+num)->adc_data=data[array*2+1]<<8|data[array*2];
}

void Y_I2C::Enc(ENC_I2C_Data_TypeDef *ENC_I2C_Data, uint8_t num)
{
    char data[4]= {0};

    i2c.read(((ENC_I2C_Data+num) -> DevAddress+76)<<1, data, 4);

    (ENC_I2C_Data+num)->enc_data=data[3]<<24|data[2]<<16|data[1]<<8|data[0];
}

void Y_I2C::MD_I2C(MD_I2C_Data_TypeDef *MD_I2C_Data, uint8_t num)
{
    /* 送信データ
      [0] [ MD出力更新 | 0 | 0 | 0 | 0 | ブレーキ | 回転方向 | MD指定 ]
      [1] PWM値(7bit)
    */

    /* 送信データをMD更新フラグを立てて初期化 */
    (MD_I2C_Data + num)->pData[0] = 0x80;
    /* モーターの駆動状態によってデータセット */
    switch (MD_GET_DRIVE(MD_I2C_Data, num)) {
        /* ブレーキ，ﾌﾞﾚｰｷﾋﾞｯﾄ 1，回転方向ﾋﾞｯﾄ 0 */
        /* 0b00000100 */
        case MD_BRAKE:
            (MD_I2C_Data + num)->pData[0] |= 0x02 << 1;
            break;
        /* 正転，ﾌﾞﾚｰｷﾋﾞｯﾄ 0，回転方向ﾋﾞｯﾄ 1 */
        /* 0b00000001 */
        case MD_FORWARD:
            (MD_I2C_Data + num)->pData[0] |= 0x01 << 1;
            break;
        /* 逆転，ﾌﾞﾚｰｷﾋﾞｯﾄ 0，回転方向ﾋﾞｯﾄ 0 */
        /* 0b00000000 */
        case MD_REVERSE:
            (MD_I2C_Data + num)->pData[0] |= 0x00 << 1;
            break;
    }

    /* PIC上の出力番号を指定 */
    /* 0b00000000 or 0b00000001 */
    (MD_I2C_Data + num)->pData[0] |= (MD_I2C_Data + num)->Number;
    /* PWM値が100より大きかったら範囲内に補正 */
    if (MD_GET_PWM(MD_I2C_Data, num) > 99)
        MD_SET_PWM(MD_I2C_Data, num, 99);

    /* PWM(0～100)を0～127に変換して代入(オーバーフロー防止で16bitに一時変換) */
    (MD_I2C_Data + num)->pData[1] = (uint8_t)((uint16_t)MD_GET_PWM(MD_I2C_Data, num) * 127 / 100);

    /*8bitから7bitに変換*/
    i2c.write((MD_I2C_Data + num)->DevAddress << 1,(MD_I2C_Data + num)->pData,2);
}

/**
  * @brief  MDに通信確認用送信
  * @param  MD_I2C_Data: I2C式MDデータ構造
  * @param  num: 使用MD番号
  * @retval なし
  * @detail I2C式MD側が通信が切れていないことを確認するために空データを送信する
  */
void Y_I2C::MD_I2C_Empty(MD_I2C_Data_TypeDef *MD_I2C_Data, uint8_t num)
{
    /* 送信データをMD更新フラグを立てず初期化 */
    (MD_I2C_Data+num)->pData[0] = 0;

    /* PIC上の出力番号を指定 */
    /* 0b00000000 or 0b00000001 */
    (MD_I2C_Data+num)->pData[0] |= (MD_I2C_Data+num)->Number;

    /*8bitから7bitに変換*/
    i2c.write((MD_I2C_Data + num)->DevAddress << 1,(MD_I2C_Data + num)->pData,2);
}