/* ヘッダ再呼び出し防止のための定義 ------------------------------------------*/
#ifndef INCLDUED_encoder_h_
#define INCLDUED_encoder_h_
#define Encoder_MAX 1

/* ファイル追加 --------------------------------------------------------------*/
//#include "YKNCT_def.h"
#include "mbed.h"

/* 定数定義 ------------------------------------------------------------------*/

/* マクロ定義 ----------------------------------------------------------------*/

/**
  * @brief  エンコーダー構造に読み取ったデータを取得する
  * @param  __ENCODER__: エンコーダー配列
  * @param  __NUMBER__: エンコーダー配列の番号
  * @retval 読み取りデータ(0-0xFFF)
  */
#define ENCODER_GET_VAL(__ENCODER__, __NUMBER__) \
(((__ENCODER__)+ (__NUMBER__))->read_val)

/**
  * @brief  エンコーダー構造に読み取った角度を取得する
  * @param  __ENCODER__: エンコーダー構造
  * @param  __NUMBER__: エンコーダー構造の番号
  * @retval 読み取り角度(0-359)
  */
#define ENCODER_GET_DEGREE(__MD_DATA__, __NUMBER__)\
(((__MD_DATA__) + (__NUMBER__))->degree)

/* 変数宣言 ------------------------------------------------------------------*/

/* 関数宣言 ------------------------------------------------------------------*/
void encoder_conversion(void);

/** 
 *
 * Example:
 * @code
 * #include "mbed.h"
 * #include "encoder.h"
 *
 * // encoder pins: p5 = CS, p6 = CLK,p8 = DO
 * // 複数用いる場合は以下のように書いてください
 *  Encoder encoder[Encoder_MAX] = {
 *          Encoder(p5,p6,p8),
 *          Encoder(p5,p6,p7)
 * };
 *
 * int main() {
 *    while(1){
 *      //エンコーダの処理
 *      // 角度取得,26回に1度だけ実行される
 *      if(encoder->Encoder_Read(encoder,Encoder_MAX)) {
 *
 *        for(int i=0; i<Encoder_MAX; i++) {
 *
 *           //前回の値更新 
 *           //今回の値更新(エンコーダの値(0～4096)を角度(0～360)に)
 *           deg[i][1] = deg[i][0];
 *           deg[i][0] = ENCODER_GET_VAL(encoder,i)*360.0/4096.0;
 *
 *           //前回270度以上，今回90度より小さい… 359→0を跨いだ時前回の値を0から逆回転で負の値で表記 
 *           if((270 <= deg[i][1] ) && (deg[i][0] < 90)) deg[i][1]-= 360;
 *
 *           //0→359を跨いだ時，前回の値を360以上の値で表記
 *          else if((deg[i][1] < 90) && (270 <= deg[i][0])) deg[i][1]+= 360;
 *
 *       }
 *
*       }
 *    }
 * }
 * @endcode
 */

class Encoder
{
public:
     /** Create an encoder object connected to the specified pins.
     *
     * @param p1 CS
     * @param p2 CLK
     * @param p3 DO
     */
    Encoder(PinName p1,PinName p2,PinName p3);
    /** ロータリーエンコーダから角度を取得する関数
     *
     * @param *e  クラスオブジェクトの配列の先頭アドレス
     * @param MAX 使用するエンコーダ個数
     */
    int Encoder_Read(Encoder *e,uint8_t MAX);
    uint16_t            read_buf;  /* 読み取りデータ処理用の一時保存領域 */
    uint16_t            read_val;  /* 読み取りデータ(0-0xFFF) */
    int16_t             degree;    /* 読み取りデータを角度(0-360)に変換した値 */
    
private:
    DigitalOut CS;       /* CSポートピンデータ構造 */
    DigitalOut CLK;      /* CLKポートピンデータ構造 */
    DigitalIn DO;       /* DOポートピンデータ構造 */
};


/**
  * @}
  */



/* 型定義 --------------------------------------------------------------------*/
extern double enc[Encoder_MAX][2];
extern Encoder encoder[Encoder_MAX];

#endif /* _YKNCT_EX_ENCODER_H_ */



/******************************** END OF FILE *********************************/
