#include "SBDBT.h"
//#include "YKNCT.h"
SBDBT::SBDBT(PinName p1, PinName p2)
{
    i = 0;
    readable = 0;
    length = 8;
    value = 255;
    position = 0;
    tmp = new char [length];
    data = new char [length];
    sr = new Serial(p1,p2);
    sr -> baud(2400);
    sr -> attach(this,&SBDBT::getf,Serial::RxIrq);
}

SBDBT::SBDBT(PinName p1, PinName p2, int baud)
{
    i = 0;
    readable = 0;
    length = 8;
    value = 255;
    position = 0;
    tmp = new char [length];
    data = new char [length];
    sr = new Serial(p1,p2);
    sr -> baud(baud);
    sr -> attach(this,&SBDBT::getf,Serial::RxIrq);
}

void SBDBT::getf()
{
    tmp[i] = sr -> getc();
    if(tmp[i] == value) {  //受信したデータが訂正用定数であり
        if(i != position) {     //訂正用定数を受信すべき位置でないとき
            tmp[position] = value;     //正しい位置に訂正用定数を代入
            i = position + 1;           //受信先も正しい位置へもどす
        } else                  //訂正用定数を受信すべき位置であるとき
            i++;                    //次の位置で受信する
    } else {                //受信したデータが訂正用定数でなく
        if(i == position) {}    //訂正用定数を受信すべき位置であるとき
        //再度同じ位置で受信する
        else                    //訂正用定数を受信すべき場所でないとき
            i++;                    //次の位置で受信する
    }
    if(i>=length) {         //位置がデータの長さを超えたら
        data[0] = tmp[0];
        data[1] = tmp[1];
        data[2] = tmp[2];
        data[3] = tmp[3];
        data[4] = tmp[4];
        data[5] = tmp[5];
        data[6] = tmp[6];
        data[7] = tmp[7];
        readable = 1;               //全データ受信完了
        check();
        i=0;                    //位置を初期化
    }
}

void SBDBT::print()
{
    printf("%2d%2d%2d%2d%2d%2d%2d%2d%2d%2d\n\r",TRIANGLE,CIRCLE,CROSS,SQUARE,UPkey,RIGHTkey,DOWNkey,LEFTkey,SELECT,START);
}

int8_t SBDBT::State_check()
{
    if(readable == 1)return 1;
    else return 0;
}

void SBDBT::check()
{
    SQUARE=(data[1] & 1)==1;
    L1 =   (data[1] & 2)==2;
    L2 =   (data[1] & 4)==4;
    L3 =   (data[1] & 8);
    R1 =   (data[1] & 16);
    R2 =   (data[1] & 32);
    R3 =   (data[1] & 64);
    PS = (data[1] & 128);

    UPkey =    (data[2] & 1)==1&&(data[2] & 2)!=2;
    DOWNkey =  (data[2] & 2)==2&&(data[2] & 1)!=1;
    START   =  (data[2] & 3)==3;
    RIGHTkey = (data[2] & 4)==4&&(data[2] & 8)!=8;
    LEFTkey =  (data[2] & 8)==8&&(data[2] & 4)!=4;
    SELECT  =  (data[2] & 12)==12;
    TRIANGLE = (data[2] & 16)==16;
    CROSS =    (data[2] & 32)==32;
    CIRCLE =   (data[2] & 64)==64;

    LX = data[3];
    LY = data[4];
    RX = data[5];
    RY = data[6];
}


char SBDBT::rs_x_check()
{
    return data[5]==data[5] ? 0 : 1;
}

char SBDBT::rs_y_check()
{
    return data[6]==data[6] ? 0 : 1;
}

char SBDBT::ls_x_check()
{
    return data[3]==data[3] ? 0 : 1;
}

char SBDBT::ls_y_check()
{
    return data[4]==data[4] ? 0 : 1;
}

SBDBT::~SBDBT()
{
    delete sr;
    delete tmp;
    delete data;
}