#ifndef INCLUDED_CONSTE_h_
#define INCLUDED_CONSTE_h_

#include "mbed.h"

/* マクロ定義 ----------------------------------------------------------------*/

/* 定数定義 ------------------------------------------------------------------*/

/* クラス定義 ----------------------------------------------------------------*/

/*******************************************************************************
 * @名称   CONSTE
 * @概要   2021Aチーム コントロールステーション受信クラス

 *****受信データフォーマット(6byte)*****
 | [COBS] | βββββββX | XXXXXXXX | XXXXXXXX | YZαααααα | [COBS] |
 timeMs   17bit X タイマーの時間[ms]
 isstart   1bit Y タイマーが動いているか否か
 isEMO     1bit Z 非常停止状態か否か
 Status    6bit α 2bit×3台のステータス
 CheckSUM  7bit β XYZαααの十進数1桁ずつの合計

 *****送信データフォーマット-ロボット*****
 | XYY000ZZ |
 isRimocon 1bit X 0
 number    2bit Y 識別番号 0…のあ 1…ねぷちゅーん 2…とりとん
 Status    2bit Z ステータス　1…モード異常 2…座標追従失敗 3…正常

 *****送信データフォーマット-リモコン*****
 | XYZαββββ |
 isRimocon 1bit X 1
 number    1bit Y 識別番号 0…リモコン1 1…リモコン2
 isEMO     1bit Z 非常停止状態か否か
 isEMO     1bit α タイマーが動いているか否か
 battery   4bit β バッテリー残量(4bitADC)


*******************************************************************************/
class CONSTE
{
private:

    /* 受信割り込み用関数 */
    void uartRX(void);
    /* 送信割り込み用関数 */
    void uartTX(void);

    /* タイマ割り込み用関数 */
    void IT_CallBack(void);

    uint8_t severalRX;

    Timeout shotIT;
    Ticker ticker;

    /* 受信生データ */
    uint8_t readLoc;
    uint8_t readData[255];
    /* 処理済みデータ */
    uint8_t arrayRestore[4];

public:
    int hoge;

    Serial uart;
    Timer lostRX;
    Timer timeUpdate;

    CONSTE(PinName tx, PinName rx, int baud);

    /* 受信データ */
    //タイマ時間(ms)
    uint32_t timeMs;
    // タイマが動いてるか否か
    bool isStart;
    // 非常停止状態 (trueの時はモーターを止めてください)
    bool isEMO;
    // ロボットの状態 1…モード異常 2…座標追従失敗 3…正常
    uint8_t RobotStat[3];


    /* 送信データ */
    // 識別番号 0…のあ 1…ねぷちゅーん 2…とりとん 4…リモコン1 6…リモコン2
    uint8_t identificationNum;
    /* ロボット送信データ */
    // ロボットの状態 1…モード異常 2…座標追従失敗 3…正常
    uint8_t status;
    /* リモコン送信データ */
    // 非常停止SW状態
    bool swEMO;
    // スタートSW状態
    bool swStart;
    // バッテリ電圧 (4bit)
    uint8_t batteryRemain;
};

#endif