#include "conste.h"

/*******************************************************************************
 * @名称   CONSTE
 * @概要   2021Aチーム コントロールステーション受信クラス
*******************************************************************************/
CONSTE::CONSTE(PinName tx, PinName rx, int baud) : uart(tx,rx,baud)
{
    uart.attach(this,&CONSTE::uartRX, Serial::RxIrq);
    ticker.attach_us(this,&CONSTE::IT_CallBack, 1000);

    /* 配列要素数 */
    severalRX = 6;

    lostRX.start();
    timeUpdate.start();
}
void CONSTE::IT_CallBack(void)
{
    timeMs += isStart;
}

void CONSTE::uartTX(void)
{
    uint16_t sendData = 0;

    sendData |= (identificationNum & 0x07) << 9;

    /* 送信データフォーマットがリモコン */
    if(sendData & 0x800) {
        sendData |= swStart << 9;
        sendData |= swEMO << 8;
        sendData |= batteryRemain & 0xFF;
    }
    /* 送信データフォーマットがロボット */
    else {
        sendData |= status & 0x03;
    }
    uart.printf("TXSB 0001,");
    uart.putc((sendData>>8&0x0f) + '0');
    uart.putc((sendData>>4&0x0f) + '0');
    uart.putc((sendData>>0&0x0f) + '0');
    uart.printf("\r\n");
}
void CONSTE::uartRX(void)
{
    uint8_t getData = uart.getc();
    lostRX.reset();

    /* ヘッダー受信時の処理 */
    if(getData == '\n') {
        hoge = readLoc;
        if(readLoc == 3) {
            readLoc = 0;
            return;
        }
        readLoc = 0;

        for(int i = 0; i < 4; i++)
            arrayRestore[i] = readData[i * 2 + 11] << 4 | readData[i * 2 + 12];

        uint32_t sumData = 0;
        sumData |= (arrayRestore[0] & 0x01) << 24;
        sumData |= (arrayRestore[1] & 0xFF) << 16;
        sumData |= (arrayRestore[2] & 0xFF) << 8;
        sumData |= (arrayRestore[3] & 0xFF) << 0;
        uint8_t checkSum = 0;
        for (int i = 0; i < 26; i++)
            checkSum += sumData / (int)pow(10.0, (double)i) % 10;

        /* チェックサム整合性がとれるならデータ更新 */
        if(checkSum == (arrayRestore[0] & 0xFE) >> 1) {
            isStart = (arrayRestore[3] >> 7) & 0x01;
            isEMO = (arrayRestore[3] >> 6) & 0x01;

            if(!isStart) {

                timeMs = 0;
                timeMs |= (arrayRestore[0] & 0x01) << 16;
                timeMs |= (arrayRestore[1] & 0xFF) << 8;
                timeMs |= (arrayRestore[2] & 0xFF) << 0;
            }

            RobotStat[0] = (arrayRestore[3] >> 4) & 0x03;
            RobotStat[1] = (arrayRestore[3] >> 2) & 0x03;
            RobotStat[2] = (arrayRestore[3] >> 0) & 0x03;
        }

        /* 送信処理 */
        int num[7] = {2,3,4,-1,0,-1,1};
        shotIT.attach(this,&CONSTE::uartTX, num[identificationNum]*0.020);
//uartTX();
    }
    /*データ受信時の処理 */
    else {
        readData[readLoc] = getData - '0';
        readLoc++;
    }
}
