#ifndef PID_H
#define PID_H

#include "mbed.h"


class PID {
public:
  PID();
  float control(float target, float nowrpm, Timer *timer);
  float PI_lateD(float target, float nowrpm, Timer *timer);
  float control_P(float target, float nowrpm, float new_Kp);
  float control_PI(float target, float nowrpm, Timer *timer);
  void setParameter_pid(float new_Kp, float new_Ki, float new_Kd);
  void setParameter_KuPu(float new_Ku, float new_Pu);
  void reset(float target);

  float Ku;
  float Pu;
  float Kp;
  float Ti;
  float Td;
  float Ki;
  float Kd;

private:
  Timer *timer;
  float integral;
  float prev_hensa;
  float nowtime;
  float prev_time;
  float lateD;
};

#endif
