#ifndef MSEQ_H
#define MSEQ_H

#include "mbed.h"

/**
 * @brief M-sequence (maximum length sequence) generator
 */
class Mseq
{
private:
    //! シフトレジスタのビット数
    uint8_t n;
    
    //! シフトレジスタ本体
    //! reg[0](LSB)が出力
    //! reg[n](MSB)がフィードバック先
    //! 更新時にはregが右に1bitずつしふとされていく
    uint32_t reg;
    
    //! regの更新時にfeedbackするbitの位置
    uint32_t coef;
    
public:
    Mseq(uint8_t _n);
    void reset();
    void reset(uint8_t _n);
    uint8_t update();
    uint8_t getOutput() const;
    uint32_t getRegister() const;
};

#endif