#ifndef FPOINTER_H
#define FPOINTER_H

#include "mbed.h"

class FpointerDummy;

class Fpointer
{
protected:
  //! C callback function pointer
  void (*c_callback)(int);

  //! C;; callback object/method pointer (this object part)
  FpointerDummy *obj_callback;

  //! C;; callback object/method pointer (this method part)
  void(FpointerDummy::*method_callback)(int);

public:
  Fpointer()
  {
      c_callback = NULL;
      obj_callback = NULL;
      method_callback = NULL;
  }

  void attach(void (*function)(int) = 0)
  {
      c_callback = function;
  }

  template<class T>
  void attach(T* obj, void(T::*method)(int))
  {
      obj_callback = (FpointerDummy *)obj;
      method_callback = (void (FpointerDummy:: *)(int))method;
  }

  void call(int arg)
  {
      if(c_callback != NULL)
      {
          (*c_callback)(arg);
      }
      else
      {
          if(obj_callback != NULL && method_callback != NULL)
          {
              (obj_callback->*method_callback)(arg);
          }
      }
  }
};

#endif