#include "mbed.h"

PwmOut ENA(D11);
DigitalOut IN1(D3);
DigitalOut IN2(D4);
PwmOut ENB(D12);
DigitalOut IN3(D5);
DigitalOut IN4(D6);
AnalogIn dial(A0);
AnalogIn distance(A1);

int main() {
    ENA.period(0.01);
    ENB.period(0.01);
    ENA=0;
    ENB=0;
    IN1=1;
    IN2=0;
    IN3=1;
    IN4=0;
    int turncount=0; //左回転の回数をカウント
    int turnTh=5;   //左回転の閾値
    while(1){
        float pwm = dial.read();
        float dist=distance.read();
        printf("%f,%f\n",pwm,dist);
        if(dist<0.5){
            //障害物がない時
            IN1=1;
            IN2=0;
            IN3=1;
            IN4=0;
            turncount=0;
        } else {
            //障害物がある時
            if(turncount < turnTh){
                //一定時間は左回転
                IN1=1;
                IN2=0;
                IN3=0;
                IN4=1;
                turncount++;
            } else {
                //ターンの回数が多い，一定以上左回転したら右回転に切替
                IN1=0;
                IN2=1;
                IN3=1;
                IN4=0;
            }
            wait(0.1);
        }
        ENA = pwm;
        ENB = pwm;
    }
}
