#include "mbed.h"
#include "SDFileSystem.h"
#include "BMP085.h"
#include "ADXL345_I2C.h"
//#include "camera.h"
#include "FastJpegCamera.h"

SDFileSystem sd(p5, p6, p7, p8, "sd");

ADXL345_I2C accelerometer(p28, p27);
BMP085 bmp085(p28, p27);

Serial pc(USBTX, USBRX);
Serial xbee(p13, p14);

Timer timer;

AnalogIn ain_CDS(p15);
AnalogIn ain_Humidity(p16);
AnalogIn ain_LM35DZ(p20);


DigitalOut myled(LED1);

int fileio() {
    mkdir("/sd/20014", 0777);
    
    FILE *fp = fopen("/sd/mydir/datalog.txt", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
 
    printf("Goodbye World!\n");
    
    return(0);
}


int main() {
    timer.start();
    pc.printf("main() started. pc.baud is 9600 at this time.");
    //pc.baud(9600);
    xbee.baud(115200);
    myled = 1;
 
    int readings[3] = {0, 0, 0};
    
    pc.printf("Starting ADXL345 test...\n");
    wait(.001);
    pc.printf("Device ID is: 0x%02x\n", accelerometer.getDeviceID());
    wait(.001);
    
    // These are here to test whether any of the initialization fails. It will print the failure
    if (accelerometer.setPowerControl(0x00)){
        pc.printf("didn't intitialize power control\n"); 
        return 0;  
    }
    //Full resolution, +/-16g, 4mg/LSB.
    wait(.001);
     
    if(accelerometer.setDataFormatControl(0x0B)){
        pc.printf("didn't set data format\n");
        return 0;  }
    wait(.001);
    
    //3.2kHz data rate.
    if(accelerometer.setDataRate(ADXL345_3200HZ)){
        pc.printf("didn't set data rate\n");
        return 0;
    }
    wait(.001);

    FastJpegCamera fast_jpeg_camera(p9, p10, xbee);

    //Measurement mode.
    
    if(accelerometer.setPowerControl(MeasurementMode)) {
        pc.printf("didn't set the power control to measurement\n"); 
        return 0;
    }
    myled = 0;
    
    int loop_count = 0;
    
    while (1) { 

        FILE *fp = fopen("/sd/sensor.csv", "a");
        loop_count += 1;
        
        char buf[100];

        sprintf(buf, "C %d ", loop_count);
        pc.printf(buf);
        fwrite(buf, strlen(buf), 1, fp);
        xbee.printf(buf);

        float seconds = timer.read();
        sprintf(buf, "S %.3f ", seconds);
        pc.printf(buf);
        fwrite(buf, strlen(buf), 1, fp);
        xbee.printf(buf);

        //wait(1.5);
        
        //BOSH BMP085 Barometric pressure,temperature measurement
        accelerometer.getOutput(readings);
        //pc.printf("ADXL345 ------------------------\n");
        sprintf(buf, "X %+4.3f Y %+4.3f Z %+4.3f ", 
            (float((int16_t)readings[0]+18)/256 - 0.12), 
            (float((int16_t)readings[1]-4 )/256 - 0.03), 
            (float((int16_t)readings[2]+22)/256 + 0.12));
        pc.printf(buf);
        fwrite(buf, strlen(buf), 1, fp);
        xbee.printf(buf);
        
        bmp085.update();
        
        //ADXL 345 Acceleration measurement
        //pc.printf("\nBOSH BMP085 --------------------\n");
        const float P = bmp085.get_pressure();
        const float T = bmp085.get_temperature();
        sprintf(buf, "P %6.2f T %6.2f ", P, T);
        pc.printf(buf);
        fwrite(buf, strlen(buf), 1, fp);
        xbee.printf(buf);
        
        //CSDS Ambient light measurement P15 analog-in1
        sprintf(buf, "L %f ",ain_CDS*100);
        pc.printf(buf);
        fwrite(buf, strlen(buf), 1, fp);
        xbee.printf(buf);
        
        //Humidity measurement P16 analog-in2
        const float SRH = ( ( ain_Humidity * 3.3 / 5.0 ) - 0.16 ) / 0.0062;
        const float TRH = SRH / ( 1.0546 - 0.00216 * T);
        
        sprintf(buf, "H %f ", TRH / 10.0); // maybe wrong, dirty workaround

        pc.printf(buf);
        fwrite(buf, strlen(buf), 1, fp);
        fwrite("\r\n", 2, 1, fp);
        fclose(fp);

        xbee.printf(buf);
        xbee.printf("\n");
        
        //LM35DZ Temperature measurement P20 analog-in6
        //this sensor does not work for now. disabled.
        //pc.printf("Temperature    :: %f\n",ain_LM35DZ*100);
        
        //take picture
        //main_camera(loop_count);
        xbee.printf("--JFIF_BOUNDARY\n");
        fast_jpeg_camera.shoot(loop_count);
        xbee.printf("--JFIF_BOUNDARY--\n");
    }
}