#include "mbed.h"
#include "SoftPWM.h"

#define LED_ON  0
#define LED_OFF 1

#define TIME_5ms    5
#define TIME_10ms   10
#define TIME_50ms   50
#define TIME_100ms  100
#define TIME_500ms  500
#define TIME_1s     1000

Ticker flipper;                                                 // Tick Timer

//DigitalOut led_r(PA_15);
PwmOut led_r(PA_15);
PwmOut led_g(PB_10);
PwmOut led_b(PB_11);
//SoftPWM led_r(PA_15);
//DigitalOut mosi(PA_7,PullUp);
//DigitalOut miso(PA_6,PullUp);
//DigitalOut sck(PA_5,PullUp);
SPI spi(PA_7,PA_6,PA_5);
DigitalOut cs(PA_4);
//DigitalOut rstble(PC_6,PullUp);
DigitalOut rstble(PC_6);

unsigned int syscnt = 0;                                        // SystemCounter
unsigned char flg_led   = 0;
unsigned char flg_cnt   = 0;
unsigned char flg_spi   = 0;
uint16_t cnt = 180;
double ledr_duty;                                                // LED-Red PWM duty
double ledg_duty;                                                // LED-Red PWM duty
double ledb_duty;                                                // LED-Red PWM duty

void flip() {
    syscnt++;                                                   // increment SystemCounter
    syscnt = syscnt % 86400000;

    if(syscnt % TIME_5ms == 0) {
        flg_cnt = 1;
    }

    if(syscnt % TIME_500ms == 0) {
        flg_led = 1;
    }

    if(syscnt % TIME_1s == 0) {
        flg_spi = 1;
    }
}

int main() {
 //   led_r = LED_OFF;
 //   led_g = LED_OFF;
 //   led_b = LED_OFF;

//    led_r.period();
//    led_r.period_ms(1);                                          // Set PWM Period 1ms
//    ledr_duty = 1.0f;                                           // Set Duty 0
//    led_r = ledr_duty;                                           // Set LED-Red Duty

//    led_g.period_ms(1);                                          // Set PWM Period 1ms
//    ledg_duty = 0.0f;                                           // Set Duty 0
//    led_g = ledr_duty;                                           // Set LED-Red Duty

//    led_b.period_ms(1);                                          // Set PWM Period 1ms
//    ledb_duty = 0.0f;                                           // Set Duty 0
//    led_b = ledr_duty;                                           // Set LED-Red Duty

    spi.format(8,3);
    spi.frequency(2000000);

    cs = 1;
    rstble = 0;
    wait(0.2);
    rstble = 1;
    wait(0.2);

    flipper.attach_us(&flip, 1000);                             // TickerTime Set 1ms

    while(1) {
        if(flg_led) {
            flg_led = 0;
//            led_g = !led_g;
        }

        if(flg_cnt) {
            flg_cnt = 0;
            ledr_duty = (sin(double(cnt) / 180 * 3.14f) + 1 ) / 2;
            ledg_duty = (sin(double((cnt + 120) % 360) / 180 * 3.14f) + 1 ) / 2;
            ledb_duty = (sin(double((cnt + 240) % 360) / 180 * 3.14f) + 1 ) / 2;
            led_r = ledr_duty;                                           // Set LED-Red Duty
            led_g = ledg_duty;                                           // Set LED-Red Duty
            led_b = ledb_duty;                                           // Set LED-Red Duty
            cnt++;
            cnt%=360;
        }

        if(flg_spi) {
            flg_spi = 0;

            spi.write(0x55);
        }

    }
}
