#include "mbed.h"
#include "Serial.h"
Serial pc(USBTX, USBRX);
Serial device(PA_2,PA_3);
Serial im920(PA_9,PA_10,19200);
DigitalOut led(LED1);
DigitalOut cam_sw1(D10);      //カメラの電源スイッチに接続（Highで電源ON）
DigitalOut cam_sw2(D9);      //カメラの撮影スイッチ(FET)に接続(HighでD-S導通)


char str[10];
int i=0;
int k=0;
void cmd(){
    while(1) {
        if(pc.readable()) { //IM920からのデータがある場合
            char temp = pc.getc();//一文字読み込む
            if(temp != '\r') { //読み込み文字が改行で無い場合
                str[i] = temp;
                i++;
            } else if(temp == '\r') { //読み込み文字が改行の場合
                if(str[i-1]=='S'||'s'){
                    cam_sw1 = 1;             //カメラの電源スイッチON
                    wait(3);
                    cam_sw1 = 0;
                    wait(10);                //カメラの電源ON
                    while(i<5){    
                        led=1;
                        wait(0.5);
                        i++;
                    }      
            }else if(str[i-1]=='T'||'t'){
                cam_sw2 = 1;             //撮影スイッチON(撮影開始指示)
                wait(0.2);               //撮影開始
                cam_sw2=0;
            }else if(str[i-1]=='E'||'e'){
                cam_sw2=1;               //撮影スイッチON(撮影終了指示)
                wait(0.2);               //撮影終了
                cam_sw2=0;
            }else if(str[i-1]=='A'||'a'||'B'||'b'||'C'||'c'){
                //device.putc(str);           
            }else{
                pc.printf("command error");
            }   
        }
    }    
}
}
int main(){
    pc.attach(cmd,Serial::RxIrq);
    while(1){
    }
} 
