#include "mbed.h"
#include "Servo.h"

Serial pc(USBTX,USBRX,9600);

DigitalIn switch1(A0);//モーター前転
DigitalIn switch2(A1);//モーター後転
DigitalIn switch3(A2);//アーム開く
DigitalIn switch4(A3);//アーム閉じる
DigitalIn switch5(A4);//左回転
DigitalIn switch6(A0);//右回転
DigitalIn switch7(A6);//モーター上がり
DigitalIn switch8(A7);//モーター下げ

DigitalOut motor1_E(D6);
PwmOut motor1_P(D7);
DigitalOut motor2_E(D9);
PwmOut motor2_P(D10);
Servo servo(D3);
PwmOut motor3_E(D11);
DigitalOut motor3_P(D12);

int main()
{
    float k = 0.001;
    while(1) {
        //pc.printf("%d\t%d\t%d\t%d\t%d\t%d\t%d\t%d\n", switch1.read(), switch2.read(),switch3.read(),switch4.read(),switch5.read(),switch6.read(), switch7.read(),switch8.read() );
        //wait(0.001);

        if(switch1==0) {
            motor1_E = 0.85;
            motor1_P = 0;
            motor2_E = 0.85;
            motor2_P = 0;
        } else if(switch2==0) {
            motor1_E = 0.85;
            motor1_P = 1;
            motor2_E = 0.85;
            motor2_P = 1;
        }
        else if(switch5==0) {
            motor1_E = 0.85;
            motor1_P = 0;
            motor2_E = 0.85;
            motor2_P = 1;
        } else if(switch6==0) {
            motor1_E = 0.85;
            motor1_P = 1;
            motor2_E = 0.85;
            motor2_P = 0;
        } else {
            motor1_E = 0;
            motor1_P = 0;
            motor2_E = 0;
            motor2_P = 0;
        }                           //回転                               //足回り


        if(switch3==0) {
            if(k <= 1.0) {
                k+=0.01;
                servo.write(k);
            }
        }//アーム開く
        else if(switch4==0) {
            if(0.0 <= k) {
                k-= 0.01;
                servo.write(k);
            }
        }//アーム閉じる

        if(switch7==0) {
            motor3_E = 1;
            motor3_P = 0;
        } else if(switch8==0) {
            motor3_E = 1;
            motor3_P = 1;
        } else {
            motor3_E = 0;
            motor3_P = 0;
        }

        //上げ下げ



    }
}
