/**
@file main.h
@brief Header file containing functions prototype, defines and global variables
@brief Revision 1.0.
@author Tarek I. AlKurdi
@date May 2015

*/

#include "mbed.h"
#include "BMP180.h"
#include "N5110.h"
#include "beep.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"


Serial serial(USBTX,USBRX);
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);  // VCC, GND, SCE, RST, DC, MOSI, CLK, LED

InterruptIn button(p16);
/**
@namespace button
@output for status button
*/
AnalogIn mypotentiometer(p20);
/**
@namespace mypotentimeter
@output for status potentiometer
*/
Beep buzzer(p21);
/**
@namespace buzzer
@output for status buzzer
*/
BMP180 bmp180(p28,p27);   // SDA, SCL

PwmOut greenled(p23);  // Green LED
/**
@namespace greenled
@output for status Green
*/

PwmOut redled(p24);    // RED LED
/**
@namespace redled
@output for status red
*/
Measurement value;




float P;

int buttonFlag=0;
 
#endif
