/**
@file main.cpp
@brief Program implementation

*/

#include "main.h"



void buttonPressed() {
    buttonFlag=!buttonFlag;
    }

int main()
{

    /// initiliase the barometer

    bmp180.init();
    lcd.init(); // initialise display

    lcd.printString("Welcome to",15,1); // display text on screen
    lcd.printString("Weather Station",20,2);
    lcd.printString("Project",6,3);
    lcd.printString("Tarek I. AlKurdi",0,5);
    wait(5.0); // wait for 5 seconds before refreshing the LCD to display the temperature

    lcd.clear();
    lcd.refresh();
    
    
    button.rise(&buttonPressed);
    
        while(1) {
            
            lcd.setBrightness(1.0); // put LED backlight on full
            
            P = mypotentiometer; 
            lcd.setBrightness(P);

            if(buttonFlag) {
                
                
                lcd.clear();
                lcd.refresh();
                
                char buffer[14];
                
                Measurement value;  // measurement structure declared in BMP180 class
                value = bmp180.readValues(); 
                wait(0.1);
                
                int length = sprintf(buffer, "T = %.2f K", value.temperature+273); // configuration of celsis to kelvin conversion
                if (length <= 14)
                    lcd.printString(buffer,0,1);// display value on LCD screen
                wait(0.1);

                length = sprintf(buffer, "P =%.2f P", value.pressure/1000); // coverting mili Pascal to pascal
                if (length <=14)
                    lcd.printString(buffer,0,2); // display the value on the LCD screen
                wait(0.1);
                
            } 
            else{
                
                lcd.clear();
                lcd.refresh(); // refresh the screen 
                
                char buffer[14];
                
                Measurement value;  // measurement structure declared in BMP180 class
                value = bmp180.readValues();  // set the value to the sensors reading
                wait(0.1);

                int length = sprintf(buffer, "T = %.2f C", value.temperature);
                if (length <= 14)
                    lcd.printString(buffer,0,1); // Display the temperature on the first line
                wait(0.1);

                length = sprintf(buffer, "P =%.2f mP", value.pressure); // Display the pressure on the 2nd line under the temp.
                if (length <=14)
                    lcd.printString(buffer,0,2);
                wait(0.1);
                //lcd.refresh();
            }
            
            Measurement value;  // measurement structure declared in BMP180 class
            value = bmp180.readValues(); // set values of sensor reading on the screen
            wait(0.1);
            

            if (value.temperature>22 && value.temperature<=28)  { // if the temp is between 22 and 28 celsius 
                greenled= 0; // LED OFF
                redled=1;  // LED ON
            }

            else if (value.temperature>28 && value.temperature<=31) { // if temp. between 28 and 31 celsius
                greenled=1; //LED ON
                redled=0;  // LED OFF
            }
            
            else {
                greenled=0; // LED OFF
                redled=0;  // LED OFF
                buzzer.beep(1000,0.5);  // Buzzer will be activated when the temp increases above 31 celsius
            }

            wait(0.01);

        }

    }