#include "mbed.h"
#include "EthernetNetIf.h"
#include "HttpServer.h"
#include "TextLCD.h"
//#include "HTTPRPC.h"
//#include "HTTPFS.h"

DigitalOut led1(LED1, "led1");
DigitalOut led2(LED2, "led2");
DigitalOut led3(LED3, "led3");
DigitalOut led4(LED4, "led4");
AnalogIn   ain(p15, "potm");

LocalFileSystem fs("webfs");

DigitalOut rw(p25);
TextLCD lcd(p26,p24,p23,p22,p20,p19, TextLCD::LCD20x4);


EthernetNetIf eth;
HttpServer svr;

int main() {
    rw = 0;

    Base::add_rpc_class<DigitalOut>();
    Base::add_rpc_class<AnalogIn>();
    lcd.cls();
    lcd.printf("Setting up..");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        lcd.printf("Error %d\n", ethErr);
        return -1;
    }
    lcd.printf("OK\n");
    IpAddr addr = eth.getIp();

//    svr.addHandler(new HttpServer());
    svr.addHandler<SimpleHandler>("/hello");
    svr.addHandler<RpcHandler>("/rpc");
    svr.addHandler<FSHandler>(""); //Default handler
    //Zet demo.htm in de root van de mbed.
    svr.bind(80);

    lcd.printf("Listening at http://%3d.%3d.%3d.%3d/webfs/demo.htm", addr[0], addr[1], addr[2], addr[3]);

    Timer tm;
    tm.start();
    //Listen indefinitely
    while (true) {
        Net::poll();
        if (tm.read()>.5) {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }


}
